/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.request;

import coldfusion.gcp.BucketReference;
import coldfusion.gcp.storage.exception.CFStorageException;
import coldfusion.util.RB;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.StorageClass;

public class LifecycleActionBuilder {
    private String type;
    private String storageClass;
    private BucketInfo.LifecycleRule.LifecycleAction lifecycleAction;

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
        this.lifecycleAction = BucketInfo.LifecycleRule.LifecycleAction.newSetStorageClassAction((StorageClass)StorageClass.valueOfStrict((String)storageClass));
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        switch (type.toUpperCase()) {
            case "DELETE": {
                this.lifecycleAction = BucketInfo.LifecycleRule.LifecycleAction.newDeleteAction();
                break;
            }
            case "SETSTORAGECLASS": {
                break;
            }
            case "ABORTINCOMPLETEMULTIPARTUPLOAD": {
                this.lifecycleAction = BucketInfo.LifecycleRule.LifecycleAction.newAbortIncompleteMPUploadAction();
                break;
            }
            default: {
                throw new CFStorageException(RB.getString(BucketReference.class, (String)"INVALID_LIFECYCLE_ACTION_TYPE", (Object)type));
            }
        }
    }

    public BucketInfo.LifecycleRule.LifecycleAction getLifecycleAction() {
        return this.lifecycleAction;
    }
}

