/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.gcp.storage.request.StorageBucketTargetOptionBuilder;
import coldfusion.gcp.storage.util.Validator;
import com.google.cloud.storage.Storage;
import java.util.Collections;

public enum StorageBucketTargetOptionConsumer {
    INSTANCE;

    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private ConsumerMap<StorageBucketTargetOptionBuilder> consumerMap = new ConsumerMap();

    private StorageBucketTargetOptionConsumer() {
        this.consumerMap.put((Object)"metaGenerationMatch", new ConsumerValidator((bucketTargetOptionBuilder, value) -> {
            Boolean metagenerationMatch = Validator.getBooleanProperty(value, "metaGenerationMatch");
            bucketTargetOptionBuilder.setMetagenerationMatch(metagenerationMatch);
        }, Collections.emptyList()));
        this.consumerMap.put((Object)"metaGenerationNotMatch", new ConsumerValidator((bucketTargetOptionBuilder, value) -> {
            Boolean metagenerationNotMatch = Validator.getBooleanProperty(value, "metaGenerationNotMatch");
            bucketTargetOptionBuilder.setMetagenerationNotMatch(metagenerationNotMatch);
        }, Collections.emptyList()));
        this.consumerMap.put((Object)"predefinedAcl", new ConsumerValidator((bucketTargetOptionBuilder, value) -> {
            String predefinedAcl = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)predefinedAcl, (String)"predefinedAcl");
            bucketTargetOptionBuilder.setPredefinedAcl(Storage.PredefinedAcl.valueOf((String)predefinedAcl));
        }, Collections.emptyList()));
        this.consumerMap.put((Object)"predefinedDefaultObjectAcl", new ConsumerValidator((bucketTargetOptionBuilder, value) -> {
            String predefinedDefaultObjectAcl = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)predefinedDefaultObjectAcl, (String)"predefinedDefaultObjectAcl");
            bucketTargetOptionBuilder.setPredefinedDefaultObjectAcl(Storage.PredefinedAcl.valueOf((String)predefinedDefaultObjectAcl));
        }, Collections.emptyList()));
        this.consumerMap.put((Object)"projection", new ConsumerValidator((bucketTargetOptionBuilder, value) -> {
            String userProject = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)userProject, (String)"projection");
            bucketTargetOptionBuilder.setUserProject(userProject);
        }, Collections.emptyList()));
        this.consumerMap.put((Object)"userProject", new ConsumerValidator((bucketTargetOptionBuilder, value) -> {
            String userProject = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)userProject, (String)"userProject");
            bucketTargetOptionBuilder.setUserProject(userProject);
        }, Collections.emptyList()));
    }

    public ConsumerMap<StorageBucketTargetOptionBuilder> getConsumerMap() {
        return this.consumerMap;
    }
}

