/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.EmptyListValidator;
import coldfusion.cloud.validator.NonEmptyStringValidator;
import coldfusion.gcp.storage.consumer.PolicyConditionConsumer;
import com.google.cloud.Binding;
import com.google.cloud.Condition;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PolicyBindingsConsumer
extends ConsumerMap<Binding.Builder> {
    private static final long serialVersionUID = -235948086009527038L;
    private static PolicyBindingsConsumer instance;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private ValidatorFiller filler = ValidatorFiller.INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PolicyBindingsConsumer getInstance() {
        if (instance != null) return instance;
        Class<PolicyBindingsConsumer> clazz = PolicyBindingsConsumer.class;
        synchronized (PolicyBindingsConsumer.class) {
            if (instance != null) return instance;
            instance = new PolicyBindingsConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private PolicyBindingsConsumer() {
        this.put("addMembers", new ConsumerValidator((builder, value) -> {
            String[] members = this.cast.getStringArrayProperty(value);
            if (members.length == 1) {
                builder.addMembers(members[0], new String[0]);
            } else {
                String[] otherMembers = Arrays.copyOfRange(members, 1, members.length);
                builder.addMembers(members[0], otherMembers);
            }
        }, Collections.singletonList(new EmptyListValidator("addMembers"))));
        this.put("removeMembers", new ConsumerValidator((builder, value) -> {
            String[] members = this.cast.getStringArrayProperty(value);
            builder.removeMembers(members);
        }, Collections.singletonList(new EmptyListValidator("removeMembers"))));
        this.put("condition", new ConsumerValidator((builder, value) -> {
            Condition.Builder conditionBuilder = Condition.newBuilder();
            Map map = this.cast.getMapProperty(value);
            this.filler.fillObject((Object)conditionBuilder, map, (ConsumerMap)PolicyConditionConsumer.getInstance());
            builder.setCondition(conditionBuilder.build());
        }, Collections.emptyList()));
        this.put("members", new ConsumerValidator((builder, value) -> {
            List members = this.cast.getStringListProperty(value);
            builder.setMembers((Iterable)members);
        }, Collections.singletonList(new EmptyListValidator("members"))));
        this.put("role", new ConsumerValidator((builder, value) -> {
            String role = this.cast.getStringProperty(value);
            builder.setRole(role);
        }, Collections.singletonList(NonEmptyStringValidator.INSTANCE)));
    }
}

