/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp;

import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.gcp.GCPCredential;
import coldfusion.cloud.util.CloudDeserializationUtil;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.gcp.BucketAsRootReference;
import coldfusion.gcp.BucketReference;
import coldfusion.gcp.GCPCredentialValidator;
import coldfusion.gcp.RootReference;
import coldfusion.gcp.StorageService;
import coldfusion.gcp.storage.consumer.CreateBucketRequestConsumer;
import coldfusion.gcp.storage.consumer.DeleteBucketRequestConsumer;
import coldfusion.gcp.storage.consumer.ListBucketRequestConsumer;
import coldfusion.gcp.storage.exception.CFStorageException;
import coldfusion.gcp.storage.pmt.util.GCPStorageApis;
import coldfusion.gcp.storage.pmt.util.PMTUtilForGCPStorage;
import coldfusion.gcp.storage.request.DeleteBucketRequest;
import coldfusion.gcp.storage.request.ListBucketRequest;
import coldfusion.gcp.storage.request.StorageConfigBuilder;
import coldfusion.gcp.storage.security.StorageHmacKey;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.Struct;
import coldfusion.util.RB;
import com.google.api.gax.paging.Page;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.testing.RemoteStorageHelper;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@GenerateCFNamedInvoke
public class StorageServiceImpl
implements StorageService {
    private Logger logger = CFLogs.SERVER_LOG;
    private Storage storageClient;
    private String projectId;
    private String credentialJSONFilePath;
    private GoogleCredentials gcpCredentials;
    private TagAttributeList tagAttributeList = new TagAttributeList("service", (Object)CloudServiceName.STORAGE.name());
    private ValidatorFiller filler = ValidatorFiller.INSTANCE;

    public StorageServiceImpl() {
    }

    public StorageServiceImpl(GCPCredential vendorCredential, StorageConfigBuilder storageConfig) {
        try {
            GCPCredentialValidator credentialValidator = new GCPCredentialValidator(vendorCredential);
            this.projectId = credentialValidator.getProjectId();
            this.credentialJSONFilePath = credentialValidator.getCredentialJSONFilePath();
            this.gcpCredentials = credentialValidator.getGcpCredentials();
            this.storageClient = System.getSecurityManager() == null ? this.getStorageClient(storageConfig) : AccessController.doPrivileged(() -> this.getStorageClient(storageConfig));
        }
        catch (StorageException e) {
            throw new CFStorageException(e.getMessage(), e);
        }
    }

    private Storage getStorageClient(StorageConfigBuilder storageConfig) {
        return (Storage)((StorageOptions.Builder)storageConfig.getStorageOptions().setCredentials((Credentials)this.gcpCredentials)).build().getService();
    }

    private RootReference root(String rootName) {
        this.logger.debug((Object)("Getting bucket reference with bucketName : " + rootName));
        if (!this.isBucketExists(rootName)) {
            this.logger.info((Object)"bucket not found");
            throw new ValidationException(RB.getString(StorageServiceImpl.class, (String)"bucketNotFound"));
        }
        BucketAsRootReference rootReference = new BucketAsRootReference(new BucketReference(this, rootName));
        return rootReference;
    }

    public RootReference root(String rootName, boolean createIfNotExists) {
        try {
            BucketAsRootReference ref;
            this.logger.debug((Object)("getting bucket reference in bucket( bucketName, createIfNotExists), bucketName : " + rootName));
            if (!this.isBucketExists(rootName) && createIfNotExists) {
                Bucket bucket = this.storageClient.create(BucketInfo.newBuilder((String)rootName).build(), new Storage.BucketTargetOption[0]);
                ref = new BucketAsRootReference(new BucketReference(this, rootName));
            } else if (this.isBucketExists(rootName)) {
                ref = new BucketAsRootReference(new BucketReference(this, rootName));
            } else {
                this.logger.debug((Object)(createIfNotExists ? "Bucket already exists" : "createIfNotExists is false"));
                throw new CFStorageException(RB.getString(StorageServiceImpl.class, (String)"createBucketIfNotExists"));
            }
            return ref;
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new CFStorageException(e.getMessage(), e);
        }
    }

    public RootReference bucket(Object bucket) {
        if (bucket instanceof Struct) {
            return this.bucket((Struct)bucket);
        }
        return this.bucket(String.valueOf(bucket));
    }

    private RootReference bucket(String bucketName) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.bucket, this.tagAttributeList);
        this.logger.debug((Object)("Getting bucket reference with bucketName : " + bucketName));
        if (!this.isBucketExists(bucketName)) {
            this.logger.info((Object)"bucket not found");
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.bucket, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", "Failure"));
            throw new ValidationException(RB.getString(StorageServiceImpl.class, (String)"bucketNotFound"));
        }
        BucketReference rootReference = new BucketReference(this, bucketName);
        PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.bucket, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", "Success"));
        return rootReference;
    }

    private RootReference bucket(Struct BucketRequest) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.bucket, this.tagAttributeList);
        String bucketName = "";
        BucketInfo.Builder builder = BucketInfo.newBuilder((String)bucketName);
        this.filler.fillObject((Object)builder, (Map)BucketRequest, (ConsumerMap)CreateBucketRequestConsumer.getInstance());
        BucketInfo request = builder.build();
        if (!this.isBucketExists(request.getName())) {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.bucket, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", "Failure"));
            throw new ValidationException(RB.getString(StorageServiceImpl.class, (String)"bucketNotFound"));
        }
        BucketReference ref = new BucketReference(this, request.getName());
        PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.bucket, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", "Success"));
        return ref;
    }

    private RootReference root(Struct BucketRequest) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.root, this.tagAttributeList);
        String bucketName = "";
        BucketInfo.Builder builder = BucketInfo.newBuilder((String)bucketName);
        this.filler.fillObject((Object)builder, (Map)BucketRequest, (ConsumerMap)CreateBucketRequestConsumer.getInstance());
        BucketInfo request = builder.build();
        if (!this.isBucketExists(request.getName())) {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.root, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", "Failure"));
            throw new ValidationException(RB.getString(StorageServiceImpl.class, (String)"bucketNotFound"));
        }
        BucketAsRootReference ref = new BucketAsRootReference(new BucketReference(this, request.getName()));
        PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.root, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", "Success"));
        return ref;
    }

    @Override
    public RootReference bucket(String bucketName, boolean createIfNotExists) {
        BucketReference ref;
        block8: {
            String action = "get";
            String status = "Success";
            TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.bucket, this.tagAttributeList);
            try {
                this.logger.debug((Object)("getting bucket reference in bucket( bucketName, createIfNotExists), bucketName : " + bucketName));
                if (!this.isBucketExists(bucketName) && createIfNotExists) {
                    action = "post";
                    Bucket bucketObj = this.storageClient.create(BucketInfo.newBuilder((String)bucketName).build(), new Storage.BucketTargetOption[0]);
                    ref = new BucketReference(this, bucketName);
                    break block8;
                }
                if (this.isBucketExists(bucketName)) {
                    ref = new BucketReference(this, bucketName);
                    break block8;
                }
                this.logger.debug((Object)(createIfNotExists ? "Bucket already exists" : "createIfNotExists is false"));
                status = "Failure";
                throw new CFStorageException(RB.getString(StorageServiceImpl.class, (String)"createBucketIfNotExists"));
            }
            catch (StorageException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                status = "Failure";
                throw new CFStorageException(e.getMessage(), e);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                status = "Failure";
                throw new CFStorageException(RB.getString(StorageServiceImpl.class, (String)"createBucketError"), e);
            }
            finally {
                PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.bucket, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap(action, status));
            }
        }
        return ref;
    }

    private RootReference createBucket(BucketInfo request) {
        this.storageClient.create(request, new Storage.BucketTargetOption[0]);
        BucketReference ref = new BucketReference(this, request.getName());
        return ref;
    }

    public RootReference createBucket(Struct createBucketRequest) {
        RootReference ref;
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.createBucket, this.tagAttributeList);
        String status = "Success";
        String bucketName = "";
        BucketInfo.Builder builder = BucketInfo.newBuilder((String)bucketName);
        this.filler.fillObject((Object)builder, (Map)createBucketRequest, (ConsumerMap)CreateBucketRequestConsumer.getInstance());
        BucketInfo request = builder.build();
        try {
            ref = this.createBucket(request);
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while creating bucket", (Throwable)e);
            status = "Failure";
            throw new CFStorageException(RB.getString(StorageServiceImpl.class, (String)"createBucketError"), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.createBucket, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("post", status));
        }
        return ref;
    }

    public RootReference createRoot(Struct bucketInfo) {
        BucketAsRootReference ref;
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.createRoot, this.tagAttributeList);
        String status = "Success";
        String bucketName = "";
        BucketInfo.Builder builder = BucketInfo.newBuilder((String)bucketName);
        this.filler.fillObject((Object)builder, (Map)bucketInfo, (ConsumerMap)CreateBucketRequestConsumer.getInstance());
        BucketInfo request = builder.build();
        try {
            ref = new BucketAsRootReference((BucketReference)this.createBucket(request));
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.createRoot, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("post", status));
        }
        return ref;
    }

    @Override
    public RootReference root(Object root) {
        if (root instanceof Struct) {
            return this.root((Struct)root);
        }
        return this.root(String.valueOf(root));
    }

    @Override
    public List<Struct> listAll() {
        LinkedList<Struct> bucketList = new LinkedList<Struct>();
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.listAll, this.tagAttributeList);
        String status = "Success";
        try {
            this.logger.debug((Object)"Calling GCP to list buckets");
            Page buckets = this.storageClient.list(new Storage.BucketListOption[0]);
            for (Bucket bucket : buckets.getValues()) {
                Struct bucketStruct = CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)bucket);
                if (bucketStruct.containsKey((Object)"options")) {
                    bucketStruct.remove((Object)"options");
                }
                if (bucketStruct.containsKey((Object)"createTime")) {
                    bucketStruct.put((Object)"createTime", (Object)new OleDateTime(bucket.getCreateTime().longValue()));
                }
                if (bucketStruct.containsKey((Object)"updateTime")) {
                    bucketStruct.put((Object)"updateTime", (Object)new OleDateTime(bucket.getUpdateTime().longValue()));
                }
                bucketList.add(bucketStruct);
            }
            Struct bucketExtraInfo = new Struct();
            if (buckets.getNextPageToken() != null) {
                bucketExtraInfo.put((Object)"nextPageToken", (Object)buckets.getNextPageToken());
            }
            if (!bucketExtraInfo.isEmpty()) {
                bucketList.add(bucketExtraInfo);
            }
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.listAll, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", status));
        }
        return bucketList;
    }

    @Override
    public List<Struct> list(Struct bucketListOption) {
        ArrayList<Struct> bucketList = new ArrayList<Struct>();
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.list, this.tagAttributeList);
        String status = "Success";
        try {
            this.logger.debug((Object)"call started for Listing buckets with struct option");
            ListBucketRequest request = new ListBucketRequest();
            this.filler.fillObject((Object)request, (Map)bucketListOption, (ConsumerMap)new ListBucketRequestConsumer());
            Storage.BucketListOption[] listOptions = new Storage.BucketListOption[request.getOptions().size()];
            Page buckets = this.storageClient.list(request.getOptions().toArray(listOptions));
            for (Bucket bucket : buckets.getValues()) {
                Struct bucketStruct = CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)bucket);
                if (bucketStruct.containsKey((Object)"options")) {
                    bucketStruct.remove((Object)"options");
                }
                if (bucketStruct.containsKey((Object)"createTime")) {
                    bucketStruct.put((Object)"createTime", (Object)new OleDateTime(bucket.getCreateTime().longValue()));
                }
                if (bucketStruct.containsKey((Object)"updateTime")) {
                    bucketStruct.put((Object)"updateTime", (Object)new OleDateTime(bucket.getUpdateTime().longValue()));
                }
                bucketList.add(bucketStruct);
            }
            Struct bucketExtraInfo = new Struct();
            if (buckets.getNextPageToken() != null) {
                bucketExtraInfo.put((Object)"nextPageToken", (Object)buckets.getNextPageToken());
            }
            if (!bucketExtraInfo.isEmpty()) {
                bucketList.add(bucketExtraInfo);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Error while listing bucket" + e));
            status = "Failure";
            throw new CFStorageException(RB.getString(StorageServiceImpl.class, (String)"listBucketError"), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.list, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", status));
        }
        return bucketList;
    }

    @Override
    public Struct delete(Object bucket) {
        if (bucket instanceof Struct) {
            return this.delete((Struct)bucket);
        }
        return this.delete(String.valueOf(bucket));
    }

    private Struct delete(String bucketName) {
        Struct delResp;
        block8: {
            delResp = new Struct();
            TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.delete, this.tagAttributeList);
            String status = "Success";
            try {
                if (!this.isBucketExists(bucketName)) {
                    throw new ValidationException(RB.getString(StorageServiceImpl.class, (String)"bucketNotFound"));
                }
                boolean deleted = this.storageClient.delete(bucketName, new Storage.BucketSourceOption[0]);
                if (deleted) {
                    delResp.put((Object)"status", (Object)"Success");
                    delResp.put((Object)"message", (Object)(bucketName + " is successfully deleted."));
                    break block8;
                }
                throw new CFStorageException(RB.getString(StorageServiceImpl.class, (String)"deleteBucketError"));
            }
            catch (StorageException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                status = "Failure";
                throw new CFStorageException(e.getMessage(), e);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                status = "Failure";
                throw new CFStorageException(RB.getString(StorageServiceImpl.class, (String)"deleteBucketError"), e);
            }
            finally {
                PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.delete, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("delete", status));
            }
        }
        return delResp;
    }

    private Struct delete(Struct bucketOption) {
        Struct delResp = new Struct();
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.delete, this.tagAttributeList);
        String status = "Success";
        DeleteBucketRequest request = new DeleteBucketRequest();
        try {
            this.filler.fillObject((Object)request, (Map)bucketOption, (ConsumerMap)DeleteBucketRequestConsumer.getInstance());
            if (request.getTimeout() != 0L) {
                if (request.getUserProject() != null) {
                    RemoteStorageHelper.forceDelete((Storage)this.storageClient, (String)request.getBucketName(), (long)request.getTimeout(), (TimeUnit)request.getUnit(), (String)request.getUserProject());
                } else {
                    RemoteStorageHelper.forceDelete((Storage)this.storageClient, (String)request.getBucketName(), (long)request.getTimeout(), (TimeUnit)request.getUnit());
                }
            } else {
                Storage.BucketSourceOption[] bucketSourceOption = new Storage.BucketSourceOption[request.getBucketSourceOption().size()];
                if (!this.isBucketExists(request.getBucketName())) {
                    status = "Failure";
                    throw new ValidationException(RB.getString(StorageServiceImpl.class, (String)"bucketNotFound"));
                }
                boolean deleted = this.storageClient.delete(request.getBucketName(), request.getBucketSourceOption().toArray(bucketSourceOption));
                if (!deleted) {
                    status = "Failure";
                    throw new CFStorageException(RB.getString(StorageServiceImpl.class, (String)"deleteBucketError"));
                }
            }
            delResp.put((Object)"status", (Object)"Success");
            delResp.put((Object)"message", (Object)(request.getBucketName() + " is successfully deleted."));
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(RB.getString(StorageServiceImpl.class, (String)"deleteBucketError"), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.delete, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("delete", status));
        }
        return delResp;
    }

    public Struct getHmacKey(Map getHmacKeyOption) {
        return StorageHmacKey.getHmacKey(this.storageClient, getHmacKeyOption);
    }

    public Struct updateHmacKeyState(Map updateHmacKeyOption) {
        return StorageHmacKey.updateHmacKeyState(this.storageClient, updateHmacKeyOption);
    }

    public Struct createHmacKey(Map CreateHmacKeyOption2) {
        return StorageHmacKey.createHmacKey(this.storageClient, CreateHmacKeyOption2);
    }

    public Struct deleteHmacKey(Map deleteHmacKeyOption) {
        return StorageHmacKey.deleteHmacKey(this.storageClient, deleteHmacKeyOption);
    }

    public Struct listHmacKeys(Map listHmacKeysOption) {
        return StorageHmacKey.listHmacKeys(this.storageClient, listHmacKeysOption);
    }

    private boolean isBucketExists(String bucketName) {
        boolean bucketExist = false;
        try {
            Page buckets = this.storageClient.list(new Storage.BucketListOption[0]);
            for (Bucket bucket : buckets.iterateAll()) {
                if (!bucketName.equalsIgnoreCase(bucket.getName())) continue;
                bucketExist = true;
            }
        }
        catch (Exception ex) {
            throw new CFStorageException(RB.getString(StorageServiceImpl.class, (String)"errorCheckingBucketExistence"), ex);
        }
        return bucketExist;
    }

    Storage getStorageClient() {
        return this.storageClient;
    }
}

