/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.discovery;

import java.util.ArrayList;
import org.apache.commons.jcs.utils.discovery.UDPDiscoveryAttributes;
import org.apache.commons.jcs.utils.discovery.UDPDiscoverySender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPDiscoverySenderThread
implements Runnable {
    private static final Log log = LogFactory.getLog(UDPDiscoverySenderThread.class);
    private final UDPDiscoveryAttributes attributes;
    private ArrayList<String> cacheNames = new ArrayList();

    protected void setCacheNames(ArrayList<String> cacheNames) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Resetting cacheNames = [" + cacheNames + "]"));
        }
        this.cacheNames = cacheNames;
    }

    protected ArrayList<String> getCacheNames() {
        return this.cacheNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UDPDiscoverySenderThread(UDPDiscoveryAttributes attributes, ArrayList<String> cacheNames) {
        this.attributes = attributes;
        this.cacheNames = cacheNames;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating sender thread for discoveryAddress = [" + attributes.getUdpDiscoveryAddr() + "] and discoveryPort = [" + attributes.getUdpDiscoveryPort() + "] myHostName = [" + attributes.getServiceAddress() + "] and port = [" + attributes.getServicePort() + "]"));
        }
        UDPDiscoverySender sender = null;
        try {
            sender = new UDPDiscoverySender(attributes.getUdpDiscoveryAddr(), attributes.getUdpDiscoveryPort());
            sender.requestBroadcast();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Sent a request broadcast to the group");
            }
        }
        catch (Exception e) {
            log.error((Object)"Problem sending a Request Broadcast", (Throwable)e);
        }
        finally {
            try {
                if (sender != null) {
                    sender.destroy();
                }
            }
            catch (Exception e) {
                log.error((Object)"Problem closing Request Broadcast sender", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        UDPDiscoverySender sender = null;
        try {
            sender = new UDPDiscoverySender(this.attributes.getUdpDiscoveryAddr(), this.attributes.getUdpDiscoveryPort());
            sender.passiveBroadcast(this.attributes.getServiceAddress(), this.attributes.getServicePort(), this.cacheNames);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Called sender to issue a passive broadcast");
            }
        }
        catch (Exception e) {
            log.error((Object)("Problem calling the UDP Discovery Sender [" + this.attributes.getUdpDiscoveryAddr() + ":" + this.attributes.getUdpDiscoveryPort() + "]"), (Throwable)e);
        }
        finally {
            if (sender != null) {
                try {
                    sender.destroy();
                }
                catch (Exception e) {
                    log.error((Object)"Problem closing Passive Broadcast sender", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        UDPDiscoverySender sender = null;
        try {
            sender = new UDPDiscoverySender(this.attributes.getUdpDiscoveryAddr(), this.attributes.getUdpDiscoveryPort());
            sender.removeBroadcast(this.attributes.getServiceAddress(), this.attributes.getServicePort(), this.cacheNames);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Called sender to issue a remove broadcast in shudown.");
            }
        }
        catch (Exception e) {
            log.error((Object)"Problem calling the UDP Discovery Sender", (Throwable)e);
        }
        finally {
            try {
                if (sender != null) {
                    sender.destroy();
                }
            }
            catch (Exception e) {
                log.error((Object)"Problem closing Remote Broadcast sender", (Throwable)e);
            }
        }
    }
}

