/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.firestore.pmt.util;

import coldfusion.cloud.gcp.firestore.pmt.util.GCPFirestoreApis;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.monitor.util.RequestMonitorData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PMTUtilForGCPFirestore {
    public static TagAttributeList startGCPStorageMonitoring(GCPFirestoreApis name, TagAttributeList tagAttributeList) {
        RequestMonitorData rmd = RequestMonitorData.getCurrent();
        if (rmd != null && rmd.doMonitor()) {
            RequestMonitorEventProcessor.onFunctionStart((String)name.name(), null, (boolean)true);
            TagAttributeList temp = TagAttributeList.getInstance((TagAttributeList)tagAttributeList);
            return temp;
        }
        return null;
    }

    public static void endGCPStorageMonitoring(GCPFirestoreApis name, TagAttributeList tempAttributeList, Map responseMap) {
        if (tempAttributeList == null) {
            return;
        }
        if (responseMap != null) {
            PMTUtilForGCPFirestore.updateTagAttributeList(name, tempAttributeList, responseMap);
        }
        RequestMonitorEventProcessor.onFunctionEnd((String)name.name(), null, (List)TagAttributeList.getInstance((TagAttributeList)tempAttributeList).getTagAttributes(), (boolean)true);
    }

    private static void updateTagAttributeList(GCPFirestoreApis name, TagAttributeList tempAttributeList, Map responseMap) {
        try {
            if (!Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isCloudServiceMetrics()) {
                return;
            }
            switch (name) {
                case getAll: 
                case listCollections: 
                case listDocuments: 
                case getDocument: 
                case get: 
                case runQuery: {
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    break;
                }
                case add: 
                case create: 
                case set: 
                case update: {
                    tempAttributeList.addTagAttribute("OperationType", (Object)"write");
                    break;
                }
                case delete: {
                    tempAttributeList.addTagAttribute("OperationType", (Object)"delete");
                    break;
                }
                case select: {
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    tempAttributeList.addTagAttribute("QueryFilter", (Object)GCPFirestoreApis.select);
                    break;
                }
                case whereGreaterThan: {
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    tempAttributeList.addTagAttribute("QueryFilter", (Object)GCPFirestoreApis.whereGreaterThan);
                    break;
                }
                case whereArrayContains: {
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    tempAttributeList.addTagAttribute("QueryFilter", (Object)GCPFirestoreApis.whereArrayContains);
                    break;
                }
                case whereArrayContainsAny: {
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    tempAttributeList.addTagAttribute("QueryFilter", (Object)GCPFirestoreApis.whereArrayContainsAny);
                    break;
                }
                case whereEqualTo: {
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    tempAttributeList.addTagAttribute("QueryFilter", (Object)GCPFirestoreApis.whereEqualTo);
                    break;
                }
                case whereGreaterThanOrEqualTo: {
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    tempAttributeList.addTagAttribute("QueryFilter", (Object)GCPFirestoreApis.whereGreaterThanOrEqualTo);
                    break;
                }
                case whereLessThan: {
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    tempAttributeList.addTagAttribute("QueryFilter", (Object)GCPFirestoreApis.whereLessThan);
                    break;
                }
                case whereLessThanOrEqualTo: {
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    tempAttributeList.addTagAttribute("QueryFilter", (Object)GCPFirestoreApis.whereLessThanOrEqualTo);
                    break;
                }
                case whereIn: {
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    tempAttributeList.addTagAttribute("QueryFilter", (Object)GCPFirestoreApis.whereIn);
                    break;
                }
                case whereNotEqualTo: {
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    tempAttributeList.addTagAttribute("QueryFilter", (Object)GCPFirestoreApis.whereNotEqualTo);
                    break;
                }
                case whereNotIn: {
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    tempAttributeList.addTagAttribute("QueryFilter", (Object)GCPFirestoreApis.whereNotIn);
                    break;
                }
                case orderBy: {
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    tempAttributeList.addTagAttribute("QueryFilter", (Object)GCPFirestoreApis.orderBy);
                    break;
                }
                case startAt: {
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    tempAttributeList.addTagAttribute("QueryFilter", (Object)GCPFirestoreApis.startAt);
                    break;
                }
                case startAfter: {
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    tempAttributeList.addTagAttribute("QueryFilter", (Object)GCPFirestoreApis.startAfter);
                    break;
                }
                case endAt: {
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    tempAttributeList.addTagAttribute("QueryFilter", (Object)GCPFirestoreApis.endAt);
                    break;
                }
                case endBefore: {
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    tempAttributeList.addTagAttribute("QueryFilter", (Object)GCPFirestoreApis.endBefore);
                    break;
                }
                case limit: {
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    tempAttributeList.addTagAttribute("QueryFilter", (Object)GCPFirestoreApis.limit);
                    break;
                }
                case limitToLast: {
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    tempAttributeList.addTagAttribute("QueryFilter", (Object)GCPFirestoreApis.limitToLast);
                    break;
                }
                case offset: {
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    tempAttributeList.addTagAttribute("QueryFilter", (Object)GCPFirestoreApis.offset);
                }
            }
            if (responseMap.get("action") != null) {
                tempAttributeList.addTagAttribute("action", responseMap.get("action"));
            }
            if (responseMap.get("status_code") != null) {
                tempAttributeList.addTagAttribute("status_code", responseMap.get("status_code"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Map getMonitoringResponseMap(String action, String statusCode) {
        HashMap<String, String> responseMap = new HashMap<String, String>();
        if (action != null) {
            responseMap.put("action", action);
        }
        if (statusCode != null) {
            responseMap.put("status_code", statusCode);
        }
        return responseMap;
    }

    public static Map getMonitoringResponseMap(String statusCode) {
        HashMap<String, String> responseMap = new HashMap<String, String>();
        if (statusCode != null) {
            responseMap.put("status_code", statusCode);
        }
        return responseMap;
    }
}

