/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.firestore.impl;

import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.gcp.firestore.FirestoreCollectionReference;
import coldfusion.cloud.gcp.firestore.FirestoreDocumentReference;
import coldfusion.cloud.gcp.firestore.codecs.FirestoreSerializer;
import coldfusion.cloud.gcp.firestore.impl.FirestoreDocumentReferenceImpl;
import coldfusion.cloud.gcp.firestore.impl.FirestoreQueryImpl;
import coldfusion.cloud.gcp.firestore.pmt.util.GCPFirestoreApis;
import coldfusion.cloud.gcp.firestore.pmt.util.PMTUtilForGCPFirestore;
import coldfusion.cloud.gcp.firestore.util.FirestoreUtils;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.runtime.Array;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.async.Future;
import coldfusion.util.RB;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.Query;
import java.util.Map;

public class FirestoreCollectionReferenceImpl
extends FirestoreQueryImpl
implements FirestoreCollectionReference {
    private final CollectionReference reference;
    private TagAttributeList tagAttributeList = new TagAttributeList("service", (Object)CloudServiceName.FIRESTORE.name());

    public FirestoreCollectionReferenceImpl(CollectionReference collectionReference) {
        super((Query)collectionReference);
        this.reference = collectionReference;
        this.tagAttributeList.addTagAttribute("collection", (Object)this.reference.getId());
    }

    @Override
    public String getId() {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.getId, this.tagAttributeList);
        String status = "Success";
        try {
            String string = this.reference.getId();
            return string;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.getId, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public String getPath() {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.getPath, this.tagAttributeList);
        String status = "Success";
        try {
            String string = this.reference.getPath();
            return string;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.getPath, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreDocumentReference getParent() {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.getParent, this.tagAttributeList);
        String status = "Success";
        try {
            DocumentReference documentReference = this.reference.getParent();
            if (documentReference != null) {
                FirestoreDocumentReferenceImpl firestoreDocumentReferenceImpl = new FirestoreDocumentReferenceImpl(documentReference);
                return firestoreDocumentReferenceImpl;
            }
            try {
                throw new RuntimeException("Root collections doesn't have parent document");
            }
            catch (RuntimeException e) {
                status = "Failure";
                throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
            }
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.getParent, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public Future add(Map<?, ?> data) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.add, this.tagAttributeList);
        String status = "Success";
        try {
            FirestoreUtils.validateDocumentData(data, "add");
            if (data instanceof TemplateProxy) {
                data = JSONUtils.getCFCDataAsMap((TemplateProxy)((TemplateProxy)data));
            }
            Future future = new Future((java.util.concurrent.Future)this.reference.add(FirestoreSerializer.serializeMap(FieldTypecastUtil.INSTANCE.getStringObjectMapProperty((Object)data))), FirestoreUtils.getDocumentReferenceCaster());
            return future;
        }
        catch (IllegalArgumentException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(RB.getString(FirestoreCollectionReferenceImpl.class, (String)"PROVIDED_INCORRECT_INPUT", (Object)"add"), e);
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.add, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap("post", status));
        }
    }

    @Override
    public FirestoreDocumentReference document() {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.document, this.tagAttributeList);
        String status = "Success";
        try {
            FirestoreDocumentReferenceImpl firestoreDocumentReferenceImpl = new FirestoreDocumentReferenceImpl(this.reference.document());
            return firestoreDocumentReferenceImpl;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.document, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreDocumentReference document(String path) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.document, this.tagAttributeList);
        String status = "Success";
        try {
            if (FirestoreUtils.isNullOrEmpty(path)) {
                throw new ValidationException(RB.getString(FirestoreCollectionReferenceImpl.class, (String)"DOCUMENT_PATH_NULL_EMPTY"));
            }
            FirestoreDocumentReferenceImpl firestoreDocumentReferenceImpl = new FirestoreDocumentReferenceImpl(this.reference.document(path));
            return firestoreDocumentReferenceImpl;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.document, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public Array listDocuments() {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.listDocuments, this.tagAttributeList);
        String status = "Success";
        try {
            Array result = new Array();
            this.reference.listDocuments().forEach(docRef -> result.addElement((Object)new FirestoreDocumentReferenceImpl((DocumentReference)docRef)));
            Array array = result;
            return array;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.listDocuments, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap("get", status));
        }
    }
}

