/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger.rds;

import coldfusion.debugger.CFDebuggerLogger;
import coldfusion.debugger.rds.MetaHeader;
import coldfusion.rds.RdsGlobals;
import coldfusion.util.RB;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;

class RdsHttpRequestFormatter
implements RdsGlobals {
    private String encoding = "utf-8";
    private final MetaHeader _meta = new MetaHeader(this.encoding);

    RdsHttpRequestFormatter() {
    }

    void parseRequest(HttpServletRequest request) throws IOException {
        if (this._meta.size() > 0) {
            this._meta.clear();
        }
        ServletInputStream in = request.getInputStream();
        byte[] buf = new byte[255];
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        int numRead = in.read(buf);
        while (numRead != -1) {
            ba.write(buf, 0, numRead);
            numRead = in.read(buf);
        }
        ba.flush();
        this.parse(ba.toByteArray());
    }

    public void parse(byte[] args) {
        try {
            int length;
            int index = this.indexOf(':', args, 0);
            if (index == -1) {
                throw new RuntimeException(RB.getString((Object)this, (String)"RdsHttpRequestFormatter.InvalidArg", (Object)new String(args)));
            }
            int argCount = length = new Integer(new String(args, 0, index, "utf-8")).intValue();
            int offset = index;
            for (int i = 0; i < argCount; ++i) {
                index = this.indexOf(':', args, offset = offset + 1 + 4);
                if (index == -1) {
                    String str = new String(args);
                    throw new RuntimeException(RB.getString((Object)this, (String)"RdsHttpRequestFormatter.InvalidArg", (Object)new String(args, offset, args.length - offset)));
                }
                length = new Integer(new String(args, offset, index - offset, "utf-8"));
                offset += index - offset;
                this._meta.add(this.getBytes(args, offset + 1, offset + length + 1));
                offset += length;
            }
        }
        catch (UnsupportedEncodingException e) {
            CFDebuggerLogger.log(e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    int indexOf(char ch, byte[] bytes, int off) {
        for (int i = off; i < bytes.length; ++i) {
            if (bytes[i] != 58) continue;
            return i;
        }
        return -1;
    }

    private byte[] getBytes(byte[] b, int start, int end) {
        int len = end - start;
        byte[] newb = new byte[len];
        System.arraycopy(b, start, newb, 0, len);
        return newb;
    }

    public String getMetaString(int index) {
        return this._meta.getString(index);
    }

    public byte[] getMetaBytes(int index) {
        return this._meta.getBytes(index);
    }

    public int getMetaCount() {
        return this._meta.size();
    }

    public Enumeration enumerateMetaData() {
        return this._meta.enumerate();
    }

    public String toString() {
        return this._meta.toString();
    }

    public static void main(String[] args) throws Exception {
        byte[] b = "3:STR:14:ConfigurationsSTR:10:4. 0. 0. 0STR:10:4700592725".getBytes();
        String foo = new String(b, "utf-8");
        RdsHttpRequestFormatter req = new RdsHttpRequestFormatter();
        req.parse(b);
        System.out.println("[Configurations, 4. 0. 0. 0, 4700592725]");
        System.out.println(new String(req.getMetaBytes(0)));
        System.out.println(new String(req.getMetaBytes(1)));
        System.out.println(new String(req.getMetaBytes(2)));
    }
}

