/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger;

import coldfusion.debugger.CFDebuggerLogger;
import coldfusion.debugger.CFJVMDebugManager;
import coldfusion.debugger.ClientDebugSession;
import coldfusion.debugger.DebugEventHandler;
import coldfusion.debugger.JVMDebugThread;
import coldfusion.debugger.JVMDebugThreadManager;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.StepEvent;
import java.util.Map;

public class StepEventHandler
extends DebugEventHandler {
    StepEvent evt = null;

    public StepEventHandler(StepEvent evt, CFJVMDebugManager debugManager) {
        super(debugManager);
        this.evt = evt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleEvent(Event evt, Map eventContext) throws Throwable {
        boolean codeIndexNotInLineTable;
        LocatableEvent se;
        int lineNumber;
        Location loc;
        String sourceName;
        int lastStepType;
        JVMDebugThread thr;
        block12: {
            StepEvent realSe = (StepEvent)evt;
            thr = JVMDebugThreadManager.getThread(realSe.thread().name());
            lastStepType = thr.getLastStepRequest();
            sourceName = null;
            loc = realSe.location();
            lineNumber = -1;
            try {
                sourceName = loc.sourceName();
            }
            catch (AbsentInformationException e) {
                thr.step(3, false);
                thr.setLastStepRequest(lastStepType);
                return;
            }
            se = StepEventHandler.getLocatableEventForLocation(realSe.location(), realSe);
            codeIndexNotInLineTable = false;
            if (se == null) {
                Location lastJavaLocation = thr.getLastJavaLocation();
                if (!StepEventHandler.isCfmlFile(sourceName)) {
                    this.processNonCfmlLocation(sourceName, lineNumber, loc.method().name(), loc, thr);
                    return;
                }
                if (lastJavaLocation != null && this.isCustomTagLocation(lastJavaLocation)) {
                    se = realSe;
                    lineNumber = realSe.location().lineNumber();
                    codeIndexNotInLineTable = false;
                    break block12;
                } else {
                    thr.setLastJavaLocation(null);
                    this.doLastStep(thr, loc);
                    return;
                }
            }
            lineNumber = se.location().lineNumber();
            loc = se.location();
        }
        if (!StepEventHandler.isCfmlFile(sourceName)) {
            this.processNonCfmlLocation(sourceName, lineNumber, loc.method().name(), loc, thr);
            return;
        }
        thr.setLastJavaLocation(null);
        if (lineNumber <= 0 || codeIndexNotInLineTable) {
            this.doLastStep(thr, loc);
            return;
        }
        String sourcePath = loc.sourcePath();
        Location lastLocation = JVMDebugThreadManager.getLastLocation(se.thread().name());
        if (thr == null) {
            thr = JVMDebugThreadManager.setThread(se.thread());
        }
        if (this.areSameLocs(loc, lastLocation)) {
            thr.step(lastStepType);
            return;
        }
        ClientDebugSession clientSession = this.findClientSession(se.thread(), null, false);
        if (clientSession == null) {
            thr.resumeExecution();
            return;
        }
        JVMDebugThreadManager.setLastLocation(se.thread().name(), loc);
        boolean isSet = clientSession.isBreakpointSet(sourcePath, lineNumber);
        if (isSet) {
            clientSession.setSkipBreakpoint(sourcePath, se.thread().name(), lineNumber);
        }
        clientSession.onStepEvent(se);
    }

    private boolean isCustomTagLocation(Location loc) throws Throwable {
        String methodName;
        return loc.sourceName().startsWith("ModuleTag") && ((methodName = loc.method().name()).equals("doStartTag") || methodName.equals("doAfterBody") || methodName.equals("doEndTag"));
    }

    private void processNonCfmlLocation(String sourceName, int lineNumber, String methodName, Location loc, JVMDebugThread thr) throws Throwable {
        thr.setLastJavaLocation(loc);
        if (!this.needToStepInCFCode(sourceName, lineNumber, methodName)) {
            thr.step(3, false);
            return;
        }
        thr.step(1, true);
    }

    private void doLastStep(JVMDebugThread thr, Location loc) throws Throwable {
        try {
            int lastStepType = thr.getLastStepRequest();
            if (lastStepType == 1) {
                thr.step(1, false);
            } else if (lastStepType != 1 && this.needToStepIn(loc)) {
                thr.step(1, false);
            } else {
                thr.step(2, false);
            }
        }
        catch (Throwable e) {
            CFDebuggerLogger.log(e);
            thr.getThreadReference().resume();
        }
    }

    private boolean needToStepIn(Location loc) {
        boolean default_return_value = false;
        try {
            int opCode = StepEventHandler.getOpCode(loc);
            if (opCode == 183) {
                return true;
            }
        }
        finally {
            return default_return_value;
        }
        {
        }
    }

    private boolean areSameLocs(Location loc1, Location loc2) throws Throwable {
        if (loc1 == null && loc2 == null) {
            return true;
        }
        if (loc1 == null && loc2 != null || loc1 != null && loc2 == null) {
            return false;
        }
        if (!loc1.sourcePath().equals(loc2.sourcePath())) {
            return false;
        }
        return loc1.lineNumber() == loc2.lineNumber();
    }

    private boolean needToStepInCFCode(String sourceName, int lineNum, String methodName) throws Throwable {
        if (sourceName.startsWith("CfJspPage")) {
            if (methodName.equals("_emptyTag")) {
                return true;
            }
            if (methodName.equals("_emptyTcfTag")) {
                return true;
            }
            if (methodName.equals("_invokeUDF")) {
                return true;
            }
            if (methodName.equals("invoke")) {
                return true;
            }
            if (methodName.equals("_invoke")) {
                return true;
            }
        } else if (sourceName.startsWith("UDFMethod")) {
            if (methodName.equals("invoke")) {
                return true;
            }
            if (methodName.equals("runFilterChain")) {
                return true;
            }
        } else if (sourceName.startsWith("FunctionAccessFilter")) {
            if (methodName.equals("invoke")) {
                return true;
            }
        } else {
            if (sourceName.startsWith("IncludeTag")) {
                return true;
            }
            if (sourceName.startsWith("InvokeTag")) {
                if (methodName.equals("doEndTag")) {
                    return true;
                }
            } else if (sourceName.startsWith("TemplateProxy")) {
                if (methodName.equals("invoke")) {
                    return true;
                }
            } else if (sourceName.startsWith("ModuleTag")) {
                if (methodName.equals("doStartTag")) {
                    return true;
                }
                if (methodName.equals("doAfterBody")) {
                    return true;
                }
            } else if (sourceName.startsWith("CFVariablesScopeFilter") ? methodName.equals("invoke") : sourceName.startsWith("SilentFilter") && methodName.equals("invoke")) {
                return true;
            }
        }
        return false;
    }
}

