/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger;

import coldfusion.debugger.BreakPointManager;
import coldfusion.debugger.CFDebuggerExceptions;
import coldfusion.debugger.CFDebuggerLogger;
import coldfusion.debugger.ClientDebugSession;
import coldfusion.debugger.JVMDebugThread;
import coldfusion.debugger.JVMDebugThreadManager;
import coldfusion.debugger.VMEventManager;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ClassType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CFJVMDebugManager {
    public static final String DEFAULT_DEBUG_HOST = "localhost";
    public static final int DEFAULT_DEBUG_PORT = 8600;
    private VirtualMachineManager vmManager = null;
    private VirtualMachine vm = null;
    private VMEventManager vmEventManager = null;
    private HashMap clientSessionMap = new HashMap();
    private boolean attachedToVM = false;
    private BreakPointManager bpMgr = null;
    private int nextSessionId = 1;
    private String ctxRoot = null;
    private String canonicalCtxRoot = null;
    private boolean ctxRootDiffer = false;
    private boolean traceDebugger = false;
    public static final String DUMMY_DEBUG_HANDLER = "coldfusion.debug.DummyDeubgRequestHandler";
    private boolean breakOnException = true;

    public CFJVMDebugManager(String ctxRoot, String canonicalCtxRoot) {
        this(ctxRoot, canonicalCtxRoot, false);
    }

    public CFJVMDebugManager(String ctxRoot, String canonicalCtxRoot, boolean traceDebugger) {
        this.ctxRoot = ctxRoot;
        this.canonicalCtxRoot = canonicalCtxRoot;
        if (ctxRoot != null && canonicalCtxRoot != null) {
            if (ctxRoot.charAt(0) == '\"') {
                ctxRoot = ctxRoot.substring(1);
            }
            if (ctxRoot.charAt(ctxRoot.length() - 1) == '\"') {
                ctxRoot = ctxRoot.substring(0, ctxRoot.length() - 1);
            }
            if (canonicalCtxRoot.charAt(0) == '\"') {
                canonicalCtxRoot = canonicalCtxRoot.substring(1);
            }
            if (canonicalCtxRoot.charAt(canonicalCtxRoot.length() - 1) == '\"') {
                canonicalCtxRoot = canonicalCtxRoot.substring(0, canonicalCtxRoot.length() - 1);
            }
            if (!ctxRoot.equals(canonicalCtxRoot)) {
                this.ctxRootDiffer = true;
            }
        }
        this.traceDebugger = traceDebugger;
        CFDebuggerLogger.setEnabled(traceDebugger);
    }

    public synchronized void detachFromCFJVM() {
        this.vmEventManager.stopEventManager();
        this.getVm().dispose();
        this.attachedToVM = false;
    }

    public synchronized void attachToCFJVM(String hostName, int portNum) throws Throwable {
        if (this.attachedToVM) {
            return;
        }
        try {
            this.vmManager = Bootstrap.virtualMachineManager();
        }
        catch (UnsupportedClassVersionError ue) {
            CFDebuggerExceptions.throwInvalidToolsJarVersionException();
        }
        catch (NoClassDefFoundError nce) {
            CFDebuggerExceptions.throwToolsJarNotFoundException();
        }
        List<AttachingConnector> vmConnectors = this.vmManager.attachingConnectors();
        Connector vmConnector = null;
        for (int i = 0; i < vmConnectors.size(); ++i) {
            Map<String, Connector.Argument> defaultArgs;
            vmConnector = vmConnectors.get(i);
            if (!(vmConnector instanceof AttachingConnector) || !(defaultArgs = vmConnector.defaultArguments()).containsKey("port")) continue;
            AttachingConnector aCon = (AttachingConnector)vmConnector;
            if (portNum > 0) {
                defaultArgs.get("port").setValue(String.valueOf(portNum));
            } else {
                defaultArgs.get("port").setValue(String.valueOf(8600));
            }
            if (hostName != null) {
                defaultArgs.get("hostname").setValue(hostName);
            } else {
                defaultArgs.get("hostname").setValue(DEFAULT_DEBUG_HOST);
            }
            try {
                this.vm = aCon.attach(defaultArgs);
            }
            catch (Throwable e) {
                CFDebuggerExceptions.throwCFDebuggerAttachException(portNum, e);
                return;
            }
            this.vmEventManager = new VMEventManager(this.getVm().eventQueue(), this);
            this.vmEventManager.start();
            ClassPrepareRequest cpr = this.vm.eventRequestManager().createClassPrepareRequest();
            cpr.addClassFilter("cf*");
            cpr.setSuspendPolicy(1);
            cpr.enable();
            this.bpMgr = new BreakPointManager(this);
            this.vmEventManager.dummyBPSet = this.bpMgr.setDummpyRequestEndBP();
            this.attachedToVM = true;
        }
    }

    public String createNewDebugSession() {
        return this.createNewDebugSession(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String createNewDebugSession(boolean isRemoteSession) {
        String sessionId = null;
        sessionId = String.valueOf(new Date().getTime() + (long)this.nextSessionId++);
        ClientDebugSession session = new ClientDebugSession(sessionId, this);
        session.setRemoteSession(isRemoteSession);
        HashMap hashMap = this.clientSessionMap;
        synchronized (hashMap) {
            this.clientSessionMap.put(sessionId, session);
        }
        return sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeDebugSession(String sessionId, String threadName) {
        Object sessionObj = null;
        HashMap hashMap = this.clientSessionMap;
        synchronized (hashMap) {
            sessionObj = this.clientSessionMap.remove(sessionId);
        }
        if (sessionObj == null) {
            return false;
        }
        ((ClientDebugSession)sessionObj).closeSession(this.vm, threadName);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientDebugSession getDebugSession(String sessionId) {
        HashMap hashMap = this.clientSessionMap;
        synchronized (hashMap) {
            Object obj = this.clientSessionMap.get(sessionId);
            return obj == null ? null : (ClientDebugSession)obj;
        }
    }

    public int setBreakPoint(String sessionId, String cfmlPath, int lineNum) throws Throwable {
        if (this.bpMgr == null) {
            return 0;
        }
        String cfmlPathForClassSearch = this.getCfmlPathForClassNameSearch(cfmlPath);
        int ret = this.bpMgr.setBreakPoint(sessionId, cfmlPathForClassSearch, lineNum);
        if (ret == -1 && this.isCtxRootDiffer()) {
            ret = this.bpMgr.setBreakPoint(sessionId, cfmlPath, lineNum);
        }
        CFDebuggerLogger.log("Set BP at - " + cfmlPath + ":" + lineNum + ", returnValue = " + ret);
        return ret;
    }

    private String getCfmlPathForClassNameSearch(String cfmlPath) {
        if (!this.isCtxRootDiffer()) {
            return cfmlPath;
        }
        Object pathForClassSearch = cfmlPath;
        int index = cfmlPath.indexOf(this.canonicalCtxRoot);
        if (index == 0) {
            String relativePath = cfmlPath.substring(this.canonicalCtxRoot.length());
            pathForClassSearch = this.ctxRoot + relativePath;
        }
        return pathForClassSearch;
    }

    public boolean setDummpyRequestEndBP() throws Throwable {
        if (this.bpMgr == null) {
            return false;
        }
        return this.bpMgr.setDummpyRequestEndBP();
    }

    public void setBreakpointsOnClassPrepare(String className, ClassType cfmClass) {
        if (this.bpMgr == null || this.getActiveSessionCount() == 0) {
            return;
        }
        this.bpMgr.setBreakpointsOnClassPrepare(className, cfmClass);
    }

    ClientDebugSession getClientSession(String cfmlPath, int lineNum, String excludeSession) {
        return this.getClientSession(cfmlPath, lineNum, excludeSession, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientDebugSession getClientSession(String cfmlPath, int lineNum, String excludeSession, boolean searchPendingBps) {
        HashMap hashMap = this.clientSessionMap;
        synchronized (hashMap) {
            ClientDebugSession[] sessions = this.getClientSessions();
            for (int i = 0; i < sessions.length; ++i) {
                if (sessions[i].getSessionId().equals(excludeSession) || !sessions[i].isBreakpointSet(cfmlPath, lineNum, searchPendingBps)) continue;
                return sessions[i];
            }
        }
        return null;
    }

    public VirtualMachine getVm() {
        return this.vm;
    }

    public ClientDebugSession[] getClientSessions() {
        Object[] objs = this.clientSessionMap.values().toArray();
        ClientDebugSession[] sessions = new ClientDebugSession[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            sessions[i] = (ClientDebugSession)objs[i];
        }
        return sessions;
    }

    public synchronized void onVMDisconnected(Event evt) {
        if (!this.attachedToVM) {
            return;
        }
        Iterator it = this.clientSessionMap.values().iterator();
        while (it.hasNext()) {
            ((ClientDebugSession)it.next()).onVMDisconnect(evt);
        }
        if (this.vmEventManager != null) {
            this.vmEventManager.stopEventManager();
        }
        this.attachedToVM = false;
    }

    public void step(String threadName, String sessionId, int stepDepth) throws Throwable {
        this.step(threadName, sessionId, stepDepth, false, 0L);
    }

    public ArrayList step(String threadName, String sessionId, int stepDepth, boolean isSyncOperation, long timeOut) throws Throwable {
        ClientDebugSession session;
        JVMDebugThread thr = JVMDebugThreadManager.getThread(threadName);
        if (thr == null) {
            CFDebuggerExceptions.throwStepRequestFailedException();
        }
        if ((session = this.getDebugSession(sessionId)) == null) {
            CFDebuggerExceptions.throwDebugSessionNotFound(sessionId);
        }
        session.setStepEventSynchronous(isSyncOperation);
        thr.step(stepDepth);
        if (isSyncOperation) {
            return session.getSyncStepEvents(timeOut, threadName);
        }
        return null;
    }

    public ArrayList getDebuggerEvents(String sessionId, Map fetchFlags, int timeout) throws Throwable {
        Object obj = this.clientSessionMap.get(sessionId);
        if (obj == null) {
            CFDebuggerExceptions.throwDebugSessionNotFound(sessionId);
        }
        return ((ClientDebugSession)obj).getDebuggerEvents(fetchFlags, timeout);
    }

    public void dumpThreads() throws Throwable {
        JVMDebugThreadManager.dumpThreadInfo(this.vm);
    }

    public void resumeExecution(String sessionId, String threadName) throws Throwable {
        JVMDebugThread thr = JVMDebugThreadManager.getThread(threadName);
        if (thr == null) {
            CFDebuggerExceptions.throwDebuggerThreadNotFoundException(threadName);
        }
        thr.resumeExecution();
    }

    public void setScopeFilter(String sessionId, String scopeNames) {
        ClientDebugSession session = this.getDebugSession(sessionId);
        if (session == null) {
            CFDebuggerExceptions.throwDebugSessionNotFound(sessionId);
        }
        session.setScopeFilter(scopeNames);
    }

    public String getScopeFilter(String sessionId) {
        ClientDebugSession session = this.getDebugSession(sessionId);
        if (session == null) {
            CFDebuggerExceptions.throwDebugSessionNotFound(sessionId);
        }
        return session.getScopeFilter();
    }

    public Object[] getStackTrace(String threadName) throws Throwable {
        JVMDebugThread th = JVMDebugThreadManager.getThread(threadName);
        if (th == null) {
            return null;
        }
        return th.getJavaStackTrace();
    }

    public void setCFVariableValue(String sessionId, String threadName, String varName, Object value) throws Throwable {
        ClientDebugSession session = this.getDebugSession(sessionId);
        if (session == null) {
            CFDebuggerExceptions.throwDebugSessionNotFound(sessionId);
        }
        session.setCFVariableValue(threadName, varName, value);
    }

    public void setWatchVariables(String sessionId, String[] watchVariables) throws Throwable {
        ClientDebugSession session = this.getDebugSession(sessionId);
        if (session == null) {
            CFDebuggerExceptions.throwDebugSessionNotFound(sessionId);
        }
        session.setWatchVariableNames(watchVariables);
    }

    public HashMap getCFVariables(String sessionId, String threadName) throws Throwable {
        ClientDebugSession session = this.getDebugSession(sessionId);
        if (session == null) {
            CFDebuggerExceptions.throwDebugSessionNotFound(sessionId);
        }
        return session.getCFVariables(threadName);
    }

    public HashMap getSingleCFVariable(String sessionId, String threadName, String varName) throws Throwable {
        ClientDebugSession session = this.getDebugSession(sessionId);
        if (session == null) {
            CFDebuggerExceptions.throwDebugSessionNotFound(sessionId);
        }
        return session.getSingleCFVariable(threadName, varName);
    }

    public HashMap getCFScopes(String sessionId, String threadName) throws Throwable {
        ClientDebugSession session = this.getDebugSession(sessionId);
        if (session == null) {
            CFDebuggerExceptions.throwDebugSessionNotFound(sessionId);
        }
        return session.getCFScopes(threadName);
    }

    public HashMap getWatchVariableValues(String sessionId, String threadName) throws Throwable {
        ClientDebugSession session = this.getDebugSession(sessionId);
        if (session == null) {
            CFDebuggerExceptions.throwDebugSessionNotFound(sessionId);
        }
        return session.getWatchVariables(threadName);
    }

    public Object getCFVariableValue(String sessionId, String threadName, String varName) throws Throwable {
        ClientDebugSession session = this.getDebugSession(sessionId);
        if (session == null) {
            CFDebuggerExceptions.throwDebugSessionNotFound(sessionId);
        }
        return session.getCFVariableValue(threadName, varName);
    }

    public List getThreads() throws Throwable {
        return JVMDebugThreadManager.getVMThreads(this.vm);
    }

    public void removeBreakpoint(String sessionId, String cfmlPath, int lineNum) throws Throwable {
        if (this.bpMgr == null) {
            return;
        }
        String cfmlPathForClassSearch = this.getCfmlPathForClassNameSearch(cfmlPath);
        this.bpMgr.removeBreakpoint(sessionId, cfmlPathForClassSearch, lineNum);
        CFDebuggerLogger.log("Removed BP at - " + cfmlPath + ":" + lineNum);
    }

    public void removeallBreakpoints(String sessionId) throws Throwable {
        if (this.bpMgr == null) {
            return;
        }
        this.bpMgr.removeallBreakpoints(sessionId);
    }

    public String getCFOutput(String sessionId, String threadName, boolean getOnlyBody) throws Throwable {
        ClientDebugSession session = this.getDebugSession(sessionId);
        if (session == null) {
            CFDebuggerExceptions.throwDebugSessionNotFound(sessionId);
        }
        try {
            return session.getCFOutput(threadName, getOnlyBody);
        }
        catch (Exception e) {
            return "";
        }
    }

    public void resumeAll() throws Throwable {
        if (this.vm != null) {
            this.vm.resume();
        }
    }

    public String getCanonicalCtxRoot() {
        return this.canonicalCtxRoot;
    }

    public String getCtxRoot() {
        return this.ctxRoot;
    }

    public boolean isCtxRootDiffer() {
        return this.ctxRootDiffer;
    }

    public boolean isTraceDebugger() {
        return this.traceDebugger;
    }

    public void setTraceDebugger(boolean traceDebugger) {
        this.traceDebugger = traceDebugger;
    }

    public void stopEventManager() {
        this.vmEventManager.stopEventManager();
    }

    public boolean isBreakOnException() {
        return this.breakOnException;
    }

    public void setBreakOnException(boolean doBreak) throws Throwable {
        this.breakOnException = doBreak;
        if (doBreak) {
            this.bpMgr.setBreakpointOnException();
        } else {
            this.bpMgr.removeBreakpointOnException();
        }
    }

    public void setBreakOnException(String sessionId, boolean doBreak) throws Throwable {
        ClientDebugSession session;
        if (!this.isBreakOnException() && doBreak) {
            CFDebuggerExceptions.throwBreakOnExceptionDisabledException();
        }
        if ((session = this.getDebugSession(sessionId)) == null) {
            CFDebuggerExceptions.throwDebugSessionNotFound(sessionId);
        }
        session.setBreakOnException(doBreak);
    }

    public boolean isBreakOnException(String sessionId, boolean doBreak) throws Throwable {
        if (!this.isBreakOnException()) {
            return false;
        }
        ClientDebugSession session = this.getDebugSession(sessionId);
        if (session == null) {
            CFDebuggerExceptions.throwDebugSessionNotFound(sessionId);
        }
        return session.isBreakOnException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveSessionCount() {
        HashMap hashMap = this.clientSessionMap;
        synchronized (hashMap) {
            return this.clientSessionMap.size();
        }
    }
}

