/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.sns;

import coldfusion.cloud.aws.sns.SNSAPIException;
import coldfusion.cloud.aws.sns.SNSClient;
import coldfusion.cloud.aws.sns.SNSSubscription;
import coldfusion.log.Logger;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.GenerateCFInvoke;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.InvokeNamedMethodInvocationMap;
import coldfusion.runtime.NamedInvokable;
import coldfusion.runtime.NamedMethodInvoker;
import coldfusion.runtime.ObjectHandledInvokable;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import jakarta.servlet.jsp.PageContext;
import java.util.Map;

@GenerateCFInvoke
@GenerateCFNamedInvoke
public class SNSSubscriptionImpl
implements SNSSubscription,
ObjectHandledInvokable,
NamedInvokable {
    SNSClient snsClient;
    String subscriptionArn;
    private Logger logger = ServiceFactory.getLoggingService().getLogger("coldfusion.sns");
    private static InvokeNamedMethodInvocationMap<SNSSubscriptionImpl> __InvokeNamedMethodInvocationMap = new InvokeNamedMethodInvocationMap();

    public SNSSubscriptionImpl(SNSClient snsClient, String subscriptionArn) {
        this.snsClient = snsClient;
        this.subscriptionArn = subscriptionArn;
    }

    @Override
    public String getSubscriptionArn() {
        return this.subscriptionArn;
    }

    @Override
    public Struct setAttributes(Map attributes) {
        return this.snsClient.setSubscriptionAttributes(attributes);
    }

    @Override
    public Struct getAttributes(Object subscription) {
        return this.snsClient.getSubscriptionAttributes(subscription);
    }

    public Object invoke(String methodName, Object[] args, PageContext pageContext) throws Throwable {
        switch (methodName.toLowerCase()) {
            case "getattributes": {
                if (args != null && args.length == 1) {
                    if (args[0] instanceof String) {
                        return this.getAttributes(Cast._String((Object)args[0]));
                    }
                    return this.getAttributes(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSSubscriptionImpl.class, (String)"GetSubscriptionAttributesValidationError"));
            }
            case "setattributes": {
                if (args != null && args.length == 1) {
                    return this.setAttributes(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SNSSubscriptionImpl.class, (String)"SetSubscriptionAttributesValidationError"));
            }
            case "getsubscriptionarn": {
                if (args == null || args.length == 0) {
                    return this.getSubscriptionArn();
                }
                throw new IllegalArgumentException(RB.getString(SNSSubscriptionImpl.class, (String)"GetSubscriptionArnValidationError"));
            }
        }
        Object val = super.invoke(methodName, args, pageContext);
        if (val != ObjectHandledInvokable.OBJECT_METHOD_NOT_FOUND) {
            return val;
        }
        throw new SNSAPIException(RB.getString(SNSSubscriptionImpl.class, (String)"SubscriptionMethodNotDefinedError", (Object)methodName));
    }

    public Object invoke(String methodName, Map args, PageContext pageContext) throws Throwable {
        NamedMethodInvoker NamedMethodInvoker2 = __InvokeNamedMethodInvocationMap.get((Object)methodName);
        if (NamedMethodInvoker2 == null) {
            throw new CfJspPage.UnsupportedBaseTypeException(methodName, (Object)this);
        }
        this.logger.info((Object)("sns service method " + methodName + " invoked and started excecution... "));
        long startTime = System.currentTimeMillis();
        Object invokeObject = NamedMethodInvoker2.invoke((Object)this, args);
        long endTime = System.currentTimeMillis();
        long timeElapsed = endTime - startTime;
        this.logger.info((Object)("sns service method " + methodName + " finished execution successfully. Turn around time : " + timeElapsed + " milli secs"));
        return invokeObject;
    }

    static {
        __InvokeNamedMethodInvocationMap.put((Object)"getSubscriptionArn", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getSubscriptionArn();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getSubscriptionArn", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"setAttributes", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"attributes"}, args);
                    return obj.setAttributes(Cast._Map((Object)argColl.get((Object)"attributes")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("setAttributes", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getAttributes", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"subscription"}, args);
                    return obj.getAttributes(argColl.get((Object)"subscription"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getAttributes", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"invoke", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"methodName", "args", "pageContext"}, args);
                    return obj.invoke(Cast._String((Object)argColl.get((Object)"methodName")), (Object[])Cast._castForInvokeGen((Object)argColl.get((Object)"args"), Object[].class), (PageContext)Cast._castForInvokeGen((Object)argColl.get((Object)"pageContext"), PageContext.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("invoke", obj);
        });
    }
}

