/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.stream.ds;

import jakarta.activation.DataHandler;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.xop.AbstractXOPDecodingFilterHandler;
import org.apache.axiom.om.impl.intf.TextContent;
import org.apache.axiom.om.impl.stream.xop.XOPHandler;
import org.apache.axiom.util.UIDGenerator;

final class PushOMDataSourceXOPHandler
extends AbstractXOPDecodingFilterHandler
implements XOPHandler {
    private final Map<String, DataHandler> dataHandlers = new HashMap<String, DataHandler>();

    PushOMDataSourceXOPHandler(XmlHandler parent) {
        super(parent);
    }

    @Override
    public String prepareDataHandler(DataHandler dataHandler) {
        String contentID = UIDGenerator.generateContentId();
        this.dataHandlers.put(contentID, dataHandler);
        return contentID;
    }

    @Override
    protected Object buildCharacterData(String contentID) throws StreamException {
        DataHandler dataHandler = this.dataHandlers.get(contentID);
        if (dataHandler == null) {
            throw new StreamException("No DataHandler found for content ID " + contentID);
        }
        return new TextContent(contentID, dataHandler, true);
    }
}

