/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.search.lucene;

import coldfusion.orm.PersistentTemplateProxy;
import coldfusion.orm.search.ORMSearchException;
import coldfusion.orm.search.ORMSearchManager;
import coldfusion.orm.search.core.CFCSearchMetadata;
import coldfusion.orm.search.core.IndexableField;
import coldfusion.orm.search.core.IndexableRelationField;
import coldfusion.runtime.Cast;
import coldfusion.util.RB;
import java.util.Date;
import java.util.List;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatDocValuesField;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.Term;

public class DocumentBuilder {
    private String entityName;
    private PersistentTemplateProxy entity;
    private Document document;
    private static final String LUCENE_DOC_ID_NAME = "ORM_SEARCH_ID";
    private static final String DOT = ".";

    public DocumentBuilder(String entityName, PersistentTemplateProxy entity) {
        this.entityName = entityName;
        this.entity = entity;
    }

    public Document getDocument() {
        if (this.document == null) {
            this.buildDocument();
        }
        return this.document;
    }

    public Term getDocumentIndexTerm() {
        return new Term(LUCENE_DOC_ID_NAME, this.evaluateLuceneDocIdValue());
    }

    private void buildDocument() {
        Field field;
        this.document = new Document();
        CFCSearchMetadata smd = ORMSearchManager.getCurrentSearchFactory().getCFCSearchMetadata(this.entityName);
        List<IndexableField> columns = smd.getIndexableIDFields();
        for (IndexableField column : columns) {
            field = this.createLuceneField(this.document, column);
            if (field == null) {
                throw new ORMSearchException(RB.getString((Object)this, (String)"indexingFailedForInvalidPK", (Object)column.getName()));
            }
            this.document.add((org.apache.lucene.index.IndexableField)field);
        }
        try {
            columns = smd.getIndexableFields();
            for (IndexableField column : columns) {
                field = this.createLuceneField(this.document, column);
                if (field == null) continue;
                this.document.add((org.apache.lucene.index.IndexableField)field);
            }
            Field inBuiltLuceneID = new Field(LUCENE_DOC_ID_NAME, this.evaluateLuceneDocIdValue(), TextField.TYPE_STORED);
            this.document.add((org.apache.lucene.index.IndexableField)inBuiltLuceneID);
            List<IndexableRelationField> relationColumns = smd.getIndexableRelationFields();
            if (relationColumns != null) {
                for (IndexableRelationField column : relationColumns) {
                    this.buildDocumentForMappedEntity(column, this.document);
                }
            }
        }
        catch (Exception e) {
            throw new ORMSearchException(RB.getString((Object)this, (String)"DocumentCreationfailed", (Object)this.entityName));
        }
    }

    private void buildDocumentForMappedEntity(IndexableRelationField mappedField, Document document) {
        String fieldName = mappedField.getIndexFieldName();
        PersistentTemplateProxy mappedEntity = (PersistentTemplateProxy)this.entity.getProperty(mappedField.getName());
        if (mappedEntity != null) {
            Field field;
            String targetEntityName = ORMSearchManager.getCurrentSearchFactory().getEntityName(mappedEntity.getName());
            CFCSearchMetadata smd = ORMSearchManager.getCurrentSearchFactory().getSearchMetadataForReferredCFC(targetEntityName);
            List<IndexableField> columns = smd.getIndexableIDFields();
            for (IndexableField column : columns) {
                field = this.createLuceneFieldForMappedEntity(document, mappedEntity, fieldName, column);
                document.add((org.apache.lucene.index.IndexableField)field);
            }
            columns = smd.getIndexableFields();
            for (IndexableField column : columns) {
                field = this.createLuceneFieldForMappedEntity(document, mappedEntity, fieldName, column);
                if (field == null) continue;
                document.add((org.apache.lucene.index.IndexableField)field);
            }
        }
    }

    private Field createLuceneField(Document doc, IndexableField column) {
        Field field = null;
        String propertyName = column.getName();
        Object objValue = this.entity.getProperty(propertyName);
        if (objValue != null) {
            field = this.getField(doc, column, column.getIndexFieldName(), objValue);
            field.setBoost(column.getBoost());
        }
        return field;
    }

    private Field getField(Document doc, IndexableField column, String fieldName, Object objValue) {
        Object field;
        if (objValue instanceof Integer) {
            field = new NumericDocValuesField(fieldName, (long)((Integer)objValue).intValue());
            doc.add((org.apache.lucene.index.IndexableField)new IntPoint(fieldName, new int[]{(Integer)objValue}));
            if (column.isIndexStorable()) {
                doc.add((org.apache.lucene.index.IndexableField)new StoredField(fieldName, ((Integer)objValue).intValue()));
            }
        } else if (objValue instanceof Double) {
            field = new DoubleDocValuesField(fieldName, ((Double)objValue).doubleValue());
            doc.add((org.apache.lucene.index.IndexableField)new DoublePoint(fieldName, new double[]{(Double)objValue}));
            if (column.isIndexStorable()) {
                doc.add((org.apache.lucene.index.IndexableField)new StoredField(fieldName, ((Double)objValue).doubleValue()));
            }
        } else if (objValue instanceof Float) {
            field = new FloatDocValuesField(fieldName, ((Float)objValue).floatValue());
            doc.add((org.apache.lucene.index.IndexableField)new FloatPoint(fieldName, new float[]{((Float)objValue).floatValue()}));
            if (column.isIndexStorable()) {
                doc.add((org.apache.lucene.index.IndexableField)new StoredField(fieldName, ((Float)objValue).floatValue()));
            }
        } else if (objValue instanceof Long) {
            field = new NumericDocValuesField(fieldName, ((Long)objValue).longValue());
            doc.add((org.apache.lucene.index.IndexableField)new LongPoint(fieldName, new long[]{(Long)objValue}));
            if (column.isIndexStorable()) {
                doc.add((org.apache.lucene.index.IndexableField)new StoredField(fieldName, ((Long)objValue).longValue()));
            }
        } else if (objValue instanceof Short || objValue instanceof Byte) {
            field = new NumericDocValuesField(fieldName, (long)((Number)objValue).intValue());
            doc.add((org.apache.lucene.index.IndexableField)new IntPoint(fieldName, new int[]{((Number)objValue).intValue()}));
            if (column.isIndexStorable()) {
                doc.add((org.apache.lucene.index.IndexableField)new StoredField(fieldName, ((Number)objValue).intValue()));
            }
        } else {
            field = !column.isIndexable() ? new StoredField(fieldName, this.getFieldValue(objValue)) : (column.isIndextokenize() ? new TextField(fieldName, this.getFieldValue(objValue), this.parseStore(column)) : new StringField(fieldName, this.getFieldValue(objValue), this.parseStore(column)));
        }
        return field;
    }

    private String getFieldValue(Object objValue) {
        String value = null;
        value = objValue instanceof Date ? DateTools.dateToString((Date)((Date)objValue), (DateTools.Resolution)DateTools.Resolution.SECOND) : Cast._String((Object)objValue);
        return value;
    }

    private Field createLuceneFieldForMappedEntity(Document doc, PersistentTemplateProxy mappedEntity, String prefix, IndexableField column) {
        Field field = null;
        String propertyName = column.getName();
        Object objValue = mappedEntity.getProperty(propertyName);
        if (objValue != null) {
            field = this.getField(doc, column, prefix + DOT + column.getIndexFieldName(), objValue);
            field.setBoost(column.getBoost());
        }
        return field;
    }

    private String evaluateLuceneDocIdValue() {
        CFCSearchMetadata smd = ORMSearchManager.getCurrentSearchFactory().getCFCSearchMetadata(this.entityName);
        Object value = "";
        List<IndexableField> columns = smd.getIndexableIDFields();
        for (IndexableField column : columns) {
            Object objValue = this.entity.getProperty(column.getName());
            if (objValue == null) continue;
            value = (String)value + Cast._String((Object)objValue);
        }
        return value;
    }

    private Field.Store parseStore(IndexableField field) {
        return field.isIndexStorable() ? Field.Store.YES : Field.Store.NO;
    }
}

