/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;

public class VFile
extends File {
    private FileObject fileObject;

    public VFile(FileObject fileObject) {
        super(".");
        if (fileObject == null) {
            throw new NullPointerException();
        }
        this.fileObject = fileObject;
    }

    @Override
    public String getPath() {
        return this.fileObject.getName().getRootURI().concat(this.fileObject.getName().getPath().substring(1));
    }

    @Override
    public boolean exists() {
        try {
            return this.fileObject.exists();
        }
        catch (FileSystemException e) {
            return false;
        }
    }

    @Override
    public boolean canRead() {
        try {
            return this.fileObject.isReadable();
        }
        catch (FileSystemException e) {
            return false;
        }
    }

    @Override
    public boolean canWrite() {
        try {
            return this.fileObject.isWriteable();
        }
        catch (FileSystemException e) {
            return false;
        }
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    @Override
    public long length() {
        try {
            if (this.isFile()) {
                return this.fileObject.getContent().getSize();
            }
            return 0L;
        }
        catch (FileSystemException e) {
            return 0L;
        }
    }

    @Override
    public boolean isFile() {
        block3: {
            try {
                if (this.exists()) break block3;
                return false;
            }
            catch (FileSystemException e) {
                return false;
            }
        }
        return this.fileObject.getType().equals((Object)FileType.FILE);
    }

    @Override
    public boolean renameTo(File dest) {
        if (dest instanceof VFile && this.fileObject.canRenameTo(((VFile)dest).getFileObject())) {
            try {
                this.fileObject.moveTo(((VFile)dest).getFileObject());
                return true;
            }
            catch (FileSystemException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean delete() {
        try {
            this.fileObject.delete();
            return true;
        }
        catch (FileSystemException e) {
            return false;
        }
    }

    @Override
    public String getParent() {
        return this.getParentFile().getPath();
    }

    @Override
    public File getParentFile() {
        FileObject pfob;
        try {
            pfob = this.fileObject.getParent();
        }
        catch (FileSystemException e) {
            return null;
        }
        if (pfob == null) {
            return null;
        }
        return new VFile(pfob);
    }

    @Override
    public String getName() {
        return this.fileObject.getName().getBaseName();
    }

    @Override
    public boolean mkdir() {
        try {
            this.fileObject.createFolder();
            return true;
        }
        catch (FileSystemException e) {
            return false;
        }
    }

    @Override
    public boolean mkdirs() {
        return this.mkdir();
    }

    public InputStream getInputStream() {
        try {
            return this.fileObject.getContent().getInputStream();
        }
        catch (FileSystemException e) {
            return null;
        }
    }

    public OutputStream getOutputStream() {
        return this.getOutputStream(false);
    }

    public OutputStream getOutputStream(boolean append) {
        try {
            return this.fileObject.getContent().getOutputStream();
        }
        catch (FileSystemException e) {
            return null;
        }
    }

    @Override
    public boolean createNewFile() throws IOException {
        if (!this.exists()) {
            this.fileObject.createFile();
            return true;
        }
        return false;
    }
}

