/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.saml;

import coldfusion.filter.FusionContext;
import coldfusion.saml.util.Utils;
import com.onelogin.saml2.http.HttpRequest;
import com.onelogin.saml2.servlet.ServletUtils;
import com.onelogin.saml2.util.Util;
import jakarta.servlet.http.HttpServletRequest;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class SamlResponseValidator {
    private static DocumentBuilderFactory dbf = Utils.createDocumentFactory();
    private Document samlResponseDocument;

    public SamlResponseValidator() {
        HttpRequest httpRequest = ServletUtils.makeHttpRequest((HttpServletRequest)FusionContext.getCurrent().getRequest());
        String samlResponse = httpRequest.getParameter("SAMLResponse");
        if (samlResponse != null) {
            String decodedResponse = new String(Util.base64decoder((String)samlResponse));
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(decodedResponse));
            try {
                Document doc;
                DocumentBuilder db = dbf.newDocumentBuilder();
                this.samlResponseDocument = doc = db.parse(is);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isSamlLoginResponse() {
        HttpRequest httpRequest = ServletUtils.makeHttpRequest((HttpServletRequest)FusionContext.getCurrent().getRequest());
        String samlResponse = httpRequest.getParameter("SAMLResponse");
        if (this.samlResponseDocument != null) {
            try {
                Element root = this.samlResponseDocument.getDocumentElement();
                String elementName = root.getTagName();
                if (elementName.equals("samlp:Response") || elementName.equals("saml2p:Response")) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

