/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.presentation;

import coldfusion.document.presentation.core.PresentationExceptions;
import coldfusion.document.spi.DocumentExportException;
import coldfusion.document.spi.DocumentProperties;
import coldfusion.document.spi.DocumentSectionProperties;
import coldfusion.document.spi.DocumentWriter;
import coldfusion.document.spi.Exporter;
import coldfusion.document.spi.HeaderFooterContentProvider;
import coldfusion.document.spi.PageNoCallbackHandler;
import com.lowagie.text.DocumentException;
import ice.pilots.notsupported.ThePilot;
import ice.storm.Pilot;
import ice.storm.StormPrinter;
import ice.storm.Viewport;
import ice.storm.print.StormPageFormat;
import java.awt.Graphics;
import java.io.IOException;
import java.net.URL;
import java.util.List;

public class SlideExporter
implements Exporter {
    private static void setAppropriateScale(StormPrinter printer, StormPageFormat format, double userScale) {
        double scale = userScale > 0.0 ? userScale : 2.0;
        double vscale = format.getImageableHeight() / printer.getDimension().getHeight();
        double hscale = format.getImageableWidth() / printer.getDimension().getWidth();
        if (userScale > 0.0) {
            format.setScale(userScale);
            printer.setStormPageFormat(format);
            if (printer.getPageCount() == 1) {
                return;
            }
        }
        double calcScale = hscale < vscale ? hscale : vscale;
        calcScale = calcScale < scale ? calcScale : scale;
        scale = calcScale < 1.0 ? 1.0 : scale;
        format.setScale(scale);
        printer.setStormPageFormat(format);
        if (printer.getPageCount() > 1) {
            double ulimit = scale;
            double llimit = calcScale;
            while (ulimit - llimit > 0.001) {
                scale = (ulimit + llimit) / 2.0;
                format.setScale(scale);
                printer.setStormPageFormat(format);
                if (printer.getPageCount() > 1) {
                    ulimit = scale;
                    continue;
                }
                llimit = scale;
            }
        }
        if ((hscale = format.getImageableWidth() / printer.getDimension().getWidth()) < 1.0) {
            scale = hscale * scale;
        }
        scale = (int)(scale * 1000.0);
        format.setScale(scale /= 1000.0);
        printer.setStormPageFormat(format);
    }

    public void export(Viewport[] viewports, DocumentProperties docProps, HeaderFooterContentProvider headerContentProvider, HeaderFooterContentProvider footerContentProvider, PageNoCallbackHandler pageCbh, URL baseUrl) throws DocumentExportException {
        this.export(viewports, docProps);
    }

    public void export(Viewport[] viewports, DocumentProperties docProps, DocumentSectionProperties docSectionProps, HeaderFooterContentProvider headerContentProvider, HeaderFooterContentProvider footerContentProvider, PageNoCallbackHandler pageCbh, URL baseUrl, List sectionList) throws DocumentExportException {
        throw new UnsupportedOperationException();
    }

    public void export(Viewport[] viewports, DocumentProperties docProps) throws DocumentExportException {
        StormPageFormat stormPageFormat = docProps.getStormPageFormat();
        Graphics g = null;
        DocumentWriter writer = null;
        try {
            writer = docProps.getWriter();
            double scale = docProps.getScale();
            stormPageFormat.setScaleToFitEnabled(false);
            stormPageFormat.setTextWrapping(true);
            stormPageFormat.setHtmlSmartPaging(false);
            g = writer.createGraphics((float)stormPageFormat.getPageWidth(), (float)stormPageFormat.getPageHeight(), docProps.getPageLayout().getMargin());
            for (int i = 0; i < viewports.length; ++i) {
                Pilot pilot = viewports[i].getPilot();
                if (pilot instanceof ThePilot) continue;
                StormPrinter stormPrinter = pilot.createPrinter();
                stormPrinter.setStormPageFormat(stormPageFormat);
                SlideExporter.setAppropriateScale(stormPrinter, stormPageFormat, scale);
                try {
                    stormPrinter.print(g);
                    continue;
                }
                catch (Exception e) {
                    throw new PresentationExceptions.PresentationException((Throwable)e);
                }
                finally {
                    writer.saveState();
                }
            }
        }
        catch (DocumentException e) {
            throw new DocumentExportException((Throwable)e);
        }
        finally {
            if (g != null) {
                g.dispose();
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ioe) {
                    throw new DocumentExportException((Throwable)ioe);
                }
            }
        }
    }
}

