/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.smscsim.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.smpp.SmppObject;
import org.smpp.debug.Debug;
import org.smpp.debug.Event;
import org.smpp.smscsim.util.Attribute;
import org.smpp.smscsim.util.Record;
import org.smpp.smscsim.util.Table;
import org.smpp.smscsim.util.TableParser;

public class BasicTableParser
implements TableParser {
    static final char CR = '\r';
    static final char LF = '\n';
    static final String LINE_END = "\r\n";
    static final String ATTR_DELIMS = "=:";
    static final String COMMENT_CHARS = "#;";
    Table table;
    InputStreamReader in;
    OutputStreamWriter out;
    char c;
    char pending;
    boolean pendingChar = false;
    String line = "";
    Record record;
    boolean pendingRecord = false;
    private Debug debug = SmppObject.getDebug();
    private Event event = SmppObject.getEvent();

    public BasicTableParser(Table table) {
        this.table = table;
    }

    public void parse(InputStream is) throws IOException {
        this.debug.write("going to parse from input stream");
        this.in = new InputStreamReader(is);
        this.prepareRecord();
        while (!this.eof()) {
            this.getLine();
            if (this.isEmpty()) {
                this.debug.write("got empty line");
                this.finaliseRecord(true);
                continue;
            }
            if (!this.isComment()) {
                this.parseAttribute(this.line);
                continue;
            }
            this.debug.write("got comment line " + this.line);
        }
        this.finaliseRecord(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compose(OutputStream os) throws IOException {
        this.out = new OutputStreamWriter(os);
        Table table = this.table;
        synchronized (table) {
            int recCount = this.table.count();
            for (int ri = 0; ri < recCount; ++ri) {
                Record record;
                Record record2 = record = this.table.get(ri);
                synchronized (record2) {
                    int attrCount = record.count();
                    for (int ai = 0; ai < attrCount; ++ai) {
                        Attribute attribute;
                        Attribute attribute2 = attribute = record.get(ai);
                        synchronized (attribute2) {
                            this.line = attribute.getName() + "=" + attribute.getValue();
                        }
                        this.out.write(this.line);
                        this.out.write(LINE_END);
                    }
                }
                if (ri + 1 >= recCount) continue;
                this.out.write(LINE_END);
            }
        }
        this.out.flush();
    }

    void finaliseRecord(boolean prepareNext) {
        if (this.pendingRecord) {
            this.debug.write("finished record, adding to table");
            this.table.add(this.record);
            this.pendingRecord = false;
            if (prepareNext) {
                this.prepareRecord();
            }
        }
    }

    void prepareRecord() {
        this.record = new Record();
    }

    void parseAttribute(String attr) {
        int currPos;
        int attrLen = attr.length();
        this.debug.write("going to parse attribute " + attr);
        for (currPos = 0; currPos < attrLen && ATTR_DELIMS.indexOf(attr.charAt(currPos)) == -1; ++currPos) {
        }
        String name = attr.substring(0, currPos);
        String value = attr.substring(currPos + 1, attrLen);
        this.record.set(name, value);
        this.pendingRecord = true;
    }

    boolean eof() throws IOException {
        return !this.in.ready();
    }

    boolean eol() {
        return this.c == '\r' || this.c == '\n';
    }

    boolean isEmpty() {
        return this.line.length() == 0;
    }

    boolean isComment() {
        return this.isEmpty() ? false : COMMENT_CHARS.indexOf(this.line.charAt(0)) != -1;
    }

    void getLine() throws IOException {
        this.line = "";
        this.get();
        do {
            if (!this.eol()) {
                this.line = this.line + this.c;
            }
            this.get();
        } while (!this.eof() && !this.eol());
        if (!this.eof() && this.c == '\r') {
            this.get();
            if (this.c != '\n') {
                this.unget();
            }
        }
    }

    void get() throws IOException {
        if (this.pendingChar) {
            this.c = this.pending;
            this.pendingChar = false;
        } else {
            this.c = (char)this.in.read();
        }
    }

    void unget() {
        this.pending = this.c;
        this.pendingChar = true;
    }
}

