/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.smscsim;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import org.smpp.SmppObject;
import org.smpp.debug.Debug;
import org.smpp.debug.Event;
import org.smpp.debug.FileDebug;
import org.smpp.debug.FileEvent;
import org.smpp.pdu.DeliverSM;
import org.smpp.pdu.PDUException;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.smscsim.DeliveryInfoSender;
import org.smpp.smscsim.MessageSender;
import org.smpp.smscsim.PDUProcessorGroup;
import org.smpp.smscsim.SMSCListener;
import org.smpp.smscsim.SMSCSession;
import org.smpp.smscsim.ShortMessageStore;
import org.smpp.smscsim.SimulatorPDUProcessor;
import org.smpp.smscsim.SimulatorPDUProcessorFactory;
import org.smpp.smscsim.util.Table;

public class Simulator {
    static String usersFileName = "etc/users.txt";
    static final String dbgDir = "./";
    static final String DEBUG_FILE = "sms-test.log";
    static final String EVENT_FILE = "sms-test-exception.log";
    public Debug debug = null;
    public Event event = null;
    public static final int DSIM = 16;
    public static final int DSIMD = 17;
    public static final int DSIMD2 = 18;
    static BufferedReader keyboard = new BufferedReader(new InputStreamReader(System.in));
    boolean keepRunning = true;
    private SMSCListener smscListener = null;
    private SimulatorPDUProcessorFactory factory = null;
    private PDUProcessorGroup processors = null;
    private ShortMessageStore messageStore = null;
    private DeliveryInfoSender deliveryInfoSender = null;
    private MessageSender messageSender = null;
    private Table users = null;
    private boolean displayInfo = false;

    public static void main(String[] args) throws IOException {
        Simulator menu = new Simulator();
        menu.debug = new FileDebug(dbgDir, DEBUG_FILE);
        menu.event = new FileEvent(dbgDir, EVENT_FILE);
        Simulator.initDebug(menu.debug, menu.event);
        menu.menu();
        System.exit(0);
    }

    private static void initDebug(Debug debug, Event event) {
        SmppObject.setDebug(debug);
        SmppObject.setEvent(event);
        debug.activate();
        event.activate();
        debug.deactivate(3);
        debug.deactivate(6);
        debug.deactivate(7);
        debug.deactivate(8);
        debug.deactivate(18);
    }

    protected void menu() throws IOException {
        this.debug.write("simulator started");
        this.keepRunning = true;
        String option = "1";
        block13: while (this.keepRunning) {
            System.out.println();
            System.out.println("- 1 start simulation");
            System.out.println("- 2 stop simulation");
            System.out.println("- 3 list clients");
            System.out.println("- 4 send message");
            System.out.println("- 5 list messages");
            System.out.println("- 6 reload users file");
            System.out.println("- 7 log to screen " + (this.displayInfo ? "off" : "on"));
            System.out.println("- 0 exit");
            System.out.print("> ");
            int optionInt = -1;
            try {
                option = keyboard.readLine();
                optionInt = Integer.parseInt(option);
            }
            catch (Exception e) {
                this.debug.write("exception reading keyboard " + e);
                optionInt = -1;
            }
            switch (optionInt) {
                case 1: {
                    this.menu_start();
                    continue block13;
                }
                case 2: {
                    this.menu_stop();
                    continue block13;
                }
                case 3: {
                    this.listClients();
                    continue block13;
                }
                case 4: {
                    this.sendMessage();
                    continue block13;
                }
                case 5: {
                    this.messageList();
                    continue block13;
                }
                case 6: {
                    this.reloadUsers();
                    continue block13;
                }
                case 7: {
                    this.logToScreen();
                    continue block13;
                }
                case 0: {
                    this.exit();
                    continue block13;
                }
                case -1: {
                    continue block13;
                }
            }
            System.out.println("Invalid option. Choose between 0 and 6.");
        }
        System.out.println("Exiting simulator.");
        this.debug.write("simulator exited.");
    }

    protected void menu_start() throws IOException {
        if (this.smscListener == null) {
            System.out.print("Enter port number> ");
            int port = Integer.parseInt(keyboard.readLine());
            System.out.print("Starting listener... ");
            this.users = new Table(usersFileName);
            this.displayInfo = true;
            this.start(port);
            System.out.println("started.");
        } else {
            System.out.println("Listener is already running.");
        }
    }

    protected void menu_stop() throws IOException {
        if (this.smscListener != null) {
            System.out.println("Stopping listener...");
            this.stop();
            System.out.println("Stopped.");
        }
    }

    public void start(int port, String usersFile, String logdir) throws IOException {
        this.users = new Table(usersFile);
        this.debug = new FileDebug(logdir, DEBUG_FILE);
        this.event = new FileEvent(logdir, EVENT_FILE);
        Simulator.initDebug(this.debug, this.event);
        this.displayInfo = false;
        this.start(port);
    }

    private void start(int port) throws IOException {
        if (this.smscListener == null) {
            this.smscListener = new SMSCListener(port, true);
            this.processors = new PDUProcessorGroup();
            this.messageStore = new ShortMessageStore();
            this.deliveryInfoSender = new DeliveryInfoSender();
            this.deliveryInfoSender.start();
            this.messageSender = new MessageSender(this.processors);
            this.messageSender.start();
            this.factory = new SimulatorPDUProcessorFactory(this.processors, this.messageStore, this.deliveryInfoSender, this.users, this.messageSender);
            this.factory.setDisplayInfo(this.displayInfo);
            this.smscListener.setPDUProcessorFactory(this.factory);
            this.smscListener.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        if (this.smscListener != null) {
            PDUProcessorGroup pDUProcessorGroup = this.processors;
            synchronized (pDUProcessorGroup) {
                int procCount = this.processors.count();
                for (int i = 0; i < procCount; ++i) {
                    SimulatorPDUProcessor proc = (SimulatorPDUProcessor)this.processors.get(i);
                    SMSCSession session = proc.getSession();
                    this.debug.write("Stopping session " + i + ": " + proc.getSystemId() + " ...");
                    session.stop();
                }
            }
            this.smscListener.stop();
            this.smscListener = null;
            if (this.deliveryInfoSender != null) {
                this.deliveryInfoSender.stop();
            }
            if (this.messageSender != null) {
                this.messageSender.stop();
            }
        }
    }

    public boolean isRunning() {
        return this.smscListener != null;
    }

    protected void exit() throws IOException {
        this.menu_stop();
        this.keepRunning = false;
    }

    protected void messageList() {
        if (this.smscListener != null) {
            this.messageStore.print();
        } else {
            System.out.println("You must start listener first.");
        }
    }

    protected void reloadUsers() {
        if (this.smscListener != null) {
            try {
                if (this.users != null) {
                    this.users.reload();
                } else {
                    this.users = new Table(usersFileName);
                }
                System.out.println("Users file reloaded.");
            }
            catch (FileNotFoundException e) {
                this.event.write(e, "reading users file " + usersFileName);
            }
            catch (IOException e) {
                this.event.write(e, "reading users file " + usersFileName);
            }
        } else {
            System.out.println("You must start listener first.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logToScreen() {
        if (this.smscListener != null) {
            PDUProcessorGroup pDUProcessorGroup = this.processors;
            synchronized (pDUProcessorGroup) {
                this.displayInfo = !this.displayInfo;
                int procCount = this.processors.count();
                for (int i = 0; i < procCount; ++i) {
                    SimulatorPDUProcessor proc = (SimulatorPDUProcessor)this.processors.get(i);
                    proc.setDisplayInfo(this.displayInfo);
                }
            }
            this.factory.setDisplayInfo(this.displayInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void listClients() {
        if (this.smscListener != null) {
            PDUProcessorGroup pDUProcessorGroup = this.processors;
            synchronized (pDUProcessorGroup) {
                int procCount = this.processors.count();
                if (procCount > 0) {
                    for (int i = 0; i < procCount; ++i) {
                        SimulatorPDUProcessor proc = (SimulatorPDUProcessor)this.processors.get(i);
                        System.out.print(proc.getSystemId());
                        if (!proc.isActive()) {
                            System.out.println(" (inactive)");
                            continue;
                        }
                        System.out.println();
                    }
                } else {
                    System.out.println("No client connected.");
                }
            }
        } else {
            System.out.println("You must start listener first.");
        }
    }

    protected void sendMessage() throws IOException {
        if (this.smscListener != null) {
            int procCount = this.processors.count();
            if (procCount > 0) {
                SimulatorPDUProcessor proc;
                String client;
                this.listClients();
                if (procCount > 1) {
                    System.out.print("Type name of the destination> ");
                    client = keyboard.readLine();
                } else {
                    proc = (SimulatorPDUProcessor)this.processors.get(0);
                    client = proc.getSystemId();
                }
                for (int i = 0; i < procCount; ++i) {
                    proc = (SimulatorPDUProcessor)this.processors.get(i);
                    if (!proc.getSystemId().equals(client)) continue;
                    if (proc.isActive()) {
                        System.out.print("Type the message> ");
                        String message = keyboard.readLine();
                        DeliverSM request = new DeliverSM();
                        try {
                            request.setShortMessage(message);
                            proc.serverRequest(request);
                            System.out.println("Message sent.");
                        }
                        catch (WrongLengthOfStringException e) {
                            System.out.println("Message sending failed");
                            this.event.write(e, "");
                        }
                        catch (IOException ioe) {
                        }
                        catch (PDUException pe) {}
                        continue;
                    }
                    System.out.println("This session is inactive.");
                }
            } else {
                System.out.println("No client connected.");
            }
        } else {
            System.out.println("You must start listener first.");
        }
    }
}

