/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu.tlv;

import org.smpp.pdu.ValueNotSetException;
import org.smpp.pdu.tlv.TLV;
import org.smpp.pdu.tlv.TLVException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;

public class TLVShort
extends TLV {
    private short value = 0;

    public TLVShort() {
        super(2, 2);
    }

    public TLVShort(short p_tag) {
        super(p_tag, 2, 2);
    }

    public TLVShort(short p_tag, short p_value) {
        super(p_tag, 2, 2);
        this.value = p_value;
        this.markValueSet();
    }

    protected void setValueData(ByteBuffer buffer) throws TLVException {
        this.checkLength(buffer);
        try {
            this.value = buffer.removeShort();
        }
        catch (NotEnoughDataInByteBufferException notEnoughDataInByteBufferException) {
            // empty catch block
        }
        this.markValueSet();
    }

    protected ByteBuffer getValueData() throws ValueNotSetException {
        ByteBuffer valueBuf = new ByteBuffer();
        valueBuf.appendShort(this.getValue());
        return valueBuf;
    }

    public void setValue(short p_value) {
        this.value = p_value;
        this.markValueSet();
    }

    public short getValue() throws ValueNotSetException {
        if (this.hasValue()) {
            return this.value;
        }
        throw new ValueNotSetException();
    }

    public String debugString() {
        String dbgs = "(short: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + this.value;
        dbgs = dbgs + ") ";
        return dbgs;
    }
}

