/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu;

import org.smpp.pdu.Address;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;

public class UnsuccessSME
extends Address {
    public int errorStatusCode = 0;

    public UnsuccessSME() {
    }

    public UnsuccessSME(String address, int err) throws WrongLengthOfStringException {
        super(address);
        this.setErrorStatusCode(err);
    }

    public UnsuccessSME(byte ton, byte npi, String address, int err) throws WrongLengthOfStringException {
        super(ton, npi, address);
        this.setErrorStatusCode(err);
    }

    public void setData(ByteBuffer buffer) throws NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException, WrongLengthOfStringException {
        super.setData(buffer);
        this.setErrorStatusCode(buffer.removeInt());
    }

    public ByteBuffer getData() {
        ByteBuffer buffer = super.getData();
        buffer.appendInt(this.getErrorStatusCode());
        return buffer;
    }

    public void setErrorStatusCode(int sc) {
        this.errorStatusCode = sc;
    }

    public int getErrorStatusCode() {
        return this.errorStatusCode;
    }

    public String debugString() {
        String dbgs = "(unsucsme: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + Integer.toString(this.getErrorStatusCode());
        dbgs = dbgs + ") ";
        return dbgs;
    }
}

