/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu;

import org.smpp.pdu.Address;
import org.smpp.pdu.PDUException;
import org.smpp.pdu.QuerySMResp;
import org.smpp.pdu.Request;
import org.smpp.pdu.Response;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;

public class QuerySM
extends Request {
    private String messageId = "";
    private Address sourceAddr = new Address();

    public QuerySM() {
        super(3);
    }

    protected Response createResponse() {
        return new QuerySMResp();
    }

    public void setBody(ByteBuffer buffer) throws NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException, PDUException {
        this.setMessageId(buffer.removeCString());
        this.sourceAddr.setData(buffer);
    }

    public ByteBuffer getBody() {
        ByteBuffer buffer = new ByteBuffer();
        buffer.appendCString(this.messageId);
        buffer.appendBuffer(this.getSourceAddr().getData());
        return buffer;
    }

    public void setMessageId(String value) throws WrongLengthOfStringException {
        QuerySM.checkString(value, 64);
        this.messageId = value;
    }

    public void setSourceAddr(Address value) {
        this.sourceAddr = value;
    }

    public void setSourceAddr(String address) throws WrongLengthOfStringException {
        this.setSourceAddr(new Address(address));
    }

    public void setSourceAddr(byte ton, byte npi, String address) throws WrongLengthOfStringException {
        this.setSourceAddr(new Address(ton, npi, address));
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Address getSourceAddr() {
        return this.sourceAddr;
    }

    public String debugString() {
        String dbgs = "(query: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + this.getMessageId();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.getSourceAddr().debugString();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.debugStringOptional();
        dbgs = dbgs + ") ";
        return dbgs;
    }
}

