/*
 * Decompiled with CFR 0.152.
 */
package org.smpp;

import org.smpp.SmppException;

public class WrongSessionStateException
extends SmppException {
    boolean hasSessionDetails = false;
    int sessionType;
    int expectedState;
    int currentState;

    public WrongSessionStateException() {
        super("The operation required is not possible in the current session state.");
    }

    public WrongSessionStateException(int sessionType, int expectedState, int currentState) {
        this();
        this.hasSessionDetails = true;
        this.sessionType = sessionType;
        this.expectedState = expectedState;
        this.currentState = currentState;
    }

    public String getMessage() {
        if (this.hasSessionDetails) {
            String typeDescription = "";
            switch (this.sessionType) {
                case 1: {
                    typeDescription = "ESME";
                    break;
                }
                case 2: {
                    typeDescription = "MC";
                    break;
                }
                default: {
                    typeDescription = "UNKNOWN";
                }
            }
            String msg = this.expectedState != 0 ? "The operation is not allowed in the current " + typeDescription + " session state. " + "Current state is " + WrongSessionStateException.getStateDescription(this.currentState) + " required state(s) is " + WrongSessionStateException.getStateDescription(this.expectedState) + "." : "The operation is not allowed in " + typeDescription + " session. ";
            return msg;
        }
        return super.getMessage();
    }

    public static String getStateDescription(int state) {
        String descr = "";
        descr = descr + WrongSessionStateException.getStateDescription(state, 1, descr, "closed");
        descr = descr + WrongSessionStateException.getStateDescription(state, 2, descr, "opened");
        descr = descr + WrongSessionStateException.getStateDescription(state, 4, descr, "transmitter");
        descr = descr + WrongSessionStateException.getStateDescription(state, 8, descr, "receiver");
        descr = descr + WrongSessionStateException.getStateDescription(state, 16, descr, "transceiver");
        if ((descr = descr + WrongSessionStateException.getStateDescription(state, 30, descr, "any")).equals("")) {
            descr = "unknown";
        }
        return descr;
    }

    public static String getStateDescription(int state, int testState, String currentDescr, String descr) {
        if ((state & testState) == testState) {
            if (currentDescr.length() > 0) {
                return ", " + descr;
            }
            return descr;
        }
        return "";
    }
}

