/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.debug.Debug;
import ice.util.Defs;
import ice.util.io.LazyCachedInputStream;
import ice.util.io.MarkerInputStream;
import ice.util.net.HeaderMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class HttpMessage
implements Cloneable,
Serializable {
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String CONNECTION = "Connection";
    public static final String DATE = "Date";
    public static final String PRAGMA = "Pragma";
    public static final String TRAILER = "Trailer";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String UPGRADE = "Upgrade";
    public static final String VIA = "Via";
    public static final String WARNING = "Warning";
    public static final String KEEP_ALIVE = "Keep-Alive";
    public static final String PROXY_CONNECTION = "Proxy-Connection";
    public static final String HTTP_10 = "HTTP/1.0";
    public static final String HTTP_11 = "HTTP/1.1";
    public static final int RESPONSE_IS_STALE = 110;
    public static final int REVALIDATION_FAILED = 111;
    public static final int DISCONNECTED_OPERATION = 112;
    public static final int HEURISTIC_EXPIRATION = 113;
    public static final int MISCELLANEOUS_WARNING = 199;
    public static final int TRANSFORMATION_APPLIED = 214;
    public static final int MISCELLANEOUS_PERSISTENT_WARNING = 299;
    protected static final String CR_LF = "\r\n";
    protected static final String COLON = ":";
    protected static final String SPACE = " ";
    protected EntityBody entityBody;
    protected HeaderMap headerMap = new HeaderMap();
    protected String httpVersion;

    protected HttpMessage(String httpVersion) throws IllegalArgumentException {
        this.setHttpVersion(httpVersion);
    }

    public void clearHeaders() {
        this.headerMap.clear();
    }

    public Object clone() {
        try {
            HttpMessage _httpMessage = (HttpMessage)super.clone();
            if (this.entityBody != null) {
                _httpMessage.entityBody = (EntityBody)this.entityBody.clone();
            }
            _httpMessage.headerMap = (HeaderMap)this.headerMap.clone();
            return _httpMessage;
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError();
        }
    }

    public boolean containsHeader(String fieldName) {
        return this.headerMap.containsFieldName(fieldName);
    }

    public void dispose() {
        if (this.entityBody != null) {
            this.entityBody.dispose();
        }
    }

    public boolean equals(Object object) {
        return object instanceof HttpMessage && ((HttpMessage)object).httpVersion.equalsIgnoreCase(this.httpVersion) && ((HttpMessage)object).headerMap.equals((Object)this.headerMap) && ((HttpMessage)object).entityBody == null ? this.entityBody == null : ((HttpMessage)object).entityBody.equals(this.entityBody);
    }

    public byte[] getBytes() {
        byte[] _bytes = this.getMessage(false).getBytes();
        if (this.entityBody != null) {
            byte[] _entityBody = this.entityBody.getBytes();
            byte[] _temp = _bytes;
            _bytes = new byte[_temp.length + _entityBody.length];
            System.arraycopy(_temp, 0, _bytes, 0, _temp.length);
            System.arraycopy(_entityBody, 0, _bytes, _temp.length, _entityBody.length);
        }
        return _bytes;
    }

    public EntityBody getEntityBody() {
        return this.entityBody;
    }

    public HeaderMap.Header getHeader(int index) {
        return this.headerMap.get(index);
    }

    public int getHeaderCount() {
        return this.headerMap.getSize();
    }

    public String getFieldName(int index) {
        return this.headerMap.getFieldName(index);
    }

    public String getFieldValue(int index) {
        return this.headerMap.getFieldValue(index);
    }

    public String[] getFieldValues(String fieldName) {
        return this.headerMap.getFieldValues(fieldName);
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public int getLength() {
        return this.getBytes().length;
    }

    public String getMessage() {
        return this.getMessage(false);
    }

    public abstract String getMessage(boolean var1);

    public abstract String getStartLine();

    public void putHeader(String fieldName, String fieldValue) {
        this.headerMap.putHeader(fieldName, fieldValue);
    }

    public void removeHeader(int index) {
        this.headerMap.removeHeader(index);
    }

    public void removeHeaders(String fieldName) {
        this.headerMap.removeHeaders(fieldName);
    }

    public void setEntityBody(EntityBody entityBody) {
        this.entityBody = entityBody;
    }

    public void setHttpVersion(String httpVersion) throws IllegalArgumentException {
        if (httpVersion == null) {
            throw new IllegalArgumentException("httpVersion is null");
        }
        if (httpVersion.trim().length() == 0) {
            throw new IllegalArgumentException("httpVersion is empty");
        }
        this.httpVersion = httpVersion.toUpperCase();
    }

    public static class EntityBody
    implements Cloneable,
    Serializable {
        public static final String ALLOW = "Allow";
        public static final String CONTENT_BASE = "Content-Base";
        public static final String CONTENT_ENCODING = "Content-Encoding";
        public static final String CONTENT_LANGUAGE = "Content-Language";
        public static final String CONTENT_LENGTH = "Content-Length";
        public static final String CONTENT_LOCATION = "Content-Location";
        public static final String CONTENT_MD5 = "Content-MD5";
        public static final String CONTENT_RANGE = "Content-Range";
        public static final String CONTENT_TYPE = "Content-Type";
        public static final String EXPIRES = "Expires";
        public static final String LAST_MODIFIED = "Last-Modified";
        protected byte[] bytes;
        protected transient InputStream inputStream;

        public EntityBody(byte[] bytes) throws IllegalArgumentException {
            if (bytes == null) {
                throw new IllegalArgumentException("bytes is null");
            }
            this.bytes = bytes;
        }

        public EntityBody(InputStream inputStream) throws IllegalArgumentException {
            if (inputStream == null) {
                throw new IllegalArgumentException("inputStream is null");
            }
            this.inputStream = EntityBody.isLazyCacheInputStreamDisabled() ? inputStream : new LazyCachedInputStream(inputStream);
        }

        public Object clone() {
            try {
                EntityBody _entityBody = (EntityBody)super.clone();
                return _entityBody;
            }
            catch (CloneNotSupportedException exception) {
                throw new InternalError();
            }
        }

        public void dispose() {
            if (this.inputStream != null) {
                this.getBytes();
                try {
                    this.inputStream.close();
                }
                catch (IOException exception) {
                    Debug.ex((Throwable)exception);
                }
                this.inputStream = null;
            }
        }

        public boolean equals(Object object) {
            return true;
        }

        public byte[] getBytes() {
            if (this.bytes == null) {
                try {
                    byte _byte;
                    ByteArrayOutputStream _byteArrayOutputStream = new ByteArrayOutputStream();
                    InputStream _inputStream = this.getInputStream();
                    while ((_byte = (byte)_inputStream.read()) != -1) {
                        _byteArrayOutputStream.write(_byte);
                    }
                    this.bytes = _byteArrayOutputStream.toByteArray();
                }
                catch (IOException exception) {
                    Debug.ex((Throwable)exception);
                }
            }
            return this.bytes;
        }

        public InputStream getInputStream() {
            if (this.inputStream == null) {
                this.inputStream = EntityBody.isLazyCacheInputStreamDisabled() ? new ByteArrayInputStream(this.bytes) : new LazyCachedInputStream((InputStream)new ByteArrayInputStream(this.bytes));
            }
            if (this.inputStream instanceof LazyCachedInputStream) {
                return new MarkerInputStream((LazyCachedInputStream)this.inputStream);
            }
            return this.inputStream;
        }

        public String toString() {
            return new String(this.getBytes());
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            this.getBytes();
            objectOutputStream.defaultWriteObject();
        }

        private static boolean isLazyCacheInputStreamDisabled() {
            return Defs.booleanProperty((String)"ice.net.lazyCacheInputStreamDisabled", (boolean)false);
        }
    }
}

