/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.debug.Debug;
import ice.net.Cache;
import ice.net.CacheCallback;
import ice.net.CacheManagerSettings;
import ice.net.CachedObject;
import ice.net.HttpMessage;
import ice.net.HttpResponse;
import ice.net.HttpSession;
import ice.net.HttpURLConnection;
import ice.util.Defs;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CacheManager {
    private boolean persistPrivateResponses;
    Hashtable theCaches = new Hashtable();
    Vector theCachesP = new Vector();
    boolean useCache = false;
    long clockskew = -1L;
    private boolean alwaysRevalidate;
    private int cacheExpirationBuffer;
    private boolean logEnabled = false;
    private HttpSession httpSession;

    public CacheManager() {
        this(new CacheManagerSettings());
    }

    public CacheManager(CacheManagerSettings cacheManagerSettings) {
        this.alwaysRevalidate = cacheManagerSettings.shouldAlwaysRevalidate();
        this.cacheExpirationBuffer = cacheManagerSettings.getCacheExpirationBuffer();
        this.persistPrivateResponses = cacheManagerSettings.shouldPersistPrivateResponses();
        if (Defs.sysPropertyBoolean((String)"ice.net.debug.cache", (boolean)false) || Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
            this.logEnabled = true;
        }
    }

    public CacheManager(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    public int getCacheExpirationBuffer() {
        return this.cacheExpirationBuffer;
    }

    public boolean shouldAlwaysRevalidate() {
        if (this.httpSession == null) {
            return this.alwaysRevalidate;
        }
        return this.httpSession.alwaysRevalidate;
    }

    public boolean shouldPersistPrivateResponses() {
        return this.persistPrivateResponses;
    }

    HttpSession getSession() {
        return this.httpSession;
    }

    int getMaxCacheable(java.net.HttpURLConnection httpUrlConnection) {
        String _contentType;
        if (!(this.theCachesP.size() <= 0 || (_contentType = httpUrlConnection.getContentType()) != null && _contentType.equalsIgnoreCase("application/x-shockwave-flash"))) {
            return (int)((Cache)this.theCachesP.elementAt(0)).getMaxSize();
        }
        return 0;
    }

    int getMaxCacheable(HttpURLConnection httpUrlConnection) {
        return this.getMaxCacheable((java.net.HttpURLConnection)httpUrlConnection);
    }

    public Cache getCache(int cachePriority) {
        if (cachePriority < 0 || cachePriority >= this.theCachesP.size()) {
            return null;
        }
        return (Cache)this.theCachesP.elementAt(cachePriority);
    }

    public void addCache(Cache aCache) {
        aCache.setManager(this);
        this.theCaches.put(aCache.getName(), aCache);
        this.theCachesP.addElement(aCache);
    }

    public Cache removeCache(String cacheName) {
        Cache aCache = (Cache)this.theCaches.get(cacheName);
        this.theCaches.remove(cacheName);
        this.theCachesP.removeElementAt(this.getPriority(aCache));
        return aCache;
    }

    public int getPriority(Cache c) {
        if (c == null) {
            return -1;
        }
        String cName = c.getName();
        int length = this.theCachesP.size();
        for (int i = 0; i < length; ++i) {
            if (!cName.equals(((Cache)this.theCachesP.elementAt(i)).getName())) continue;
            return i;
        }
        return -1;
    }

    public Cache getCache(String cacheName) {
        Cache aCache = (Cache)this.theCaches.get(cacheName);
        return aCache;
    }

    public void useCache(boolean choice) {
        this.useCache = choice;
    }

    public boolean isCacheOn() {
        return this.useCache;
    }

    public boolean clearCache(String cacheName) {
        if (!this.theCaches.containsKey(cacheName)) {
            return false;
        }
        Cache aCache = (Cache)this.theCaches.get(cacheName);
        aCache.clear();
        return true;
    }

    public void clearAllCaches() {
        Enumeration e = this.theCaches.elements();
        while (e.hasMoreElements()) {
            ((Cache)e.nextElement()).clear();
        }
    }

    public boolean clearExpired(String cacheName) {
        if (!this.theCaches.containsKey(cacheName)) {
            return false;
        }
        Cache aCache = (Cache)this.theCaches.get(cacheName);
        aCache.clearExpired();
        return true;
    }

    public void clearAllExpired() {
        Enumeration e = this.theCaches.elements();
        while (e.hasMoreElements()) {
            ((Cache)e.nextElement()).clearExpired();
        }
    }

    protected void removeURL(URL url) {
        Enumeration e = this.theCaches.elements();
        while (e.hasMoreElements()) {
            ((Cache)e.nextElement()).delete(url.toString(), false);
        }
    }

    CachedObject getCachedObject(URL url, CacheCallback theRequester) {
        String anUrl = url.toString();
        String s = null;
        s = theRequester.getRequestProperty("Cache-Control");
        if (s == null) {
            s = theRequester.getRequestProperty("Pragma");
        }
        if (s != null && "no-cache".equalsIgnoreCase(s)) {
            this.removeURL(url);
            return null;
        }
        boolean found = false;
        Cache c = null;
        CachedObject o = null;
        if (anUrl.indexOf(35) != -1) {
            int place = anUrl.indexOf(35);
            anUrl = anUrl.substring(0, place);
        }
        int length = this.theCachesP.size();
        int foundAt = -1;
        for (int i = 0; i < length; ++i) {
            c = (Cache)this.theCachesP.elementAt(i);
            if (!c.has(anUrl) || (o = c.get(anUrl)) == null) continue;
            foundAt = i;
            found = true;
            break;
        }
        if (foundAt > 0) {
            Cache target = (Cache)this.theCachesP.elementAt(0);
            target.submit(o);
        }
        if (!found) {
            return null;
        }
        o.setCacheManager(this);
        return o;
    }

    public InputStream getCachedContent(URL url, CacheCallback cacheCallback) {
        CachedObject _cachedObject = this.getCachedObject(url, cacheCallback);
        if (_cachedObject == null) {
            return null;
        }
        ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(_cachedObject.getResponse().getEntityBody().getBytes());
        String[] _fieldNames = _cachedObject.getHeaderKeys();
        String[] _fieldValues = _cachedObject.getHeaders();
        for (int i = 0; i < _fieldNames.length; ++i) {
            cacheCallback.parseHeaderLine(_fieldNames[i] + ": " + _fieldValues[i]);
        }
        return _byteArrayInputStream;
    }

    public synchronized void submit(byte[] bytes, java.net.HttpURLConnection httpUrlConnection) {
        if (this.useCache) {
            boolean isFresh;
            String[] _cacheControlFieldValues;
            CachedObject _cachedObject = null;
            _cachedObject = httpUrlConnection instanceof HttpURLConnection ? this.createCachedObject((HttpURLConnection)httpUrlConnection) : this.createCachedObject(httpUrlConnection);
            _cachedObject.getResponse().setEntityBody(new HttpMessage.EntityBody(bytes));
            int _statusCode = _cachedObject.getResponse().getStatusCode();
            boolean _cacheable = true;
            if ("POST".equalsIgnoreCase(httpUrlConnection.getRequestMethod())) {
                _cacheable = false;
            } else if (_statusCode == 401) {
                _cacheable = false;
            } else if (httpUrlConnection.getURL().getFile().indexOf(63) != -1) {
                String[] _expiresFieldValues = _cachedObject.getResponse().getFieldValues("Expires");
                _cacheControlFieldValues = _cachedObject.getResponse().getFieldValues("Cache-Control");
                if (_expiresFieldValues.length == 0 && (_cacheControlFieldValues.length == 0 || _cacheControlFieldValues[0].indexOf("max-age") == -1)) {
                    _cacheable = false;
                }
            }
            if (_cacheable) {
                String[] _pragmaFieldValues = _cachedObject.getResponse().getFieldValues("Pragma");
                for (int i = 0; i < _pragmaFieldValues.length; ++i) {
                    if (_pragmaFieldValues[i].equalsIgnoreCase("no-cache")) {
                        _cacheable = false;
                        break;
                    }
                    if (!_pragmaFieldValues[i].equalsIgnoreCase("private") || this.shouldPersistPrivateResponses()) continue;
                    _cacheable = false;
                    break;
                }
            }
            if (!(isFresh = CachedObject.isFresh(_cachedObject.getAge(), _cachedObject.getDate(), _cachedObject.getRequestTime(), _cachedObject.getRequestTime(), _cachedObject.getMaxAge(), _cachedObject.getExpires(), _cachedObject.getLastModified(), this.getCacheExpirationBuffer() * 1000))) {
                if (this.logEnabled) {
                    Debug.trace((String)("CacheManager NOT caching: " + _cachedObject.getURL() + ", resource already expired"));
                }
                _cacheable = false;
            }
            if (_cacheable) {
                _cacheControlFieldValues = _cachedObject.getResponse().getFieldValues("Cache-Control");
                for (int i = 0; i < _cacheControlFieldValues.length; ++i) {
                    if (_cacheControlFieldValues[i].equalsIgnoreCase("no-cache") || _cacheControlFieldValues[i].equalsIgnoreCase("no-store") || _cacheControlFieldValues[i].equalsIgnoreCase("must-revalidate")) {
                        _cacheable = false;
                        break;
                    }
                    if (!_cacheControlFieldValues[i].equalsIgnoreCase("private") || this.shouldPersistPrivateResponses()) continue;
                    _cacheable = false;
                    break;
                }
            }
            if (_cacheable) {
                int _cachedObjectSize = _cachedObject.size();
                int _size = this.theCachesP.size();
                for (int i = 0; i < _size; ++i) {
                    Cache _cache = (Cache)this.theCachesP.elementAt(i);
                    if (_cache.getMaxSize() <= (long)_cachedObjectSize) continue;
                    _cache.submit(_cachedObject);
                    if (!this.logEnabled) continue;
                    Debug.trace((String)("Added to the " + _cache.getName() + ": " + _cachedObject.getURL()));
                }
            }
        }
    }

    public synchronized void submit(byte[] bytes, HttpURLConnection httpUrlConnection) {
        this.submit(bytes, (java.net.HttpURLConnection)httpUrlConnection);
    }

    public void status() {
        Enumeration e = this.theCaches.elements();
        while (e.hasMoreElements()) {
            Cache cache = (Cache)e.nextElement();
        }
    }

    public boolean isExpired(CachedObject cachedObject) {
        return !cachedObject.isFresh();
    }

    public boolean isExpired(long expires, long recieved, long lastModified, long maxAge) {
        return this.testExpired(expires, recieved, lastModified, maxAge);
    }

    private boolean testExpired(long expires, long recieved, long lastModified, long maxAge) {
        if (recieved < lastModified) {
            return false;
        }
        if (expires != -1L) {
            return expires <= System.currentTimeMillis();
        }
        if (maxAge != -1L && System.currentTimeMillis() - recieved > maxAge) {
            return false;
        }
        long baseTime = recieved - lastModified;
        long timeIncache = System.currentTimeMillis() - recieved;
        return timeIncache > baseTime;
    }

    private CachedObject createCachedObject(java.net.HttpURLConnection httpUrlConnection) {
        CachedObject _cachedObject = null;
        try {
            HttpResponse _httpResponse = HttpResponse.createHttpResponse(httpUrlConnection);
            _httpResponse.setResponseTime(System.currentTimeMillis());
            _cachedObject = this.httpSession == null ? new CachedObject(_httpResponse, this) : new CachedObject(_httpResponse, this.httpSession);
            _cachedObject.setURL(httpUrlConnection.getURL().toString());
            _cachedObject.setRequestTime(System.currentTimeMillis());
        }
        catch (ProtocolException protocolException) {
            // empty catch block
        }
        return _cachedObject;
    }

    private CachedObject createCachedObject(HttpURLConnection httpUrlConnection) {
        CachedObject _cachedObject = this.httpSession == null ? new CachedObject(httpUrlConnection.getResponse(), this) : new CachedObject(httpUrlConnection.getResponse(), this.httpSession);
        _cachedObject.setURL(httpUrlConnection.getURL().toString());
        _cachedObject.setRequestTime(httpUrlConnection.getRequest().getRequestTime());
        return _cachedObject;
    }

    public void wasDeleted(CachedObject o, Cache c) {
        int pri;
        int destindex = this.getPriority(c) + 1;
        if (destindex < this.theCachesP.size() && (pri = this.getPriority(c)) < this.theCachesP.size() - 1) {
            ((Cache)this.theCachesP.elementAt(pri + 1)).submit(o);
        }
    }
}

