/*
 * Decompiled with CFR 0.152.
 */
package ice.authentication;

import ice.authentication.AbstractAuthenticationManager;
import ice.authentication.Authentication;
import ice.authentication.AuthenticationHandler;
import ice.authentication.AuthenticationManager;
import ice.debug.Debug;
import ice.util.Defs;
import java.net.URL;
import java.util.StringTokenizer;

public class DefaultAuthenticationManager
extends AbstractAuthenticationManager
implements AuthenticationManager {
    public DefaultAuthenticationManager() {
        if (Defs.sysPropertyBoolean((String)"ice.authentication.ntlm.enabled", (boolean)false)) {
            this.addAuthenticationHandler("NTLM", "ice.authentication.ntlm.NtlmAuthenticationHandler");
        }
    }

    public synchronized Authentication handleChallenge(String challenge, URL requestUri, boolean isProxyAuthentication) {
        Authentication _authentication = null;
        StringTokenizer _tokens = new StringTokenizer(challenge);
        if (_tokens.hasMoreTokens()) {
            String _authenticationName = _tokens.nextToken();
            AuthenticationHandler _authenticationHandler = this.getAuthenticationHandler(_authenticationName);
            if (_authenticationHandler == null) {
                if (Defs.sysPropertyBoolean((String)"ice.authentication.debug", (boolean)Defs.sysPropertyBoolean((String)"ice.debug.debug", (boolean)false))) {
                    Debug.trace((String)("No handler found for " + _authenticationName + " " + "authentication"));
                }
            } else {
                String _challenge = null;
                if (_tokens.hasMoreTokens()) {
                    _challenge = challenge.substring(_authenticationName.length() + 1);
                }
                _authentication = _authenticationHandler.handleChallenge(_challenge, requestUri, isProxyAuthentication);
            }
        }
        return _authentication;
    }
}

