/*
 * Decompiled with CFR 0.152.
 */
package ice.authentication;

import ice.authentication.Authentication;
import ice.authentication.AuthenticationEvent;
import ice.authentication.AuthenticationHandler;
import ice.authentication.AuthenticationListener;
import ice.authentication.AuthenticationManager;
import ice.debug.Debug;
import ice.util.Defs;
import ice.util.alg.Listeners;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractAuthenticationManager
implements AuthenticationManager {
    protected Object authenticationListenerSet;
    protected Hashtable authenticationHandlerMap = new Hashtable();
    protected Hashtable authenticationHandlerInstanceMap = new Hashtable();

    public void addAuthentication(Authentication authentication) {
        if (authentication != null) {
            AuthenticationHandler _authenticationHandler = this.getAuthenticationHandler(authentication.getScheme());
            if (_authenticationHandler == null) {
                if (Defs.sysPropertyBoolean((String)"ice.authentication.debug", (boolean)Defs.sysPropertyBoolean((String)"ice.debug.debug", (boolean)false))) {
                    Debug.trace((String)("No handler found for " + authentication.getScheme() + " authentication"));
                }
                return;
            }
            _authenticationHandler.addAuthentication(authentication);
        }
    }

    public void addAuthenticationHandler(String authenticationName, String className) {
        if (authenticationName != null && authenticationName.trim().length() != 0 && className != null && className.trim().length() != 0) {
            this.authenticationHandlerMap.put(authenticationName, className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuthenticationListener(AuthenticationListener authenticationListener) {
        if (authenticationListener != null) {
            AbstractAuthenticationManager abstractAuthenticationManager = this;
            synchronized (abstractAuthenticationManager) {
                this.authenticationListenerSet = Listeners.add((Object)this.authenticationListenerSet, (Object)authenticationListener);
            }
        }
    }

    public void clearAuthenticationHandlers() {
        this.authenticationHandlerMap.clear();
    }

    public void clearAuthentications() {
        Enumeration _authenticationHandlers = this.authenticationHandlerInstanceMap.elements();
        while (_authenticationHandlers.hasMoreElements()) {
            ((AuthenticationHandler)_authenticationHandlers.nextElement()).clearAuthentications();
        }
    }

    public void fireAuthenticationEvent(Authentication authentication) {
        if (authentication == null) {
            return;
        }
        if (this.authenticationListenerSet != null) {
            AuthenticationEvent _event = new AuthenticationEvent(this, authentication);
            if (!(this.authenticationListenerSet instanceof Object[])) {
                ((AuthenticationListener)this.authenticationListenerSet).onAuthenticationEvent(_event);
            } else {
                for (int i = 0; i < ((Object[])this.authenticationListenerSet).length; ++i) {
                    ((AuthenticationListener)((Object[])this.authenticationListenerSet)[i]).onAuthenticationEvent(_event);
                }
            }
        }
    }

    public Authentication[] getAllAuthentications() {
        Object[] _authentications;
        Vector<Object> _authenticationList = new Vector<Object>();
        Enumeration _authenticationHandlers = this.authenticationHandlerInstanceMap.elements();
        while (_authenticationHandlers.hasMoreElements()) {
            _authentications = ((AuthenticationHandler)_authenticationHandlers.nextElement()).getAllAuthentications();
            for (int i = 0; i < _authentications.length; ++i) {
                _authenticationList.addElement(_authentications[i]);
            }
        }
        _authentications = new Authentication[_authenticationList.size()];
        _authenticationList.copyInto(_authentications);
        return _authentications;
    }

    public AuthenticationHandler getAuthenticationHandler(String authenticationName) {
        AuthenticationHandler _authenticationHandler = null;
        String _className = (String)this.authenticationHandlerMap.get(authenticationName);
        if (_className != null) {
            if (this.authenticationHandlerInstanceMap.containsKey(_className)) {
                _authenticationHandler = (AuthenticationHandler)this.authenticationHandlerInstanceMap.get(_className);
            } else {
                _authenticationHandler = (AuthenticationHandler)Defs.newClassInstance((String)_className);
                if (_authenticationHandler != null) {
                    _authenticationHandler.setAuthenticationManager(this);
                    this.authenticationHandlerInstanceMap.put(_className, _authenticationHandler);
                }
            }
        }
        return _authenticationHandler;
    }

    public boolean hasAuthenticationListeners() {
        return this.authenticationListenerSet != null;
    }

    public void removeAuthentication(Authentication authentication) {
        if (authentication != null) {
            AuthenticationHandler _authenticationHandler = this.getAuthenticationHandler(authentication.getScheme());
            if (_authenticationHandler == null) {
                if (Defs.sysPropertyBoolean((String)"ice.authentication.debug", (boolean)Defs.sysPropertyBoolean((String)"ice.debug.debug", (boolean)false))) {
                    Debug.trace((String)("No handler found for " + authentication.getScheme() + " authentication"));
                }
                return;
            }
            _authenticationHandler.removeAuthentication(authentication);
        }
    }

    public void removeAuthenticationHandler(String authenticationName) {
        this.authenticationHandlerMap.remove(authenticationName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAuthenticationListener(AuthenticationListener authenticationListener) {
        if (authenticationListener != null) {
            AbstractAuthenticationManager abstractAuthenticationManager = this;
            synchronized (abstractAuthenticationManager) {
                this.authenticationListenerSet = Listeners.remove((Object)this.authenticationListenerSet, (Object)authenticationListener);
            }
        }
    }

    protected AbstractAuthenticationManager() {
    }
}

