/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.azure.blob.consumer;

import coldfusion.azure.blob.config.BlobRetryType;
import coldfusion.azure.blob.config.RetryConfig;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import java.util.Collections;
import java.util.Objects;

public class RetryConfigConsumer
extends ConsumerMap<RetryConfig> {
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static RetryConfigConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RetryConfigConsumer getInstance() {
        if (instance != null) return instance;
        Class<RetryConfigConsumer> clazz = RetryConfigConsumer.class;
        synchronized (RetryConfigConsumer.class) {
            instance = new RetryConfigConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private RetryConfigConsumer() {
        this.put("retryPolicyType", new ConsumerValidator((retryConfig, value) -> {
            try {
                retryConfig.setRetryPolicyType(BlobRetryType.valueOf(this.cast.getStringProperty(value).toUpperCase()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }, Collections.singletonList(Objects::nonNull)));
        this.put("deltaBackoffIntervalInMs", new ConsumerValidator((retryConfig, value) -> {
            int timespan = this.cast.getIntegerProperty(value);
            ValidationUtil.validNumberInRange((long)timespan, (long)0L, (long)30000L, (String)"deltaBackoffIntervalInMs");
            retryConfig.setDeltaBackoffIntervalInMs(timespan);
        }, Collections.emptyList()));
        this.put("maximumAttempts", new ConsumerValidator((retryConfig, value) -> {
            int timespan = this.cast.getIntegerProperty(value);
            ValidationUtil.validPositiveNumber((long)timespan, (String)"maximumAttempts");
            retryConfig.setMaximumAttempts(this.cast.getIntegerProperty(value));
        }, Collections.emptyList()));
        this.put("resolvedMinBackoff", new ConsumerValidator((retryConfig, value) -> {
            int timespan = this.cast.getIntegerProperty(value);
            ValidationUtil.validNumberInRange((long)timespan, (long)0L, (long)30000L, (String)"resolvedMinBackoff");
            retryConfig.setResolvedMinBackoff(timespan);
        }, Collections.emptyList()));
        this.put("resolvedMaxBackoff", new ConsumerValidator((retryConfig, value) -> {
            int timespan = this.cast.getIntegerProperty(value);
            ValidationUtil.validNumberInRange((long)timespan, (long)0L, (long)30000L, (String)"resolvedMaxBackoff");
            retryConfig.setResolvedMaxBackoff(this.cast.getIntegerProperty(value));
        }, Collections.emptyList()));
    }
}

