/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.excel.parallel;

import coldfusion.excel.Excel;
import coldfusion.excel.ExcelInfo;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.Scope;
import coldfusion.runtime.UDFMethod;
import coldfusion.sql.DataSrcImpl;
import coldfusion.tagext.lang.SpreadSheetTag;
import jakarta.servlet.jsp.PageContext;
import java.util.concurrent.Callable;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class SpreadsheetProcessingCallable
implements Callable {
    Sheet sheet = null;
    ExcelInfo excelInfo;
    UDFMethod rowProcessor;
    FusionContext fusionContext;
    NeoPageContext pageContext;
    RequestMonitorData requestMonitorData;

    public SpreadsheetProcessingCallable(Sheet sheet, ExcelInfo sheetInfo, UDFMethod rowProcessor, FusionContext fcontext, NeoPageContext pageContext, RequestMonitorData requestMonitorData) {
        this.sheet = sheet;
        this.excelInfo = sheetInfo;
        this.rowProcessor = rowProcessor;
        try {
            this.pageContext = (NeoPageContext)pageContext.clone();
            this.fusionContext = (FusionContext)fcontext.clone();
            this.fusionContext.hiddenScope = (Scope)fcontext.hiddenScope.clone();
            this.pageContext.setFusionContext(this.fusionContext);
        }
        catch (Exception e) {
            this.pageContext = pageContext;
            this.fusionContext = fcontext;
        }
        this.requestMonitorData = requestMonitorData;
    }

    public ExcelInfo call() throws Exception {
        try {
            for (Row r : this.sheet) {
                int rowNum = r.getRowNum() + 1;
                short lastCellNum = r.getLastCellNum();
                String[] rowCells = new String[lastCellNum];
                for (short cellindex = 0; cellindex < lastCellNum; cellindex = (short)(cellindex + 1)) {
                    rowCells[cellindex] = Excel.getValueAt(r, cellindex);
                }
                Excel.addRow(this.excelInfo, rowCells, rowNum, 0, true, null);
                this.excelInfo.setUnderProcess(true);
                Object[] args = new Object[]{this.excelInfo, rowNum};
                CFPage page = this.setContextBeforeInvocation();
                this.rowProcessor.invoke(null, this.rowProcessor.getName(), (Object)page, args, this.fusionContext);
                this.excelInfo.setUnderProcess(false);
            }
        }
        catch (Throwable e) {
            throw new SpreadSheetTag.ExcelProcessingException(e);
        }
        finally {
            this.doResourceCleanup();
            this.fusionContext.setAsyncThread(false);
            this.pageContext = null;
            this.fusionContext = null;
            FusionContext.setCurrent(null);
        }
        return this.excelInfo;
    }

    private CFPage setContextBeforeInvocation() throws CloneNotSupportedException {
        FusionContext.setCurrent((FusionContext)this.fusionContext);
        this.fusionContext.pageContext = this.pageContext;
        this.pageContext.setFusionContext(this.fusionContext);
        CFPage page = (CFPage)((CFPage)this.fusionContext.pageContext.getPage())._clone();
        page.pageContext = this.pageContext;
        this.pageContext.setPage((Object)page);
        this.pageContext.initializeWith((Object)page, (PageContext)this.pageContext, this.pageContext.getVariableScope());
        this.fusionContext.setAsyncThread(true);
        return page;
    }

    private void doResourceCleanup() {
        try {
            DataSrcImpl.clearSqlProxy();
        }
        catch (Throwable e) {
            CFLogs.APPLICATION_LOG.error((Object)e.getMessage());
        }
    }
}

