/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document.pdf;

import coldfusion.document.DocumentPageLayout;
import coldfusion.document.pdf.InvalidEncryptionPermission;
import coldfusion.document.pdf.PdfDocumentWriter;
import coldfusion.document.pdf.PdfViewerPreferences;
import coldfusion.document.pdf.core.PdfPermissions;
import coldfusion.document.spi.DocumentProperties;
import coldfusion.document.spi.DocumentWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfWriter;
import java.io.OutputStream;

public class PdfDocumentProperties
extends DocumentProperties {
    public static final String FORMAT = "pdf";
    public static final String ENCRYPT_128_BIT = "128-bit";
    public static final String ENCRYPT_40_BIT = "40-bit";
    public static final String ENCRYPT_NONE = "none";
    private String userPassword;
    private String ownerPassword;
    private PdfViewerPreferences preference;
    private PdfPermissions pdfPermissions;
    private String encryption;
    private PdfDocumentWriter writer;
    private FontMapper fontMapper;
    private PdfWriter pdfWriter;

    public PdfDocumentProperties(DocumentPageLayout pageLayout, OutputStream out) throws DocumentException {
        super(pageLayout);
        this.pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)out);
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public void setOwnerPassword(String ownerPassword) {
        this.ownerPassword = ownerPassword;
    }

    public void setPreference(PdfViewerPreferences preference) {
        this.preference = preference;
    }

    public void setPdfPermission(PdfPermissions pdfPermissions) {
        this.pdfPermissions = pdfPermissions;
    }

    public void setFontMapper(FontMapper fontMapper) {
        this.fontMapper = fontMapper;
    }

    public String getEncryption() {
        return this.encryption;
    }

    public void setEncryption(String encryption) throws InvalidEncryptionPermission, DocumentException {
        int pdfPermissionBits;
        if (!(encryption.equalsIgnoreCase(ENCRYPT_128_BIT) || encryption.equalsIgnoreCase(ENCRYPT_40_BIT) || encryption.equalsIgnoreCase(ENCRYPT_NONE))) {
            throw new IllegalArgumentException(encryption);
        }
        this.encryption = encryption;
        int n = pdfPermissionBits = this.pdfPermissions == null ? 0 : this.pdfPermissions.getPermissionBits();
        if (encryption.equalsIgnoreCase(ENCRYPT_128_BIT)) {
            this.pdfWriter.setEncryption(true, this.userPassword, this.ownerPassword, pdfPermissionBits);
        } else if (encryption.equalsIgnoreCase(ENCRYPT_40_BIT)) {
            if ((pdfPermissionBits & 0x100) == 256 || (pdfPermissionBits & 0x200) == 512 || (pdfPermissionBits & 0x400) == 1024 || (pdfPermissionBits & 4) == 4 && (pdfPermissionBits & 0x804) != 2052) {
                throw new InvalidEncryptionPermission();
            }
            this.pdfWriter.setEncryption(false, this.userPassword, this.ownerPassword, pdfPermissionBits);
        }
    }

    @Override
    public synchronized DocumentWriter getWriter() throws DocumentException {
        if (this.writer == null) {
            this.document.open();
            if (this.preference != null) {
                this.pdfWriter.setViewerPreferences(this.preference.getPreferences());
            }
            this.writer = new PdfDocumentWriter(this.pdfWriter, this.fontMapper);
        }
        return this.writer;
    }
}

