/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document;

import coldfusion.document.OpenOfficeExport;
import coldfusion.runtime.ApplicationException;
import coldfusion.server.DocumentService;
import coldfusion.server.ServiceFactory;
import com.sun.star.lib.loader.Loader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class OpenOfficeUNOHelper {
    private String srcFile;
    private String destination;
    private boolean isPDF = true;
    private boolean isHtml = false;
    private ArrayList<HashMap> props;
    private ArrayList<Integer> slides;
    private String docOpenPassword;

    public OpenOfficeUNOHelper(String srcFile, String destination) {
        this.srcFile = srcFile;
        this.destination = destination;
        this.props = new ArrayList();
    }

    public void setIsHtml(boolean isHtml) {
        this.isHtml = isHtml;
        this.isPDF = false;
    }

    public void setOpenPassword(String password) {
        this.docOpenPassword = password;
    }

    public void setIsPDF(boolean isPDF) {
        this.isPDF = isPDF;
        this.isHtml = false;
    }

    public void setTaggedPDF(boolean tagged) {
        HashMap<String, Object> s = new HashMap<String, Object>();
        s.put("Name", "UseTaggedPDF");
        s.put("Value", tagged);
        this.props.add(s);
    }

    public void setPdfVersion(Integer version) {
        HashMap<String, Object> s = new HashMap<String, Object>();
        s.put("Name", "SelectPdfVersion");
        s.put("Value", version);
        this.props.add(s);
    }

    public void setExportFormFields(boolean formField) {
        HashMap<String, Object> s = new HashMap<String, Object>();
        s.put("Name", "ExportFormFields");
        s.put("Value", formField);
        this.props.add(s);
    }

    public void setFormsType(long type) {
        HashMap<String, Object> s = new HashMap<String, Object>();
        s.put("Name", "FormsType");
        s.put("Value", type);
        this.props.add(s);
    }

    public void setEncryptFile(boolean encrypt) {
        HashMap<String, Object> s = new HashMap<String, Object>();
        s.put("Name", "EncryptFile");
        s.put("Value", encrypt);
        this.props.add(s);
    }

    public void setDocumentOpenPassword(String password) {
        HashMap<String, String> s = new HashMap<String, String>();
        s.put("Name", "DocumentOpenPassword");
        s.put("Value", password);
        this.props.add(s);
    }

    public void setRestrictPermissions(boolean perm) {
        HashMap<String, Object> s = new HashMap<String, Object>();
        s.put("Name", "RestrictPermissions");
        s.put("Value", perm);
        this.props.add(s);
    }

    public void setPermissionPassword(String password) {
        HashMap<String, String> s = new HashMap<String, String>();
        s.put("Name", "PermissionPassword");
        s.put("Value", password);
        this.props.add(s);
    }

    public void setPrinting(Integer print) {
        HashMap<String, Object> s = new HashMap<String, Object>();
        s.put("Name", "Printing");
        s.put("Value", print);
        this.props.add(s);
    }

    public void setChanges(Integer changes) {
        HashMap<String, Object> s = new HashMap<String, Object>();
        s.put("Name", "Changes");
        s.put("Value", changes);
        this.props.add(s);
    }

    public void setEnableCopyingOfContent(boolean copy) {
        HashMap<String, Object> s = new HashMap<String, Object>();
        s.put("Name", "EnableCopyingOfContent");
        s.put("Value", copy);
        this.props.add(s);
    }

    public void setEnableTextAccessForAccessibilityTools(Boolean enable) {
        HashMap<String, Object> s = new HashMap<String, Object>();
        s.put("Name", "EnableTextAccessForAccessibilityTools");
        s.put("Value", enable);
        this.props.add(s);
    }

    public void setPageRange(ArrayList<Integer> range) {
        this.slides = range;
    }

    private static boolean isOOJarsAvailable() {
        String[] jars = new String[]{"juh.jar", "ridl.jar", "unoil.jar"};
        String rootdir = ServiceFactory.getRuntimeService().getRootDir();
        String oosdkpath = rootdir + "/lib/oosdk/lib";
        String oosdkclasses = rootdir + "/lib/oosdk/classes";
        boolean available = true;
        try {
            Class.forName("com.sun.star.lib.loader.Loader");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        for (String jar : jars) {
            if (new File(oosdkpath + "/" + jar).exists()) continue;
            available = false;
            break;
        }
        return available && new File(oosdkclasses).exists();
    }

    private static void setJavaClasspath(String currentcp) {
        String pathSeparatedCfusionLibPath = File.pathSeparator + ServiceFactory.getRuntimeService().getRootDir() + File.separator + "lib" + File.separator;
        System.setProperty("java.class.path", currentcp + pathSeparatedCfusionLibPath + "cfusion.jar" + pathSeparatedCfusionLibPath + "guava.jar" + pathSeparatedCfusionLibPath + "failureaccess.jar" + pathSeparatedCfusionLibPath + "json.jar" + pathSeparatedCfusionLibPath + "closure-compiler.jar");
    }

    public static boolean isLocalOOAvailable() {
        boolean result = false;
        String currentcp = System.getProperty("java.class.path");
        OpenOfficeUNOHelper.setJavaClasspath(currentcp);
        System.setProperty("java.class.path", currentcp);
        DocumentService docservice = ServiceFactory.getDocumentService();
        String path = docservice.getOfficeLocation();
        if (path != null && path.length() > 0) {
            OpenOfficeExport openofficeexp = new OpenOfficeExport();
            result = openofficeexp.isOOAvailable();
        }
        return result;
    }

    private static boolean isRemoteOOAvailable() {
        boolean result;
        DocumentService docservice = ServiceFactory.getDocumentService();
        String hostname = docservice.getOpenOfficeRemoteHost();
        String port = docservice.getOpenOfficeRemotePort();
        if (hostname == null || port == null || hostname.equalsIgnoreCase("") || port.equalsIgnoreCase("")) {
            return false;
        }
        try {
            String currentcp = System.getProperty("java.class.path");
            OpenOfficeUNOHelper.setJavaClasspath(currentcp);
            ClassLoader cl = OpenOfficeUNOHelper.doSetup();
            Class<?> c = cl.loadClass("coldfusion.document.OpenOfficeExport");
            Method m = c.getMethod("isOOAvailable", String.class, String.class);
            result = (Boolean)m.invoke(c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), hostname, port);
            System.setProperty("java.class.path", currentcp);
        }
        catch (ClassNotFoundException e) {
            result = false;
        }
        catch (NoSuchMethodException e) {
            result = false;
        }
        catch (IllegalAccessException e) {
            result = false;
        }
        catch (InvocationTargetException e) {
            result = false;
        }
        catch (InstantiationException e) {
            result = false;
        }
        return result;
    }

    public static boolean isOOAvailable() {
        if (OpenOfficeUNOHelper.isRemoteOOAvailable()) {
            return true;
        }
        return OpenOfficeUNOHelper.isLocalOOAvailable();
    }

    public static void doSetupOOPath() {
        DocumentService docservice = ServiceFactory.getDocumentService();
        String path = docservice.getOfficeLocation();
        if ((path = path.replaceAll("\"", "")) != null && !path.equalsIgnoreCase("")) {
            System.setProperty("com.sun.star.lib.loader.unopath", path);
        }
    }

    public static ClassLoader doSetup() {
        DocumentService docservice = ServiceFactory.getDocumentService();
        String path = docservice.getOfficeLocation();
        if ((path = path.replaceAll("\"", "")) != null && !path.equalsIgnoreCase("")) {
            System.setProperty("com.sun.star.lib.loader.unopath", path);
        }
        String className = null;
        ClassLoader loader = System.getSecurityManager() == null ? Loader.getCustomLoader() : (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Loader.getCustomLoader();
            }
        });
        Vector<URL> res = new Vector<URL>();
        try {
            Enumeration<URL> en = loader.getResources("META-INF/MANIFEST.MF");
            while (en.hasMoreElements()) {
                res.add(en.nextElement());
            }
            for (int i = res.size() - 1; i >= 0; --i) {
                URL jarurl = (URL)res.elementAt(i);
                try {
                    JarURLConnection jarConnection = (JarURLConnection)jarurl.openConnection();
                    Manifest mf = jarConnection.getManifest();
                    Attributes attrs = mf.getAttributes("com/sun/star/lib/loader/Loader.class");
                    if (attrs == null || (className = attrs.getValue("Application-Class")) == null) continue;
                    break;
                }
                catch (IOException e) {
                    System.err.println("com.sun.star.lib.loader.Loader::main: bad manifest file: " + e);
                }
            }
            if (!System.getProperty("os.name").startsWith("Windows")) {
                try {
                    String[] paths;
                    String uno_path = System.getProperty("com.sun.star.lib.loader.unopath");
                    File basis_lib = new File(uno_path + "/../basis-link/ure-link/lib");
                    String s = basis_lib.getAbsolutePath();
                    Field field = loader.getParent().getClass().getDeclaredField("usr_paths");
                    field.setAccessible(true);
                    for (String i : paths = (String[])field.get(null)) {
                        if (!s.equals(i)) continue;
                        return loader;
                    }
                    String[] tmp = new String[paths.length + 1];
                    System.arraycopy(paths, 0, tmp, 0, paths.length);
                    tmp[paths.length] = s;
                    field.set(null, tmp);
                    System.setProperty("java.library.path", System.getProperty("java.library.path") + File.pathSeparator + s);
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException e) {
            System.err.println("com.sun.star.lib.loader.Loader::main: cannot get manifest resources: " + e);
        }
        return loader;
    }

    public static void shutdownOffice() {
        DocumentService docservice = ServiceFactory.getDocumentService();
        String hostname = docservice.getOpenOfficeRemoteHost();
        String port = docservice.getOpenOfficeRemotePort();
        boolean remote = hostname != null && port != null && !hostname.equalsIgnoreCase("") && !port.equalsIgnoreCase("");
        Object exp = null;
        Class<?> c = null;
        if (File.separatorChar == '\\' && !remote) {
            try {
                String currentcp = System.getProperty("java.class.path");
                OpenOfficeUNOHelper.setJavaClasspath(currentcp);
                OpenOfficeUNOHelper.doSetup();
                ClassLoader cl = Loader.getCustomLoader();
                c = cl.loadClass("coldfusion.document.OpenOfficeExport");
                exp = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Method m = c.getMethod("shutdownOpenOffice", new Class[0]);
                m.invoke(exp, new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExport() {
        DocumentService docservice = ServiceFactory.getDocumentService();
        String hostname = docservice.getOpenOfficeRemoteHost();
        String port = docservice.getOpenOfficeRemotePort();
        boolean remote = false;
        remote = hostname != null && port != null && !hostname.equalsIgnoreCase("") && !port.equalsIgnoreCase("");
        OpenOfficeExport oexp = null;
        Object c = null;
        String currentcp = System.getProperty("java.class.path");
        try {
            OpenOfficeUNOHelper.setJavaClasspath(currentcp);
            OpenOfficeUNOHelper.doSetup();
            oexp = new OpenOfficeExport();
            if (remote) {
                oexp.setRemoteConfig(hostname, port);
            }
            if (this.docOpenPassword != null) {
                oexp.setDocOpenPassword(this.docOpenPassword);
            }
            if (this.isPDF) {
                oexp.exportPDF(this.srcFile, this.destination, this.props);
            } else if (this.isHtml) {
                oexp.exportHtml(this.srcFile, this.destination, this.props, this.slides);
            }
        }
        catch (Exception exception) {
        }
        finally {
            System.setProperty("java.class.path", currentcp);
        }
    }

    public static class CouldNotLoadOfficeException
    extends ApplicationException {
        public CouldNotLoadOfficeException(Throwable t) {
            super(t);
        }
    }

    public static class DocumentConversionException
    extends ApplicationException {
        public String message;
        public String name;

        public DocumentConversionException(String name, Throwable t) {
            this.message = t.getCause() != null ? t.getCause().toString() : t.getMessage();
            this.name = name;
        }
    }

    public static class DocumentPermissionException
    extends ApplicationException {
    }

    public static class InvalidSlideNumberException
    extends ApplicationException {
        public int slidenumber;

        public InvalidSlideNumberException(int slidenumber) {
            this.slidenumber = slidenumber;
        }
    }
}

