/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document;

import coldfusion.document.OOBootstrap;
import coldfusion.runtime.ApplicationException;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.UnoUrlResolver;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uri.ExternalUriReferenceTranslator;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;

public class OpenOfficeExport {
    private XComponentContext xContext;
    ArrayList<PropertyValue> prop = new ArrayList();
    ArrayList<Integer> slides;
    private String hostname;
    private String port;
    private boolean remote = false;
    private boolean html = false;
    private String openPassword = "";
    private int maxSlide;
    public int invalidSlide;
    private static String sPipeName = "uno_cf_pipe";

    private void addProperties(ArrayList<HashMap> props) {
        for (HashMap s : props) {
            PropertyValue p = new PropertyValue();
            p.Name = (String)s.get("Name");
            p.Value = s.get("Value");
            this.prop.add(p);
        }
        if (this.html) {
            PropertyValue p = new PropertyValue();
            p.Name = "Width";
            p.Value = 1024;
            this.prop.add(p);
            p = new PropertyValue();
            p.Name = "Format";
            p.Value = 1;
            this.prop.add(p);
            p = new PropertyValue();
            p.Name = "IsUseDocumentColors";
            p.Value = true;
            this.prop.add(p);
            p = new PropertyValue();
            p.Name = "Compression";
            p.Value = "75%";
            this.prop.add(p);
            p = new PropertyValue();
            p.Name = "PublishMode";
            p.Value = 0;
            this.prop.add(p);
            p = new PropertyValue();
            p.Name = "IsExportContentsPage";
            p.Value = true;
            this.prop.add(p);
            p = new PropertyValue();
            p.Name = "IsExportNotes";
            p.Value = false;
            this.prop.add(p);
            p = new PropertyValue();
            p.Name = "EnableDownload";
            p.Value = false;
            this.prop.add(p);
            p = new PropertyValue();
            p.Name = "UseButtonSet";
            p.Value = -1;
            this.prop.add(p);
        }
    }

    public boolean isOOAvailable() {
        this.xContext = this.getContext();
        return this.xContext != null;
    }

    public boolean isOOAvailable(String hostname, String port) {
        this.xContext = this.getContext(hostname, port);
        return this.xContext != null;
    }

    private void export(String srcFile, String destFile, ArrayList<HashMap> props, String conversionfilter) {
        if (this.remote) {
            this.xContext = this.getContext(this.hostname, this.port);
        } else if (this.xContext == null) {
            this.xContext = this.getContext();
        }
        if (this.xContext != null) {
            this.addProperties(props);
            this.convert(srcFile, destFile, conversionfilter);
        }
    }

    public void setDocOpenPassword(String password) {
        this.openPassword = password;
    }

    public void setRemoteConfig(String hostname, String port) {
        this.remote = true;
        this.hostname = hostname;
        this.port = port;
    }

    public void exportPDF(String srcFile, String destFile, ArrayList<HashMap> props) {
        String conversionfilter = "";
        if (srcFile.endsWith(".ppt") || srcFile.endsWith(".pptx")) {
            conversionfilter = "impress_pdf_Export";
        } else if (srcFile.endsWith(".doc") || srcFile.endsWith(".docx") || srcFile.endsWith(".txt") || srcFile.endsWith(".rtf")) {
            conversionfilter = "writer_pdf_Export";
        } else if (srcFile.endsWith(".xls") || srcFile.endsWith(".xlsx")) {
            conversionfilter = "calc_pdf_Export";
        } else {
            throw new InvalidDocumentTypeException(srcFile.substring(srcFile.lastIndexOf(".") + 1, srcFile.length()));
        }
        HashMap<String, Object> s = new HashMap<String, Object>();
        s.put("Name", "DisplayPDFDocumentTitle");
        s.put("Value", true);
        props.add(s);
        this.export(srcFile, destFile, props, conversionfilter);
    }

    public void exportHtml(String srcFile, String destFile, ArrayList<HashMap> props, ArrayList<Integer> slides) {
        String conversionfilter = "";
        this.html = true;
        if (!srcFile.endsWith(".ppt")) {
            throw new InvalidDocumentTypeException(srcFile.substring(srcFile.lastIndexOf(".") + 1, srcFile.length()));
        }
        conversionfilter = "impress_html_Export";
        if (slides != null) {
            this.slides = slides;
        }
        this.export(srcFile, destFile, props, conversionfilter);
    }

    private String createUNOFileURL(String filelocation) {
        File newfile = new File(filelocation);
        URL before = null;
        try {
            before = newfile.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        String myUNOFileURL = "";
        if (before != null) {
            myUNOFileURL = ExternalUriReferenceTranslator.create((XComponentContext)this.xContext).translateToInternal(before.toExternalForm());
        }
        return myUNOFileURL;
    }

    private XComponentContext getContext() {
        XComponentContext context = null;
        try {
            context = OOBootstrap.getCurrentContext(sPipeName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return context;
    }

    private XComponentContext getContext(String hostname, String port) {
        XComponentContext context = null;
        try {
            context = Bootstrap.createInitialComponentContext(null);
            XUnoUrlResolver urlResolver = UnoUrlResolver.create((XComponentContext)context);
            Object initialObject = urlResolver.resolve("uno:socket,host=" + hostname + ",port=" + port + ";urp;StarOffice.ServiceManager");
            XMultiComponentFactory xMCF = (XMultiComponentFactory)UnoRuntime.queryInterface(XMultiComponentFactory.class, (Object)initialObject);
            XPropertySet xProperySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMCF);
            Object oDefaultContext = xProperySet.getPropertyValue("DefaultContext");
            context = (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)oDefaultContext);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return context;
    }

    private boolean isSlideRequired(int slidenumber) {
        for (int c : this.slides) {
            if (c - 1 > this.maxSlide || c - 1 < 0) {
                this.invalidSlide = c;
                throw new InvalidSlideNumberException();
            }
            if (c - 1 != slidenumber) continue;
            return true;
        }
        return false;
    }

    private XComponent deleteSlides(String filename, XComponent xcomponent) {
        try {
            int count;
            XDrawPagesSupplier xDrawPagesSupplier = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)xcomponent);
            XDrawPages xdrawpages = xDrawPagesSupplier.getDrawPages();
            this.maxSlide = count = xdrawpages.getCount();
            ArrayList<XDrawPage> pagestodelete = new ArrayList<XDrawPage>();
            for (int i = 0; i < count; ++i) {
                if (this.isSlideRequired(i)) continue;
                XDrawPage xdrawpage = (XDrawPage)UnoRuntime.queryInterface(XDrawPage.class, (Object)xdrawpages.getByIndex(i));
                pagestodelete.add(xdrawpage);
            }
            for (XDrawPage page : pagestodelete) {
                xdrawpages.remove(page);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new DocumentConversionErrorException(filename, e);
        }
        catch (WrappedTargetException e) {
            throw new DocumentConversionErrorException(filename, e);
        }
        return xcomponent;
    }

    private XComponent openDocument(String source_File, Object desktop) {
        XComponent xComponent = null;
        XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)desktop);
        PropertyValue[] myProperties = new PropertyValue[2];
        myProperties[0] = new PropertyValue();
        myProperties[0].Name = "Hidden";
        myProperties[0].Value = true;
        myProperties[1] = new PropertyValue();
        myProperties[1].Name = "Password";
        myProperties[1].Value = this.openPassword;
        try {
            xComponent = xComponentLoader.loadComponentFromURL(this.createUNOFileURL(source_File), "_blank", 0, myProperties);
        }
        catch (IOException e) {
            throw new DocumentConversionErrorException(source_File, e);
        }
        catch (IllegalArgumentException e) {
            throw new DocumentConversionErrorException(source_File, e);
        }
        if (xComponent == null) {
            throw new DocumentOpenException(source_File);
        }
        return xComponent;
    }

    public void shutdownOpenOffice() {
        try {
            XComponentContext xcontext = OOBootstrap.getContext(sPipeName);
            XMultiComponentFactory xRemoteServiceManager = xcontext.getServiceManager();
            this.terminateApplication("", xRemoteServiceManager);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void convert(final String filename, final String targetFilename, final String conversionfilter) {
        if (System.getSecurityManager() == null) {
            this._convert(filename, targetFilename, conversionfilter);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    OpenOfficeExport.this._convert(filename, targetFilename, conversionfilter);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _convert(String filename, String targetFilename, String conversionfilter) {
        block10: {
            XComponent xComponent = null;
            Object desktop = null;
            XMultiComponentFactory xRemoteServiceManager = null;
            try {
                XStorable xStorable;
                if (this.xContext == null) break block10;
                xRemoteServiceManager = this.xContext.getServiceManager();
                try {
                    desktop = xRemoteServiceManager.createInstanceWithContext("com.sun.star.frame.Desktop", this.xContext);
                }
                catch (com.sun.star.uno.Exception e) {
                    throw new DocumentConversionErrorException(filename, e);
                }
                PropertyValue[] aFilterData = null;
                xComponent = this.openDocument(filename, desktop);
                if (this.slides != null && this.slides.size() > 0) {
                    this.deleteSlides(filename, xComponent);
                }
                if (xComponent == null || (xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)xComponent)) == null) break block10;
                aFilterData = new PropertyValue[this.prop.size()];
                this.prop.toArray(aFilterData);
                PropertyValue[] conversionProperties = new PropertyValue[3];
                conversionProperties[0] = new PropertyValue();
                conversionProperties[0].Name = "Overwrite";
                conversionProperties[0].Value = true;
                conversionProperties[1] = new PropertyValue();
                conversionProperties[1].Name = "FilterName";
                conversionProperties[1].Value = conversionfilter;
                conversionProperties[2] = new PropertyValue();
                conversionProperties[2].Name = "FilterData";
                conversionProperties[2].Value = aFilterData;
                try {
                    xStorable.storeToURL(this.createUNOFileURL(targetFilename), conversionProperties);
                }
                catch (IOException e) {
                    throw new DocumentConversionErrorException(filename, e);
                }
                catch (com.sun.star.uno.Exception e) {
                    throw new DocumentConversionErrorException(filename, e);
                }
            }
            finally {
                if (xComponent != null) {
                    this.closeDocument(xComponent);
                }
            }
        }
    }

    private void closeDocument(XComponent xDocument) {
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xDocument);
        if (xModel != null) {
            XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)xModel);
            if (xCloseable != null) {
                try {
                    xCloseable.close(true);
                }
                catch (CloseVetoException closeVetoException) {}
            } else {
                XComponent xDisposeable = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xModel);
                xDisposeable.dispose();
            }
        }
    }

    private boolean terminateApplication(String filename, XMultiComponentFactory compFactory) {
        boolean isConnected;
        try {
            Object desktop = compFactory.createInstanceWithContext("com.sun.star.frame.Desktop", this.xContext);
            XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)desktop);
            isConnected = !xDesktop.terminate();
            Runtime.getRuntime().gc();
        }
        catch (Exception e) {
            return false;
        }
        return !isConnected;
    }

    public static class InvalidDocumentTypeException
    extends ApplicationException {
        public String name;

        public InvalidDocumentTypeException(String name) {
            this.name = name;
        }
    }

    public static class InvalidSlideNumberException
    extends ApplicationException {
    }

    public static class DocumentConversionErrorException
    extends ApplicationException {
        public String name;

        public DocumentConversionErrorException(String name, Throwable t) {
            super(t);
            this.name = name;
        }
    }

    public static class DocumentOpenException
    extends ApplicationException {
        public String name = null;

        public DocumentOpenException(String name) {
            this.name = name;
        }
    }
}

