/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.definition;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.service.schema.ServiceObjectSchema;
import microsoft.exchange.webservices.data.misc.OutParam;
import microsoft.exchange.webservices.data.property.definition.ExtendedPropertyDefinition;

public abstract class PropertyDefinitionBase {
    protected PropertyDefinitionBase() {
    }

    public static boolean tryLoadFromXml(EwsServiceXmlReader reader, OutParam<PropertyDefinitionBase> propertyDefinition) throws Exception {
        String strLocalName = reader.getLocalName();
        if (strLocalName.equals("FieldURI")) {
            PropertyDefinitionBase p = ServiceObjectSchema.findPropertyDefinition(reader.readAttributeValue("FieldURI"));
            propertyDefinition.setParam((Object)p);
            return true;
        }
        if (strLocalName.equals("IndexedFieldURI")) {
            reader.skipCurrentElement();
            return true;
        }
        if (strLocalName.equals("ExtendedFieldURI")) {
            ExtendedPropertyDefinition p = new ExtendedPropertyDefinition();
            p.loadFromXml(reader);
            propertyDefinition.setParam((Object)p);
            return true;
        }
        return false;
    }

    protected abstract String getXmlElementName();

    protected abstract void writeAttributesToXml(EwsServiceXmlWriter var1) throws ServiceXmlSerializationException;

    public abstract ExchangeVersion getVersion();

    public abstract String getPrintableName();

    public abstract Class<?> getType();

    public void writeToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeStartElement(XmlNamespace.Types, this.getXmlElementName());
        this.writeAttributesToXml(writer);
        writer.writeEndElement();
    }

    public String toString() {
        return this.getPrintableName();
    }
}

