/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex.recurrence.range;

import java.util.Date;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.property.complex.recurrence.pattern.Recurrence;
import microsoft.exchange.webservices.data.property.complex.recurrence.range.RecurrenceRange;

public final class NumberedRecurrenceRange
extends RecurrenceRange {
    private Integer numberOfOccurrences;

    public NumberedRecurrenceRange() {
    }

    public NumberedRecurrenceRange(Date startDate, Integer numberOfOccurrences) {
        super(startDate);
        this.numberOfOccurrences = numberOfOccurrences;
    }

    @Override
    public String getXmlElementName() {
        return "NumberedRecurrence";
    }

    @Override
    public void setupRecurrence(Recurrence recurrence) throws Exception {
        super.setupRecurrence(recurrence);
        recurrence.setNumberOfOccurrences(this.numberOfOccurrences);
    }

    @Override
    public void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        super.writeElementsToXml(writer);
        if (this.numberOfOccurrences != null) {
            writer.writeElementValue(XmlNamespace.Types, "NumberOfOccurrences", this.numberOfOccurrences);
        }
    }

    @Override
    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (super.tryReadElementFromXml(reader)) {
            return true;
        }
        if (reader.getLocalName().equals("NumberOfOccurrences")) {
            this.numberOfOccurrences = reader.readElementValue(Integer.class);
            return true;
        }
        return false;
    }

    public Integer getNumberOfOccurrences() {
        return this.numberOfOccurrences;
    }

    public void setNumberOfOccurrences(Integer value) {
        this.canSetFieldValue(this.numberOfOccurrences, value);
    }
}

