/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.search.SearchFolderTraversal;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceValidationException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import microsoft.exchange.webservices.data.property.complex.FolderIdCollection;
import microsoft.exchange.webservices.data.property.complex.IComplexPropertyChangedDelegate;
import microsoft.exchange.webservices.data.search.filter.SearchFilter;

public final class SearchFolderParameters
extends ComplexProperty
implements IComplexPropertyChangedDelegate {
    private SearchFolderTraversal traversal;
    private FolderIdCollection rootFolderIds = new FolderIdCollection();
    private SearchFilter searchFilter;

    public SearchFolderParameters() {
        this.rootFolderIds.addOnChangeEvent(this);
    }

    public void complexPropertyChanged(ComplexProperty complexProperty) {
        this.propertyChanged(complexProperty);
    }

    private void propertyChanged(ComplexProperty complexProperty) {
        this.changed();
    }

    @Override
    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equalsIgnoreCase("BaseFolderIds")) {
            this.rootFolderIds.internalClear();
            this.rootFolderIds.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("Restriction")) {
            reader.read();
            this.searchFilter = SearchFilter.loadFromXml(reader);
            return true;
        }
        return false;
    }

    @Override
    public void readAttributesFromXml(EwsServiceXmlReader reader) throws Exception {
        this.traversal = reader.readAttributeValue(SearchFolderTraversal.class, "Traversal");
    }

    @Override
    public void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        writer.writeAttributeValue("Traversal", (Object)this.traversal);
    }

    @Override
    public void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        if (this.searchFilter != null) {
            writer.writeStartElement(XmlNamespace.Types, "Restriction");
            this.searchFilter.writeToXml(writer);
            writer.writeEndElement();
        }
        this.rootFolderIds.writeToXml(writer, "BaseFolderIds");
    }

    @Override
    public void validate() throws Exception {
        if (this.rootFolderIds.getCount() == 0) {
            throw new ServiceValidationException("SearchParameters must contain at least one folder id.");
        }
        if (this.searchFilter != null) {
            this.searchFilter.internalValidate();
        }
    }

    public SearchFolderTraversal getTraversal() {
        return this.traversal;
    }

    public void setTraversal(SearchFolderTraversal traversal) {
        if (this.canSetFieldValue(this.traversal, traversal)) {
            this.traversal = traversal;
            this.changed();
        }
    }

    public FolderIdCollection getRootFolderIds() {
        return this.rootFolderIds;
    }

    public SearchFilter getSearchFilter() {
        return this.searchFilter;
    }

    public void setSearchFilter(SearchFilter searchFilter) {
        if (this.searchFilter != null) {
            this.searchFilter.removeChangeEvent(this);
        }
        if (this.canSetFieldValue(this.searchFilter, searchFilter)) {
            this.searchFilter = searchFilter;
            this.changed();
        }
        if (this.searchFilter != null) {
            this.searchFilter.addOnChangeEvent(this);
        }
    }
}

