/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentOutOfRangeException;
import microsoft.exchange.webservices.data.misc.NameResolution;

public final class NameResolutionCollection
implements Iterable<NameResolution> {
    private ExchangeService service;
    private boolean includesAllResolutions;
    private List<NameResolution> items = new ArrayList<NameResolution>();

    public NameResolutionCollection(ExchangeService service) {
        EwsUtilities.ewsAssert(service != null, "NameResolutionSet.ctor", "service is null.");
        this.service = service;
    }

    public void loadFromXml(EwsServiceXmlReader reader) throws Exception {
        reader.readStartElement(XmlNamespace.Messages, "ResolutionSet");
        int totalItemsInView = reader.readAttributeValue(Integer.class, "TotalItemsInView");
        this.includesAllResolutions = reader.readAttributeValue(Boolean.class, "IncludesLastItemInRange");
        for (int i = 0; i < totalItemsInView; ++i) {
            NameResolution nameResolution = new NameResolution(this);
            nameResolution.loadFromXml(reader);
            this.items.add(nameResolution);
        }
        reader.readEndElement(XmlNamespace.Messages, "ResolutionSet");
    }

    protected ExchangeService getSession() {
        return this.service;
    }

    public int getCount() {
        return this.items.size();
    }

    public boolean getIncludesAllResolutions() {
        return this.includesAllResolutions;
    }

    public NameResolution nameResolutionCollection(int index) throws ArgumentOutOfRangeException {
        if (index < 0 || index >= this.getCount()) {
            throw new ArgumentOutOfRangeException("index", "index is out of range.");
        }
        return this.items.get(index);
    }

    @Override
    public Iterator<NameResolution> iterator() {
        return this.items.iterator();
    }
}

