/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.messaging;

import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.request.DisconnectPhoneCallRequest;
import microsoft.exchange.webservices.data.core.request.GetPhoneCallRequest;
import microsoft.exchange.webservices.data.core.request.PlayOnPhoneRequest;
import microsoft.exchange.webservices.data.core.response.GetPhoneCallResponse;
import microsoft.exchange.webservices.data.core.response.PlayOnPhoneResponse;
import microsoft.exchange.webservices.data.messaging.PhoneCall;
import microsoft.exchange.webservices.data.messaging.PhoneCallId;
import microsoft.exchange.webservices.data.property.complex.ItemId;

public final class UnifiedMessaging {
    private ExchangeService service;

    public UnifiedMessaging(ExchangeService service) {
        this.service = service;
    }

    public PhoneCall playOnPhone(ItemId itemId, String dialString) throws Exception {
        EwsUtilities.validateParam(itemId, "itemId");
        EwsUtilities.validateParam(dialString, "dialString");
        PlayOnPhoneRequest request = new PlayOnPhoneRequest(this.service);
        request.setDialString(dialString);
        request.setItemId(itemId);
        PlayOnPhoneResponse serviceResponse = request.execute();
        PhoneCall callInformation = new PhoneCall(this.service, serviceResponse.getPhoneCallId());
        return callInformation;
    }

    protected PhoneCall getPhoneCallInformation(PhoneCallId id) throws Exception {
        GetPhoneCallRequest request = new GetPhoneCallRequest(this.service);
        request.setId(id);
        GetPhoneCallResponse response = request.execute();
        return response.getPhoneCall();
    }

    protected void disconnectPhoneCall(PhoneCallId id) throws Exception {
        DisconnectPhoneCallRequest request = new DisconnectPhoneCallRequest(this.service);
        request.setId(id);
        request.execute();
    }
}

