/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.service.item;

import java.util.Date;
import microsoft.exchange.webservices.data.attribute.Attachable;
import microsoft.exchange.webservices.data.attribute.ServiceObjectDefinition;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.TaskDelegationState;
import microsoft.exchange.webservices.data.core.enumeration.service.ConflictResolutionMode;
import microsoft.exchange.webservices.data.core.enumeration.service.DeleteMode;
import microsoft.exchange.webservices.data.core.enumeration.service.MessageDisposition;
import microsoft.exchange.webservices.data.core.enumeration.service.TaskMode;
import microsoft.exchange.webservices.data.core.enumeration.service.TaskStatus;
import microsoft.exchange.webservices.data.core.enumeration.service.calendar.AffectedTaskOccurrence;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceResponseException;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.core.service.schema.ServiceObjectSchema;
import microsoft.exchange.webservices.data.core.service.schema.TaskSchema;
import microsoft.exchange.webservices.data.property.complex.ItemAttachment;
import microsoft.exchange.webservices.data.property.complex.ItemId;
import microsoft.exchange.webservices.data.property.complex.StringList;
import microsoft.exchange.webservices.data.property.complex.recurrence.pattern.Recurrence;

@Attachable
@ServiceObjectDefinition(xmlElementName="Task")
public class Task
extends Item {
    private static final double PERCENT_MIN = 0.0;
    private static final double PERCENT_MAX = 100.0;

    public Task(ExchangeService service) throws Exception {
        super(service);
    }

    public Task(ItemAttachment parentAttachment) throws Exception {
        super(parentAttachment);
    }

    public static Task bind(ExchangeService service, ItemId id, PropertySet propertySet) throws Exception {
        return service.bindToItem(Task.class, id, propertySet);
    }

    public static Task bind(ExchangeService service, ItemId id) throws Exception {
        return Task.bind(service, id, PropertySet.getFirstClassProperties());
    }

    @Override
    public ServiceObjectSchema getSchema() {
        return TaskSchema.Instance;
    }

    @Override
    public ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    @Override
    public boolean getIsTimeZoneHeaderRequired(boolean isUpdateOperation) {
        return true;
    }

    public void deleteCurrentOccurrence(DeleteMode deleteMode) throws ServiceLocalException, Exception {
        this.internalDelete(deleteMode, null, AffectedTaskOccurrence.SpecifiedOccurrenceOnly);
    }

    public Task updateTask(ConflictResolutionMode conflictResolutionMode) throws ServiceResponseException, Exception {
        return (Task)this.internalUpdate(null, conflictResolutionMode, MessageDisposition.SaveOnly, null);
    }

    public Integer getActualWork() throws ServiceLocalException {
        return (Integer)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.ActualWork);
    }

    public void setActualWork(Integer value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.ActualWork, value);
    }

    public Date getAssignedTime() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.AssignedTime);
    }

    public String getBillingInformation() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.BillingInformation);
    }

    public void setBillingInformation(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.BillingInformation, value);
    }

    public Integer getChangeCount() throws ServiceLocalException {
        return (Integer)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.ChangeCount);
    }

    public StringList getCompanies() throws ServiceLocalException {
        return (StringList)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.Companies);
    }

    public void setCompanies(StringList value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.Companies, value);
    }

    public Date getCompleteDate() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.CompleteDate);
    }

    public void setCompleteDate(Date value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.CompleteDate, value);
    }

    public StringList getContacts() throws ServiceLocalException {
        return (StringList)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.Contacts);
    }

    public void setContacts(StringList value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.Contacts, value);
    }

    public TaskDelegationState getDelegationState() throws ServiceLocalException {
        return (TaskDelegationState)((Object)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.DelegationState));
    }

    public String getDelegator() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.Delegator);
    }

    public Date getDueDate() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.DueDate);
    }

    public void setDueDate(Date value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.DueDate, value);
    }

    public TaskMode getMode() throws ServiceLocalException {
        return (TaskMode)((Object)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.Mode));
    }

    public Boolean getIsComplete() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.IsComplete);
    }

    public Boolean getIsRecurring() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.IsRecurring);
    }

    public Boolean getIsTeamTask() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.IsTeamTask);
    }

    public String getMileage() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.Mileage);
    }

    public void setMileage(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.Mileage, value);
    }

    public String getOwner() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.Owner);
    }

    public Double getPercentComplete() throws ServiceLocalException {
        return (Double)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.PercentComplete);
    }

    @Deprecated
    public void setPercentComplete(String value) throws Exception {
        this.setPercentComplete(Double.valueOf(value));
    }

    public void setPercentComplete(Double value) throws Exception {
        if (value == null || Double.isNaN(value) || value < 0.0 || value > 100.0) {
            throw new IllegalArgumentException(String.format("%s must be between %f and %f", String.valueOf(value), 0.0, 100.0));
        }
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.PercentComplete, value);
    }

    public Recurrence getRecurrence() throws ServiceLocalException {
        return (Recurrence)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.Recurrence);
    }

    public void setRecurrence(Recurrence value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.Recurrence, value);
    }

    public Date getStartDate() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.StartDate);
    }

    public void setStartDate(Date value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.StartDate, value);
    }

    public TaskStatus getStatus() throws ServiceLocalException {
        return (TaskStatus)((Object)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.Status));
    }

    public void setStatus(TaskStatus value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.Status, (Object)value);
    }

    public String getStatusDescription() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.StatusDescription);
    }

    public Integer getTotalWork() throws ServiceLocalException {
        return (Integer)this.getPropertyBag().getObjectFromPropertyDefinition(TaskSchema.TotalWork);
    }

    public void setTotalWork(Integer value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(TaskSchema.TotalWork, value);
    }

    @Override
    protected AffectedTaskOccurrence getDefaultAffectedTaskOccurrences() {
        return AffectedTaskOccurrence.AllOccurrences;
    }
}

