/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.notification.EventType;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceValidationException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.request.HttpWebRequest;
import microsoft.exchange.webservices.data.core.request.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.core.response.SubscribeResponse;
import microsoft.exchange.webservices.data.misc.FolderIdWrapperList;
import microsoft.exchange.webservices.data.notification.SubscriptionBase;

abstract class SubscribeRequest<TSubscription extends SubscriptionBase>
extends MultiResponseServiceRequest<SubscribeResponse<TSubscription>> {
    private FolderIdWrapperList folderIds = new FolderIdWrapperList();
    private List<EventType> eventTypes = new ArrayList<EventType>();
    private String watermark;

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.getFolderIds(), "FolderIds");
        EwsUtilities.validateParamCollection(this.getEventTypes().iterator(), "EventTypes");
        this.getFolderIds().validate(this.getService().getRequestedServerVersion());
        if (this.getEventTypes().contains((Object)EventType.Status)) {
            throw new ServiceValidationException("Status events can't be subscribed to.");
        }
        if (this.getWatermark() != null && !this.getWatermark().isEmpty()) {
            EwsUtilities.validateNonBlankStringParam(this.getWatermark(), "Watermark");
        }
        for (EventType eventType : this.getEventTypes()) {
            EwsUtilities.validateEnumVersionValue(eventType, this.getService().getRequestedServerVersion());
        }
    }

    protected abstract String getSubscriptionXmlElementName();

    @Override
    protected int getExpectedResponseMessageCount() {
        return 1;
    }

    @Override
    public String getXmlElementName() {
        return "Subscribe";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "SubscribeResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "SubscribeResponseMessage";
    }

    protected abstract void internalWriteElementsToXml(EwsServiceXmlWriter var1) throws XMLStreamException, ServiceXmlSerializationException;

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Messages, this.getSubscriptionXmlElementName());
        if (this.getFolderIds().getCount() == 0) {
            writer.writeAttributeValue("SubscribeToAllFolders", true);
        }
        this.getFolderIds().writeToXml(writer, XmlNamespace.Types, "FolderIds");
        writer.writeStartElement(XmlNamespace.Types, "EventTypes");
        for (EventType eventType : this.getEventTypes()) {
            writer.writeElementValue(XmlNamespace.Types, "EventType", (Object)eventType);
        }
        writer.writeEndElement();
        if (this.getWatermark() != null && !this.getWatermark().isEmpty()) {
            writer.writeElementValue(XmlNamespace.Types, "Watermark", this.getWatermark());
        }
        this.internalWriteElementsToXml(writer);
        writer.writeEndElement();
    }

    protected SubscribeRequest(ExchangeService service) throws Exception {
        super(service, ServiceErrorHandling.ThrowOnError);
        this.setFolderIds(new FolderIdWrapperList());
        this.setEventTypes(new ArrayList<EventType>());
    }

    public FolderIdWrapperList getFolderIds() {
        return this.folderIds;
    }

    private void setFolderIds(FolderIdWrapperList value) {
        this.folderIds = value;
    }

    public List<EventType> getEventTypes() {
        return this.eventTypes;
    }

    private void setEventTypes(List<EventType> value) {
        this.eventTypes = value;
    }

    public String getWatermark() {
        return this.watermark;
    }

    public void setWatermark(String watermark) {
        this.watermark = watermark;
    }

    @Override
    protected HttpWebRequest buildEwsHttpWebRequest() throws Exception {
        return super.buildEwsHttpPoolingWebRequest();
    }
}

