/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.request.SimpleServiceRequestBase;
import microsoft.exchange.webservices.data.core.response.FindConversationResponse;
import microsoft.exchange.webservices.data.misc.FolderIdWrapper;
import microsoft.exchange.webservices.data.search.ConversationIndexedItemView;
import microsoft.exchange.webservices.data.search.filter.SearchFilter;

public final class FindConversationRequest
extends SimpleServiceRequestBase<FindConversationResponse> {
    private ConversationIndexedItemView view;
    private SearchFilter.IsEqualTo searchFilter;
    private FolderIdWrapper folderId;

    public FindConversationRequest(ExchangeService service) throws Exception {
        super(service);
    }

    protected ConversationIndexedItemView getIndexedItemView() {
        return this.view;
    }

    public void setIndexedItemView(ConversationIndexedItemView value) {
        this.view = value;
    }

    protected SearchFilter.IsEqualTo getConversationViewFilter() {
        return this.searchFilter;
    }

    public void setConversationViewFilter(SearchFilter.IsEqualTo value) {
        this.searchFilter = value;
    }

    protected FolderIdWrapper getFolderId() {
        return this.folderId;
    }

    public void setFolderId(FolderIdWrapper value) {
        this.folderId = value;
    }

    @Override
    protected void validate() throws ServiceLocalException, Exception {
        super.validate();
        this.view.internalValidate(this);
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        super.writeAttributesToXml(writer);
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.getIndexedItemView().writeToXml(writer);
        if (this.getConversationViewFilter() != null) {
            writer.writeStartElement(XmlNamespace.Messages, "Restriction");
            this.getConversationViewFilter().writeToXml(writer);
            writer.writeEndElement();
        }
        this.getIndexedItemView().writeOrderByToXml(writer);
        writer.writeStartElement(XmlNamespace.Messages, "ParentFolderId");
        this.getFolderId().writeToXml(writer);
        writer.writeEndElement();
    }

    @Override
    protected FindConversationResponse parseResponse(EwsServiceXmlReader reader) throws Exception {
        FindConversationResponse response = new FindConversationResponse();
        response.loadFromXml(reader, "FindConversationResponse");
        return response;
    }

    @Override
    public String getXmlElementName() {
        return "FindConversation";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "FindConversationResponse";
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010_SP1;
    }

    public FindConversationResponse execute() throws ServiceLocalException, Exception {
        FindConversationResponse serviceResponse = (FindConversationResponse)this.internalExecute();
        serviceResponse.throwIfNecessary();
        return serviceResponse;
    }
}

