/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.misc.OutParam;
import microsoft.exchange.webservices.data.security.XmlNodeType;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EwsXmlReader {
    private static final Log LOG = LogFactory.getLog(EwsXmlReader.class);
    private static final int ReadWriteBufferSize = 4096;
    private XMLEventReader xmlReader = null;
    private XMLEvent presentEvent;
    private XMLEvent prevEvent;

    public EwsXmlReader(InputStream stream) throws Exception {
        this.xmlReader = this.initializeXmlReader(stream);
    }

    protected XMLEventReader initializeXmlReader(InputStream stream) throws Exception {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        return inputFactory.createXMLEventReader(stream);
    }

    private static String formatElementName(String namespacePrefix, String localElementName) {
        return EwsXmlReader.isNullOrEmpty(namespacePrefix) ? localElementName : namespacePrefix + ":" + localElementName;
    }

    private void internalReadElement(XmlNamespace xmlNamespace, String localName, XmlNodeType nodeType) throws Exception {
        if (xmlNamespace == XmlNamespace.NotSpecified) {
            this.internalReadElement("", localName, nodeType);
        } else {
            this.read(nodeType);
            if (!this.getLocalName().equals(localName) || !this.getNamespaceUri().equals(EwsUtilities.getNamespaceUri(xmlNamespace))) {
                throw new ServiceXmlDeserializationException(String.format("An element node '%s:%s' of the type %s was expected, but node '%s' of type %s was found.", EwsUtilities.getNamespacePrefix(xmlNamespace), localName, nodeType.toString(), this.getName(), this.getNodeType().toString()));
            }
        }
    }

    private void internalReadElement(String namespacePrefix, String localName, XmlNodeType nodeType) throws Exception {
        this.read(nodeType);
        if (!this.getLocalName().equals(localName) || !this.getNamespacePrefix().equals(namespacePrefix)) {
            throw new ServiceXmlDeserializationException(String.format("An element node '%s:%s' of the type %s was expected, but node '%s' of type %s was found.", namespacePrefix, localName, nodeType.toString(), this.getName(), this.getNodeType().toString()));
        }
    }

    public void read() throws ServiceXmlDeserializationException, XMLStreamException {
        this.read(false);
    }

    private void read(boolean keepWhiteSpace) throws ServiceXmlDeserializationException, XMLStreamException {
        XMLEvent event;
        Characters characters;
        do {
            if (!this.xmlReader.hasNext()) {
                throw new ServiceXmlDeserializationException("Unexpected end of XML document.");
            }
            event = this.xmlReader.nextEvent();
            if (event.getEventType() != 4) break;
            characters = (Characters)event;
        } while (!keepWhiteSpace && (characters.isIgnorableWhiteSpace() || characters.isWhiteSpace()));
        this.prevEvent = this.presentEvent;
        this.presentEvent = event;
    }

    public void read(XmlNodeType nodeType) throws Exception {
        this.read();
        if (!this.getNodeType().equals(nodeType)) {
            throw new ServiceXmlDeserializationException(String.format("The expected XML node type was %s, but the actual type is %s.", nodeType, this.getNodeType()));
        }
    }

    private String readAttributeValue(QName qName) throws Exception {
        if (this.presentEvent.isStartElement()) {
            StartElement startElement = this.presentEvent.asStartElement();
            Attribute attr = startElement.getAttributeByName(qName);
            if (null != attr) {
                return attr.getValue();
            }
            return null;
        }
        String errMsg = String.format("Could not fetch attribute %s", qName.toString());
        throw new Exception(errMsg);
    }

    public String readAttributeValue(XmlNamespace xmlNamespace, String attributeName) throws Exception {
        if (xmlNamespace == XmlNamespace.NotSpecified) {
            return this.readAttributeValue(attributeName);
        }
        QName qName = new QName(EwsUtilities.getNamespaceUri(xmlNamespace), attributeName);
        return this.readAttributeValue(qName);
    }

    public String readAttributeValue(String attributeName) throws Exception {
        QName qName = new QName(attributeName);
        return this.readAttributeValue(qName);
    }

    public <T> T readAttributeValue(Class<T> cls, String attributeName) throws Exception {
        return EwsUtilities.parse(cls, this.readAttributeValue(attributeName));
    }

    public <T> T readNullableAttributeValue(Class<T> cls, String attributeName) throws Exception {
        String attributeValue = this.readAttributeValue(attributeName);
        if (attributeValue == null) {
            return null;
        }
        return EwsUtilities.parse(cls, attributeValue);
    }

    public String readElementValue(String namespacePrefix, String localName) throws Exception {
        if (!this.isStartElement(namespacePrefix, localName)) {
            this.readStartElement(namespacePrefix, localName);
        }
        String value = null;
        if (!this.isEmptyElement()) {
            value = this.readValue();
        }
        return value;
    }

    public String readElementValue(XmlNamespace xmlNamespace, String localName) throws Exception {
        if (!this.isStartElement(xmlNamespace, localName)) {
            this.readStartElement(xmlNamespace, localName);
        }
        String value = null;
        if (!this.isEmptyElement()) {
            value = this.readValue();
        } else {
            this.read();
        }
        return value;
    }

    public String readElementValue() throws Exception {
        this.ensureCurrentNodeIsStartElement();
        return this.readElementValue(this.getNamespacePrefix(), this.getLocalName());
    }

    public <T> T readElementValue(Class<T> cls, XmlNamespace xmlNamespace, String localName) throws Exception {
        if (!this.isStartElement(xmlNamespace, localName)) {
            this.readStartElement(xmlNamespace, localName);
        }
        T value = null;
        if (!this.isEmptyElement()) {
            value = this.readValue(cls);
        }
        return value;
    }

    public <T> T readElementValue(Class<T> cls) throws Exception {
        this.ensureCurrentNodeIsStartElement();
        T value = null;
        if (!this.isEmptyElement()) {
            value = this.readValue(cls);
        }
        return value;
    }

    public String readValue() throws XMLStreamException, ServiceXmlDeserializationException {
        return this.readValue(false);
    }

    public String readValue(boolean keepWhiteSpace) throws XMLStreamException, ServiceXmlDeserializationException {
        if (this.presentEvent.isStartElement()) {
            this.read(keepWhiteSpace);
            if (this.presentEvent.isCharacters()) {
                StringBuilder elementValue = new StringBuilder();
                do {
                    if (this.getNodeType().nodeType == 4) {
                        String charactersData;
                        Characters characters = (Characters)this.presentEvent;
                        if ((keepWhiteSpace || !characters.isIgnorableWhiteSpace() && !characters.isWhiteSpace()) && (charactersData = characters.getData()) != null && !charactersData.isEmpty()) {
                            elementValue.append(charactersData);
                        }
                    }
                    this.read();
                } while (!this.presentEvent.isEndElement());
                return elementValue.toString();
            }
            if (this.presentEvent.isEndElement()) {
                return "";
            }
            throw new ServiceXmlDeserializationException(this.getReadValueErrMsg("Could not find " + XmlNodeType.getString(4)));
        }
        if (this.presentEvent.getEventType() == 4 && this.presentEvent.isCharacters()) {
            String charData = this.presentEvent.asCharacters().getData();
            StringBuilder data = new StringBuilder(charData == null ? "" : charData);
            do {
                String charactersData;
                this.read(keepWhiteSpace);
                if (this.getNodeType().nodeType != 4) continue;
                Characters characters = (Characters)this.presentEvent;
                if (!keepWhiteSpace && (characters.isIgnorableWhiteSpace() || characters.isWhiteSpace()) || (charactersData = characters.getData()) == null || charactersData.isEmpty()) continue;
                data.append(charactersData);
            } while (!this.presentEvent.isEndElement());
            return data.toString();
        }
        throw new ServiceXmlDeserializationException(this.getReadValueErrMsg("Expected is " + XmlNodeType.getString(1)));
    }

    public boolean tryReadValue(OutParam<String> value) throws XMLStreamException, ServiceXmlDeserializationException {
        if (!this.isEmptyElement()) {
            this.read();
            if (this.presentEvent.isCharacters()) {
                value.setParam((Object)this.readValue());
                return true;
            }
            return false;
        }
        return false;
    }

    public <T> T readValue(Class<T> cls) throws Exception {
        return EwsUtilities.parse(cls, this.readValue());
    }

    public byte[] readBase64ElementValue() throws ServiceXmlDeserializationException, XMLStreamException, IOException {
        this.ensureCurrentNodeIsStartElement();
        byte[] buffer = null;
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        buffer = Base64.decodeBase64((String)this.xmlReader.getElementText().toString());
        byteArrayStream.write(buffer);
        return byteArrayStream.toByteArray();
    }

    public void readBase64ElementValue(OutputStream outputStream) throws Exception {
        this.ensureCurrentNodeIsStartElement();
        byte[] buffer = null;
        buffer = Base64.decodeBase64((String)this.xmlReader.getElementText().toString());
        outputStream.write(buffer);
        outputStream.flush();
    }

    public void readStartElement(String namespacePrefix, String localName) throws Exception {
        this.internalReadElement(namespacePrefix, localName, new XmlNodeType(1));
    }

    public void readStartElement(XmlNamespace xmlNamespace, String localName) throws Exception {
        this.internalReadElement(xmlNamespace, localName, new XmlNodeType(1));
    }

    public void readEndElement(String namespacePrefix, String elementName) throws Exception {
        this.internalReadElement(namespacePrefix, elementName, new XmlNodeType(2));
    }

    public void readEndElement(XmlNamespace xmlNamespace, String localName) throws Exception {
        this.internalReadElement(xmlNamespace, localName, new XmlNodeType(2));
    }

    public void readEndElementIfNecessary(XmlNamespace xmlNamespace, String localName) throws Exception {
        if (!(this.isStartElement(xmlNamespace, localName) && this.isEmptyElement() || this.isEndElement(xmlNamespace, localName))) {
            this.readEndElement(xmlNamespace, localName);
        }
    }

    public boolean isStartElement() {
        return this.presentEvent.isStartElement();
    }

    public boolean isStartElement(String namespacePrefix, String localName) {
        boolean isStart = false;
        if (this.presentEvent.isStartElement()) {
            StartElement startElement = this.presentEvent.asStartElement();
            QName qName = startElement.getName();
            isStart = qName.getLocalPart().equals(localName) && qName.getPrefix().equals(namespacePrefix);
        }
        return isStart;
    }

    public boolean isStartElement(XmlNamespace xmlNamespace, String localName) {
        return this.isStartElement() && StringUtils.equals((CharSequence)this.getLocalName(), (CharSequence)localName) && (StringUtils.equals((CharSequence)this.getNamespacePrefix(), (CharSequence)EwsUtilities.getNamespacePrefix(xmlNamespace)) || StringUtils.equals((CharSequence)this.getNamespaceUri(), (CharSequence)EwsUtilities.getNamespaceUri(xmlNamespace)));
    }

    public boolean isEndElement(String namespacePrefix, String localName) {
        boolean isEndElement = false;
        if (this.presentEvent.isEndElement()) {
            EndElement endElement = this.presentEvent.asEndElement();
            QName qName = endElement.getName();
            isEndElement = qName.getLocalPart().equals(localName) && qName.getPrefix().equals(namespacePrefix);
        }
        return isEndElement;
    }

    public boolean isEndElement(XmlNamespace xmlNamespace, String localName) {
        boolean isEndElement = false;
        if (this.presentEvent.isEndElement()) {
            EndElement endElement = this.presentEvent.asEndElement();
            QName qName = endElement.getName();
            isEndElement = qName.getLocalPart().equals(localName) && (qName.getPrefix().equals(EwsUtilities.getNamespacePrefix(xmlNamespace)) || qName.getNamespaceURI().equals(EwsUtilities.getNamespaceUri(xmlNamespace)));
        }
        return isEndElement;
    }

    public void skipElement(String namespacePrefix, String localName) throws Exception {
        if (!this.isEndElement(namespacePrefix, localName)) {
            if (!this.isStartElement(namespacePrefix, localName)) {
                this.readStartElement(namespacePrefix, localName);
            }
            if (!this.isEmptyElement()) {
                do {
                    this.read();
                } while (!this.isEndElement(namespacePrefix, localName));
            }
        }
    }

    public void skipElement(XmlNamespace xmlNamespace, String localName) throws Exception {
        if (!this.isEndElement(xmlNamespace, localName)) {
            if (!this.isStartElement(xmlNamespace, localName)) {
                this.readStartElement(xmlNamespace, localName);
            }
            if (!this.isEmptyElement()) {
                do {
                    this.read();
                } while (!this.isEndElement(xmlNamespace, localName));
            }
        }
    }

    public void skipCurrentElement() throws Exception {
        this.skipElement(this.getNamespacePrefix(), this.getLocalName());
    }

    public void ensureCurrentNodeIsStartElement(XmlNamespace xmlNamespace, String localName) throws ServiceXmlDeserializationException {
        if (!this.isStartElement(xmlNamespace, localName)) {
            throw new ServiceXmlDeserializationException(String.format("The element '%s' in namespace '%s' wasn't found at the current position.", new Object[]{localName, xmlNamespace}));
        }
    }

    public void ensureCurrentNodeIsStartElement() throws ServiceXmlDeserializationException {
        XmlNodeType presentNodeType = new XmlNodeType(this.presentEvent.getEventType());
        if (!this.presentEvent.isStartElement()) {
            throw new ServiceXmlDeserializationException(String.format("The start element was expected, but node '%s' of type %s was found.", this.presentEvent.toString(), presentNodeType.toString()));
        }
    }

    public void ensureCurrentNodeIsEndElement(XmlNamespace xmlNamespace, String localName) throws Exception {
        if (!(this.isEndElement(xmlNamespace, localName) || this.isStartElement(xmlNamespace, localName) && this.isEmptyElement())) {
            throw new ServiceXmlDeserializationException(String.format("The element '%s' in namespace '%s' wasn't found at the current position.", new Object[]{xmlNamespace, localName}));
        }
    }

    public String readOuterXml() throws ServiceXmlDeserializationException, XMLStreamException {
        XMLEvent event;
        if (!this.isStartElement()) {
            throw new ServiceXmlDeserializationException("The current position is not the start of an element.");
        }
        XMLEvent startEvent = this.presentEvent;
        StringBuilder str = new StringBuilder();
        str.append(startEvent);
        do {
            event = this.xmlReader.nextEvent();
            str.append(event);
        } while (!EwsXmlReader.checkEndElement(startEvent, event));
        return str.toString();
    }

    public String readInnerXml() throws ServiceXmlDeserializationException, XMLStreamException {
        XMLEvent event;
        if (!this.isStartElement()) {
            throw new ServiceXmlDeserializationException("The current position is not the start of an element.");
        }
        XMLEvent startEvent = this.presentEvent;
        StringBuilder str = new StringBuilder();
        while (!EwsXmlReader.checkEndElement(startEvent, event = this.xmlReader.nextEvent())) {
            str.append(event);
        }
        return str.toString();
    }

    public static boolean checkEndElement(XMLEvent startEvent, XMLEvent endEvent) {
        boolean isEndElement = false;
        if (endEvent.isEndElement()) {
            QName qEName = endEvent.asEndElement().getName();
            QName qSName = startEvent.asStartElement().getName();
            isEndElement = qEName.getLocalPart().equals(qSName.getLocalPart()) && (qEName.getPrefix().equals(qSName.getPrefix()) || qEName.getNamespaceURI().equals(qSName.getNamespaceURI()));
        }
        return isEndElement;
    }

    public XMLEventReader getXmlReaderForNode() throws FileNotFoundException, ServiceXmlDeserializationException, XMLStreamException {
        return this.readSubtree();
    }

    public XMLEventReader readSubtree() throws XMLStreamException, FileNotFoundException, ServiceXmlDeserializationException {
        XMLEvent startEvent;
        if (!this.isStartElement()) {
            throw new ServiceXmlDeserializationException("The current position is not the start of an element.");
        }
        XMLEventReader eventReader = null;
        ByteArrayInputStream in = null;
        XMLEvent event = startEvent = this.presentEvent;
        StringBuilder str = new StringBuilder();
        str.append(startEvent);
        do {
            event = this.xmlReader.nextEvent();
            str.append(event);
        } while (!EwsXmlReader.checkEndElement(startEvent, event));
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            try {
                in = new ByteArrayInputStream(str.toString().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)e);
            }
            eventReader = inputFactory.createXMLEventReader(in);
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return eventReader;
    }

    public void readToDescendant(XmlNamespace xmlNamespace, String localName) throws XMLStreamException {
        this.readToDescendant(localName, EwsUtilities.getNamespaceUri(xmlNamespace));
    }

    public boolean readToDescendant(String localName, String namespaceURI) throws XMLStreamException {
        if (!this.isStartElement()) {
            return false;
        }
        XMLEvent startEvent = this.presentEvent;
        XMLEvent event = this.presentEvent;
        do {
            QName qEName;
            if (!event.isStartElement() || !(qEName = event.asStartElement().getName()).getLocalPart().equals(localName) || !qEName.getNamespaceURI().equals(namespaceURI)) continue;
            return true;
        } while (!EwsXmlReader.checkEndElement(startEvent, event = this.xmlReader.nextEvent()));
        return false;
    }

    public boolean hasAttributes() {
        if (this.presentEvent.isStartElement()) {
            StartElement startElement = this.presentEvent.asStartElement();
            return startElement.getAttributes().hasNext();
        }
        return false;
    }

    public boolean isEmptyElement() throws XMLStreamException {
        boolean isPresentStartElement = this.presentEvent.isStartElement();
        boolean isNextEndElement = this.xmlReader.peek().isEndElement();
        return isPresentStartElement && isNextEndElement;
    }

    public String getLocalName() {
        String localName = null;
        localName = this.presentEvent.isStartElement() ? this.presentEvent.asStartElement().getName().getLocalPart() : this.presentEvent.asEndElement().getName().getLocalPart();
        return localName;
    }

    protected String getNamespacePrefix() {
        if (this.presentEvent.isStartElement()) {
            return this.presentEvent.asStartElement().getName().getPrefix();
        }
        if (this.presentEvent.isEndElement()) {
            return this.presentEvent.asEndElement().getName().getPrefix();
        }
        return null;
    }

    public String getNamespaceUri() {
        String nameSpaceUri = null;
        nameSpaceUri = this.presentEvent.isStartElement() ? this.presentEvent.asStartElement().getName().getNamespaceURI() : this.presentEvent.asEndElement().getName().getNamespaceURI();
        return nameSpaceUri;
    }

    public XmlNodeType getNodeType() throws XMLStreamException {
        XMLEvent event = this.presentEvent;
        return new XmlNodeType(event.getEventType());
    }

    protected Object getName() {
        String name = null;
        name = this.presentEvent.isStartElement() ? this.presentEvent.asStartElement().getName().toString() : this.presentEvent.asEndElement().getName().toString();
        return name;
    }

    private static boolean isNullOrEmpty(String namespacePrefix) {
        return namespacePrefix == null || namespacePrefix.isEmpty();
    }

    private String getReadValueErrMsg(String details) {
        int eventType = this.presentEvent.getEventType();
        return "Could not read value from " + XmlNodeType.getString(eventType) + "." + details;
    }
}

