/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PrinterResolution;
import org.jpedal.PdfDecoder;
import org.jpedal.PdfDecoderInt;
import org.jpedal.utils.PdfPageFormat;

public class PdfBook
extends Book {
    private MediaSizeName pageSize;
    private boolean chooseSourceByPdfPageSize;
    private final boolean useExactPdfPageSize;
    private final PdfDecoderInt pdfDecoder;
    private final PrintService printingDevice;

    public PdfBook(PdfDecoderInt pdfDecoder, PrintService printingDevice, PrintRequestAttributeSet attributes) {
        Attribute res;
        if (printingDevice.isAttributeCategorySupported(PrinterResolution.class) && (res = attributes.get(PrinterResolution.class)) == null) {
            Attribute defaultRes = (Attribute)printingDevice.getDefaultAttributeValue(PrinterResolution.class);
            if (defaultRes == null) {
                PdfBook.setResolutionClosestTo(printingDevice, attributes);
            } else {
                attributes.add(defaultRes);
            }
        }
        ((PdfDecoder)pdfDecoder).swingPrinter.legacyPrintMode = false;
        this.pdfDecoder = pdfDecoder;
        this.printingDevice = printingDevice;
        boolean pageSizeSet = false;
        if (attributes != null) {
            Attribute[] aa = attributes.toArray();
            for (int i = 0; i < aa.length; ++i) {
                if (!(aa[i] instanceof MediaSizeName)) continue;
                this.pageSize = (MediaSizeName)aa[i];
                if (!printingDevice.isAttributeValueSupported(this.pageSize, new DocFlavor.BYTE_ARRAY(DocFlavor.BYTE_ARRAY.PNG.getMimeType()), attributes)) continue;
                pageSizeSet = true;
                i = aa.length;
            }
        }
        if (!pageSizeSet) {
            this.pageSize = PdfPageFormat.getDefaultMediaSizeName(printingDevice);
        }
        this.chooseSourceByPdfPageSize = false;
        this.useExactPdfPageSize = false;
        ((PdfDecoder)pdfDecoder).setUsePDFPaperSize(false);
        for (int i = 0; i < pdfDecoder.getPageCount(); ++i) {
            if (((PdfDecoder)pdfDecoder).getUserSetPageFormat(i) == null) {
                this.append((Printable)((Object)pdfDecoder), PdfPageFormat.createPdfPageFormat(this.pageSize, printingDevice));
                continue;
            }
            this.append((Printable)((Object)pdfDecoder), ((PdfDecoder)pdfDecoder).getUserSetPageFormat(i));
        }
    }

    private static void setResolutionClosestTo(PrintService printingDevice, AttributeSet attributes) {
        PrinterResolution[] supportedRes = (PrinterResolution[])printingDevice.getSupportedAttributeValues(PrinterResolution.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (supportedRes != null && supportedRes.length > 0) {
            int crossRes = 300;
            int feedRes = 300;
            PrinterResolution closestToRes = supportedRes[0];
            int closestToFeed = Math.abs(supportedRes[0].getFeedResolution(100) - 300);
            int closestToCross = Math.abs(supportedRes[0].getCrossFeedResolution(100) - 300);
            for (int i = 1; i < supportedRes.length; ++i) {
                int feed = Math.abs(supportedRes[i].getFeedResolution(100) - 300);
                int cross = Math.abs(supportedRes[i].getCrossFeedResolution(100) - 300);
                if (feed >= closestToFeed || cross >= closestToCross) continue;
                closestToRes = supportedRes[i];
                closestToFeed = feed;
                closestToCross = cross;
            }
            attributes.add(closestToRes);
        }
    }

    public void setChooseSourceByPdfPageSize(boolean b) {
        ((PdfDecoder)this.pdfDecoder).setUsePDFPaperSize(b);
        this.chooseSourceByPdfPageSize = b;
        this.updatePages();
    }

    private void updatePages() {
        for (int i = 0; i < this.pdfDecoder.getPageCount(); ++i) {
            PageFormat pf;
            if (this.chooseSourceByPdfPageSize) {
                pf = PdfPageFormat.getPageFormat(i + 1, this.pdfDecoder);
            } else if (this.useExactPdfPageSize) {
                Paper paper = new Paper();
                pf = new PageFormat();
                int w = this.pdfDecoder.getPdfPageData().getCropBoxWidth(i);
                int h = this.pdfDecoder.getPdfPageData().getCropBoxHeight(i);
                paper.setSize(w, h);
                paper.setImageableArea(0.0, 0.0, w, h);
                pf.setPaper(paper);
            } else {
                pf = ((PdfDecoder)this.pdfDecoder).getUserSetPageFormat(i) == null ? PdfPageFormat.createPdfPageFormat(this.pageSize, this.printingDevice) : ((PdfDecoder)this.pdfDecoder).getUserSetPageFormat(i);
            }
            this.setPage(i, (Printable)((Object)this.pdfDecoder), pf);
        }
    }
}

