/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.external.ErrorTracker;
import org.jpedal.io.IDObjectDecoder;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfFilteredReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.XObject;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.parser.image.ImageCommands;
import org.jpedal.parser.image.ImageDecoder;
import org.jpedal.parser.image.data.ImageData;

public class ID
extends ImageDecoder {
    public ID(int imageCount, PdfObjectReader currentPdfFile, ErrorTracker errorTracker, ObjectStore objectStoreStreamRef, PdfImageData pdfImages, PdfPageData pageData, String imagesInFile) {
        super(imageCount, currentPdfFile, errorTracker, objectStoreStreamRef, pdfImages, pageData, imagesInFile);
    }

    @Override
    public int processImage(int dataPointer, int startInlineStream, byte[] stream, int tokenNumber) throws Exception {
        PdfObject XObject2 = ID.convertDataToObject(dataPointer, startInlineStream, stream, this.currentPdfFile.getObjectReader());
        boolean inline_imageMask = XObject2.getBoolean(1516403337);
        int inline_start_pointer = dataPointer + 1;
        int i_w = XObject2.getInt(959726687);
        int i_h = XObject2.getInt(959926393);
        int i_bpc = XObject2.getInt(-1344207655);
        int i_length = XObject2.getInt(1043816557);
        int i = i_length != -1 ? inline_start_pointer + i_length : ID.getEndOfImageData(inline_start_pointer, stream);
        if (this.parserOptions.imagesNeeded()) {
            BufferedImage image;
            String image_name = this.parserOptions.getFileName() + "-IN-" + tokenNumber;
            byte[] i_data = new PdfFilteredReader().decodeFilters(ObjectUtils.setupDecodeParms(XObject2, this.currentPdfFile.getObjectReader()), ID.setImageData(i, stream, inline_start_pointer, XObject2), XObject2.getMixedArray(1011108731), i_w, i_h, null, XObject2);
            GenericColorSpace decodeColorData = ID.setColorSpace(XObject2, this.currentPdfFile, this.cache);
            this.cache.put(1, decodeColorData.getID(), (Object)"x");
            if (i_data != null && (image = this.convertDataToImage(i_w, i_h, i_bpc, i_data, decodeColorData, inline_imageMask, XObject2, image_name)) != null) {
                this.renderImage(image, image_name);
            }
        }
        dataPointer = i + 3;
        return dataPointer;
    }

    private void renderImage(BufferedImage image, String image_name) {
        if (this.current.isHTMLorSVG()) {
            this.current.drawImage(this.parserOptions.getPageNumber(), image, this.gs, false, image_name, -2);
        } else {
            this.gs.x = this.gs.CTM[2][0];
            this.gs.y = this.gs.CTM[2][1];
            this.current.drawImage(this.parserOptions.getPageNumber(), image, this.gs, false, image_name, -1);
        }
        if (image != null) {
            image.flush();
        }
    }

    private BufferedImage convertDataToImage(int i_w, int i_h, int i_bpc, byte[] i_data, GenericColorSpace decodeColorData, boolean inline_imageMask, PdfObject XObject2, String image_name) {
        ImageData imageData = new ImageData(XObject2, 0);
        imageData.setWidth(i_w);
        imageData.setHeight(i_h);
        imageData.setDepth(i_bpc);
        imageData.setObjectData(i_data);
        imageData.setCompCount(decodeColorData.getColorSpace().getNumComponents());
        imageData.setImageSource(6420);
        BufferedImage image = this.processImage(decodeColorData, imageData, inline_imageMask, XObject2);
        if (inline_imageMask && !ImageDecoder.allowPrintTransparency && this.parserOptions.isPrinting() && image != null && imageData.getDepth() == 1) {
            image = this.setupMask(image);
        }
        this.currentImage = image_name;
        return image;
    }

    private static GenericColorSpace setColorSpace(PdfObject XObject2, PdfObjectReader currentPdfFile, PdfObjectCache cache) {
        GenericColorSpace decodeColorData = new DeviceRGBColorSpace();
        PdfArrayIterator ColorSpace2 = XObject2.getMixedArray(2087749783);
        if (ColorSpace2.getTokenCount() > 0) {
            Object col;
            String colKey = ColorSpace2.getNextValueAsString(false);
            if (colKey != null && (col = cache.get(2, colKey.substring(1))) != null) {
                ColorSpace2 = ColorspaceFactory.convertColValueToMixedArray(currentPdfFile, (byte[])col);
            }
            decodeColorData = ColorspaceFactory.getColorSpaceInstance(currentPdfFile, ColorSpace2);
        }
        return decodeColorData;
    }

    private static PdfObject convertDataToObject(int dataPointer, int startInlineStream, byte[] stream, PdfFileReader pdfFileReader) {
        XObject XObject2 = new XObject(6420);
        IDObjectDecoder objectDecoder = new IDObjectDecoder(pdfFileReader);
        objectDecoder.setEndPt(dataPointer - 2);
        objectDecoder.readDictionaryAsObject(XObject2, startInlineStream, stream);
        return XObject2;
    }

    private BufferedImage setupMask(BufferedImage image) {
        byte[] maskCol = ImageCommands.getMaskColor(this.gs);
        if (maskCol[0] == 0 && maskCol[1] == 0 && maskCol[2] == 0 && maskCol[3] == 0) {
            int iw = image.getWidth();
            int ih = image.getHeight();
            BufferedImage newImage = new BufferedImage(iw, ih, 10);
            newImage.getGraphics().setColor(Color.WHITE);
            newImage.getGraphics().fillRect(0, 0, iw, ih);
            newImage.getGraphics().drawImage(image, 0, 0, null);
            image = newImage;
        }
        return image;
    }

    private static byte[] setImageData(int i, byte[] stream, int inline_start_pointer, PdfObject XObject2) {
        int endPtr = i;
        if (i < stream.length && stream[endPtr] != 32 && stream[endPtr] != 10 && stream[endPtr] != 13) {
            ++endPtr;
        }
        if (stream[inline_start_pointer - 1] == 13 && stream[inline_start_pointer] == 10) {
            ++inline_start_pointer;
        }
        byte[] i_data = new byte[endPtr - inline_start_pointer];
        System.arraycopy(stream, inline_start_pointer, i_data, 0, endPtr - inline_start_pointer);
        XObject2.setStream(i_data);
        return i_data;
    }

    private static int getEndOfImageData(int i, byte[] stream) {
        int streamLength = stream.length;
        while ((streamLength - i <= 3 || stream[i + 1] != 69 || stream[i + 2] != 73 || (stream[i + 3] != 10 || streamLength != i + 4 && stream[i + 4] != 81) && (stream[i + 3] != 32 || streamLength != i + 4 && stream[i + 4] != 10)) && (streamLength - i <= 3 || stream[i + 1] != 69 || stream[i + 2] != 73 || stream[i + 3] != 32 || stream[i + 4] != 32) && (streamLength - i <= 3 || stream[i] != 32 && stream[i] != 10 && stream[i] != 13 && (stream[i + 3] != 32 || stream[i + 4] != 81) || stream[i + 1] != 69 || stream[i + 2] != 73 || stream[i + 3] != 32 && stream[i + 3] != 10 && stream[i + 3] != 13) && ++i != streamLength) {
        }
        return i;
    }
}

