/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Color;
import java.awt.Paint;
import java.util.Map;
import org.jpedal.constants.JPedalSettings;
import org.jpedal.display.PageOffsets;
import org.jpedal.exception.PdfException;
import org.jpedal.external.JPedalHelper;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.parser.PDFtoImageConvertor;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.text.Tj;
import org.jpedal.render.SwingDisplay;
import org.jpedal.utils.LogWriter;

public class DecoderOptions {
    public static float javaVersion;
    public static float highlightComposite;
    public static boolean showMouseBox;
    public static boolean showErrorMessages;
    public static boolean isRunningOnMac;
    public static boolean isRunningOnWindows;
    public static boolean isRunningOnAIX;
    public static boolean isRunningOnLinux;
    public static boolean embedWidthData;
    public static JPedalHelper Helper;
    private int scrollInterval = 10;
    private int alignment = 1;
    private int insetW;
    private int insetH;
    private boolean useAcceleration = true;
    private PageOffsets currentOffset;
    private boolean renderPage;
    private int pageMode = 1;
    public static Color highlightColor;
    public static Color backgroundColor;
    private Color nonDrawnPageColor = Color.WHITE;
    private int displayView = 1;
    private Color altPageColor = Color.WHITE;
    private Color altTextColor;
    private Color altDisplayBackground;
    private int altColorThreshold = 255;
    private boolean enhanceFractionalLines = true;
    private boolean useSoftclipForShapes;
    private boolean useSoftclipForImages;
    private boolean useSmoothImages = true;
    private boolean useConvolution;
    private boolean highlightFormFields;
    private boolean useOffScreenRendering;
    private Color formHighlightColor = new Color(0.1607f, 0.4784f, 0.8f, 0.2f);
    private boolean changeTextAndLine;
    private Integer instance_bestQualityMaxScaling;
    private int[] instance_formsNoPrint;
    private static int[] formsNoPrint;
    private static String[] extactionPageSize;
    private String[] instance_extactionPageSize;
    private static Boolean overridePageSize;
    private Boolean instance_overridePageSize;
    private Boolean useIntPageSize;
    private Boolean instance_allowPagesSmallerThanPageSize = Boolean.FALSE;
    private boolean isXMLExtraction = true;

    public boolean isXMLExtraction() {
        return this.isXMLExtraction;
    }

    public void setXMLExtraction(boolean XMLExtraction) {
        this.isXMLExtraction = XMLExtraction;
    }

    public void setPageMode(int mode) {
        this.pageMode = mode;
    }

    public int getPageMode() {
        return this.pageMode;
    }

    public int getInsetH() {
        return this.insetH;
    }

    public int getInsetW() {
        return this.insetW;
    }

    public int getScrollInterval() {
        return this.scrollInterval;
    }

    public void setScrollInterval(int scrollInterval) {
        this.scrollInterval = scrollInterval;
    }

    public final void setInset(int width, int height) {
        this.insetW = width;
        this.insetH = height;
    }

    public void useXMLExtraction() {
        this.isXMLExtraction = true;
    }

    public PdfGroupingAlgorithms getGroupingObject(int lastPageDecoded, PdfData textData) {
        if (lastPageDecoded == -1) {
            throw new RuntimeException("No pages decoded - call decodePage(pageNumber) first");
        }
        if (textData == null) {
            return null;
        }
        return new PdfGroupingAlgorithms(textData, this.isXMLExtraction);
    }

    public PdfGroupingAlgorithms getBackgroundGroupingObject(PdfData pdfBackgroundData) {
        if (pdfBackgroundData == null) {
            return null;
        }
        return new PdfGroupingAlgorithms(pdfBackgroundData, this.isXMLExtraction);
    }

    public void set(Map<Integer, Object> values) throws PdfException {
        for (Integer nextKey : values.keySet()) {
            Object rawValue = values.get(nextKey);
            if (nextKey.equals(JPedalSettings.UNDRAWN_PAGE_COLOR)) {
                if (rawValue instanceof Integer) {
                    this.nonDrawnPageColor = new Color((Integer)rawValue);
                    continue;
                }
                throw new PdfException("JPedalSettings.UNDRAWN_PAGE_COLOR expects a Integer value");
            }
            if (nextKey.equals(JPedalSettings.PAGE_COLOR)) {
                if (rawValue == null) {
                    this.altPageColor = Color.WHITE;
                    continue;
                }
                if (rawValue instanceof Integer) {
                    this.altPageColor = new Color((Integer)rawValue);
                    continue;
                }
                throw new PdfException("JPedalSettings.PAGE_COLOR expects a Integer value");
            }
            if (nextKey.equals(JPedalSettings.USE_INT_PAGE_SIZE_FOR_SCALING)) {
                if (rawValue instanceof Boolean) {
                    this.useIntPageSize = (Boolean)rawValue;
                    continue;
                }
                throw new PdfException("JPedalSettings.USE_INT_PAGE_SIZE expects a Boolean value");
            }
            if (nextKey.equals(JPedalSettings.TEXT_COLOR)) {
                if (rawValue == null) {
                    this.altTextColor = null;
                    continue;
                }
                if (rawValue instanceof Integer) {
                    this.altTextColor = new Color((Integer)rawValue);
                    continue;
                }
                throw new PdfException("JPedalSettings.TEXT_COLOR expects a Integer value");
            }
            if (nextKey.equals(JPedalSettings.REPLACEMENT_COLOR_THRESHOLD)) {
                if (rawValue instanceof Integer) {
                    this.altColorThreshold = (Integer)rawValue;
                    continue;
                }
                throw new PdfException("JPedalSettings.TEXT_COLOR expects a Integer value");
            }
            if (nextKey.equals(JPedalSettings.DISPLAY_BACKGROUND)) {
                if (rawValue instanceof Integer) {
                    this.altDisplayBackground = new Color((Integer)rawValue);
                    continue;
                }
                throw new PdfException("JPedalSettings.TEXT_COLOR expects a Integer value");
            }
            if (nextKey.equals(JPedalSettings.CHANGE_LINEART)) {
                if (rawValue instanceof Boolean) {
                    this.changeTextAndLine = (Boolean)rawValue;
                    continue;
                }
                throw new PdfException("JPedalSettings.CHANGE_LINEART expects a Boolean value");
            }
            if (nextKey.equals(JPedalSettings.EXTRACT_AT_BEST_QUALITY_MAXSCALING)) {
                if (rawValue instanceof Integer) {
                    this.instance_bestQualityMaxScaling = (Integer)rawValue;
                    continue;
                }
                throw new PdfException("JPedalSettings.EXTRACT_AT_BEST_QUALITY_MAXSCALING expects a Integer value");
            }
            if (nextKey.equals(JPedalSettings.EXTRACT_AT_PAGE_SIZE)) {
                if (rawValue instanceof String[]) {
                    this.instance_extactionPageSize = (String[])rawValue;
                    continue;
                }
                throw new PdfException("JPedalSettings.EXTRACT_AT_PAGE_SIZE expects a String[] value");
            }
            if (nextKey.equals(JPedalSettings.IGNORE_FORMS_ON_PRINT)) {
                if (rawValue instanceof int[]) {
                    this.instance_formsNoPrint = (int[])rawValue;
                    continue;
                }
                throw new PdfException("JPedalSettings.IGNORE_FORMS_ON_PRINT expects a int[] value");
            }
            if (nextKey.equals(JPedalSettings.PAGE_SIZE_OVERRIDES_IMAGE)) {
                if (rawValue instanceof Boolean) {
                    this.instance_overridePageSize = (Boolean)rawValue;
                    continue;
                }
                throw new PdfException("JPedalSettings.EXTRACT_AT_PAGE_SIZE expects a Boolean value");
            }
            if (nextKey.equals(JPedalSettings.ALLOW_PAGES_SMALLER_THAN_PAGE_SIZE)) {
                if (rawValue instanceof Boolean) {
                    this.instance_allowPagesSmallerThanPageSize = (Boolean)rawValue;
                    continue;
                }
                throw new PdfException("JPedalSettings.ALLOW_PAGES_SMALLER_THAN_PAGE_SIZE expects a Boolean value");
            }
            if (nextKey.equals(JPedalSettings.ENHANCE_FRACTIONAL_LINES)) {
                if (rawValue instanceof Boolean) {
                    this.enhanceFractionalLines = (Boolean)rawValue;
                    continue;
                }
                throw new PdfException("JPedalSettings.ENHANCE_FRACTIONAL_LINES expects a Boolean value");
            }
            if (nextKey.equals(JPedalSettings.USE_SOFTCLIP_FOR_SHAPES)) {
                if (rawValue instanceof Boolean) {
                    this.useSoftclipForShapes = (Boolean)rawValue;
                    continue;
                }
                throw new PdfException("JPedalSettings.USE_SOFTCLIP_FOR_SHAPES expects a Boolean value");
            }
            if (nextKey.equals(JPedalSettings.USE_SOFTCLIP_FOR_IMAGES)) {
                if (rawValue instanceof Boolean) {
                    this.useSoftclipForImages = (Boolean)rawValue;
                    continue;
                }
                throw new PdfException("JPedalSettings.USE_SOFTCLIP_FOR_SHAPES expects a Boolean value");
            }
            if (nextKey.equals(JPedalSettings.SMOOTH_IMAGES)) {
                if (rawValue instanceof Boolean) {
                    this.useSmoothImages = (Boolean)rawValue;
                    continue;
                }
                throw new PdfException("JPedalSettings.USE_SOFTCLIP_FOR_SHAPES expects a Boolean value");
            }
            if (nextKey.equals(JPedalSettings.USE_CONVOLUTION)) {
                if (rawValue instanceof Boolean) {
                    this.useConvolution = (Boolean)rawValue;
                    continue;
                }
                throw new PdfException("JPedalSettings.USE_CONVOLUTION expects a Boolean value");
            }
            if (nextKey.equals(JPedalSettings.HIGHLIGHT_FORM_FIELDS)) {
                if (rawValue instanceof Boolean) {
                    this.highlightFormFields = (Boolean)rawValue;
                    continue;
                }
                throw new PdfException("JPedalSettings.HIGHLIGHT_FORM_FIELDS expects a Boolean value");
            }
            if (nextKey.equals(JPedalSettings.HIGHLIGHT_FORM_FIELDS_COLOR)) {
                if (rawValue instanceof Integer) {
                    this.formHighlightColor = new Color((Integer)rawValue, true);
                    continue;
                }
                throw new PdfException("JPedalSettings.HIGHLIGHT_FORM_FIELDS_COLOR expects an Integer value");
            }
            if (nextKey.equals(JPedalSettings.OFF_SCREEN_RENDERING)) {
                if (rawValue instanceof Boolean) {
                    this.useOffScreenRendering = (Boolean)rawValue;
                    continue;
                }
                throw new PdfException("JPedalSettings.OFF_SCREEN_RENDERING expects a Boolean value");
            }
            DecoderOptions.setParameter(values, nextKey);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setParameter(Map<Integer, Object> values, Integer nextKey) throws PdfException {
        Object rawValue = values.get(nextKey);
        if (nextKey.equals(JPedalSettings.INVERT_HIGHLIGHT)) {
            if (!(rawValue instanceof Boolean)) throw new PdfException("JPedalSettings.INVERT_HIGHLIGHT expects an Boolean value");
            SwingDisplay.invertHighlight = (Boolean)rawValue;
            return;
        } else if (nextKey.equals(JPedalSettings.TEXT_INVERTED_COLOUR)) {
            if (!(rawValue instanceof Color)) throw new PdfException("JPedalSettings.TEXT_INVERTED_COLOUR expects a Color value");
            backgroundColor = (Color)rawValue;
            return;
        } else if (nextKey.equals(JPedalSettings.TEXT_HIGHLIGHT_COLOUR)) {
            if (!(rawValue instanceof Color)) throw new PdfException("JPedalSettings.TEXT_HIGHLIGHT_COLOUR expects a Color value");
            highlightColor = (Color)rawValue;
            return;
        } else if (nextKey.equals(JPedalSettings.TEXT_PRINT_NON_EMBEDDED_FONTS)) {
            if (!(rawValue instanceof Boolean)) throw new PdfException("JPedalSettings.TEXT_PRINT_NON_EMBEDDED_FONTS expects a Boolean value");
            PdfStreamDecoder.useTextPrintingForNonEmbeddedFonts = (Boolean)rawValue;
            return;
        } else if (nextKey.equals(JPedalSettings.DISPLAY_INVISIBLE_TEXT)) {
            if (!(rawValue instanceof Boolean)) throw new PdfException("JPedalSettings.DISPLAY_INVISIBLE_TEXT expects a Boolean value");
            Tj.showInvisibleText = (Boolean)rawValue;
            return;
        } else if (nextKey.equals(JPedalSettings.CACHE_LARGE_FONTS)) {
            if (!(rawValue instanceof Integer)) throw new PdfException("JPedalSettings.CACHE_LARGE_FONTS expects an Integer value");
            FontData.maxSizeAllowedInMemory = (Integer)rawValue;
            return;
        } else if (nextKey.equals(JPedalSettings.EXTRACT_AT_BEST_QUALITY_MAXSCALING)) {
            if (!(rawValue instanceof Integer)) throw new PdfException("JPedalSettings.EXTRACT_AT_BEST_QUALITY_MAXSCALING expects a Integer value");
            PDFtoImageConvertor.bestQualityMaxScaling = (Integer)rawValue;
            return;
        } else if (nextKey.equals(JPedalSettings.EXTRACT_AT_PAGE_SIZE)) {
            if (!(rawValue instanceof String[])) throw new PdfException("JPedalSettings.EXTRACT_AT_PAGE_SIZE expects a String[] value");
            extactionPageSize = (String[])rawValue;
            return;
        } else if (nextKey.equals(JPedalSettings.PAGE_SIZE_OVERRIDES_IMAGE)) {
            if (!(rawValue instanceof Boolean)) throw new PdfException("JPedalSettings.EXTRACT_AT_PAGE_SIZE expects a Boolean value");
            overridePageSize = (Boolean)rawValue;
            return;
        } else if (nextKey.equals(JPedalSettings.IGNORE_FORMS_ON_PRINT)) {
            if (!(rawValue instanceof int[])) throw new PdfException("JPedalSettings.IGNORE_FORMS_ON_PRINT expects a int[] value");
            formsNoPrint = (int[])rawValue;
            return;
        } else {
            if (!nextKey.equals(JPedalSettings.ALLOW_PAGES_SMALLER_THAN_PAGE_SIZE)) throw new PdfException("Unknown or unsupported key " + nextKey);
            if (!(rawValue instanceof Boolean)) throw new PdfException("JPedalSettings.ALLOW_PAGES_SMALLER_THAN_PAGE_SIZE expects a Boolean value");
            PDFtoImageConvertor.allowPagesSmallerThanPageSize = (Boolean)rawValue;
        }
    }

    public static void modifyJPedalParameters(Map<Integer, Object> values) throws PdfException {
        for (Integer nextKey : values.keySet()) {
            DecoderOptions.setParameter(values, nextKey);
        }
    }

    public Color getPageColor() {
        return this.altPageColor;
    }

    public Color getTextColor() {
        return this.altTextColor;
    }

    public int getReplacementColorThreshold() {
        return this.altColorThreshold;
    }

    public boolean isEnhanceFractionalLines() {
        return this.enhanceFractionalLines;
    }

    public boolean isUseSoftclipForShapes() {
        return this.useSoftclipForShapes;
    }

    public boolean isUseSoftclipForImages() {
        return this.useSoftclipForImages;
    }

    public boolean isUseSmoothImages() {
        return this.useSmoothImages;
    }

    public boolean isUseConvolution() {
        return this.useConvolution;
    }

    public boolean isHighlightFormFields() {
        return this.highlightFormFields;
    }

    public Color getFormFieldsHighlightColor() {
        return this.formHighlightColor;
    }

    public boolean isUseOffScreenRendering() {
        return this.useOffScreenRendering;
    }

    public Color getDisplayBackgroundColor() {
        return this.altDisplayBackground;
    }

    public boolean getChangeTextAndLine() {
        return this.changeTextAndLine;
    }

    public Paint getNonDrawnPageColor() {
        return this.nonDrawnPageColor;
    }

    public Boolean getInstance_allowPagesSmallerThanPageSize() {
        return this.instance_allowPagesSmallerThanPageSize;
    }

    public Integer getInstance_bestQualityMaxScaling() {
        return this.instance_bestQualityMaxScaling;
    }

    public static int[] getFormsNoPrint() {
        return formsNoPrint;
    }

    public int[] getInstance_FormsNoPrint() {
        return this.instance_formsNoPrint;
    }

    private Boolean getPageSizeToUse() {
        Boolean overridePageSizeToUse = Boolean.FALSE;
        if (this.instance_overridePageSize != null) {
            overridePageSizeToUse = this.instance_overridePageSize;
        } else if (overridePageSize != null) {
            overridePageSizeToUse = overridePageSize;
        }
        return overridePageSizeToUse;
    }

    public float getImageDimensions(int pageIndex, PdfPageData pageData) {
        float crh;
        float crw;
        String maxScalingJVM;
        float multiplyer = -2.0f;
        String overridePageSizeJVM = System.getProperty("org.jpedal.pageSizeOverridesImage");
        if (overridePageSizeJVM != null) {
            if (this.instance_overridePageSize != null) {
                this.instance_overridePageSize = Boolean.parseBoolean(overridePageSizeJVM);
            } else {
                overridePageSize = Boolean.parseBoolean(overridePageSizeJVM);
            }
        }
        if ((maxScalingJVM = System.getProperty("org.jpedal.pageMaxScaling")) != null) {
            try {
                if (this.instance_bestQualityMaxScaling != null) {
                    this.instance_bestQualityMaxScaling = Integer.parseInt(maxScalingJVM);
                } else {
                    PDFtoImageConvertor.bestQualityMaxScaling = Integer.parseInt(maxScalingJVM);
                }
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        String[] dims = null;
        String dimsJVM = System.getProperty("org.jpedal.pageSize");
        if (dimsJVM != null) {
            dims = dimsJVM.split("x");
        }
        if (dims == null) {
            dims = this.instance_extactionPageSize != null ? this.instance_extactionPageSize : extactionPageSize;
        }
        float prefWidth = 0.0f;
        float prefHeight = 0.0f;
        if (dims != null && dims.length != 0) {
            if (dims.length == 2) {
                if (pageData.getRotation(pageIndex) == 90 || pageData.getRotation(pageIndex) == 270) {
                    prefWidth = Float.parseFloat(dims[1]);
                    prefHeight = Float.parseFloat(dims[0]);
                } else {
                    prefWidth = Float.parseFloat(dims[0]);
                    prefHeight = Float.parseFloat(dims[1]);
                }
            } else {
                throw new RuntimeException("Invalid parameters in JVM option -DpageSize ");
            }
        }
        if (this.useIntPageSize != null && this.useIntPageSize.booleanValue()) {
            crw = pageData.getCropBoxWidth(pageIndex);
            crh = pageData.getCropBoxHeight(pageIndex);
        } else {
            crw = pageData.getCropBoxWidth2D(pageIndex);
            crh = pageData.getCropBoxHeight2D(pageIndex);
        }
        float dScaleW = prefWidth / crw;
        float dScaleH = prefHeight / crh;
        if (dScaleH < dScaleW) {
            dScaleW = dScaleH;
        }
        Boolean overridePageSizeToUse = this.getPageSizeToUse();
        if (dims != null && overridePageSizeToUse.booleanValue()) {
            multiplyer = dScaleW;
        }
        return multiplyer;
    }

    public boolean getRenderPage() {
        return this.renderPage;
    }

    public void setRenderPage(boolean newRender) {
        this.renderPage = newRender;
    }

    public boolean useHardwareAcceleration() {
        return this.useAcceleration;
    }

    public void useHardwareAcceleration(boolean newValue) {
        this.useAcceleration = newValue;
    }

    public int getPageAlignment() {
        return this.alignment;
    }

    public void setPageAlignment(int orientation) {
        this.alignment = orientation;
    }

    public void setDisplayView(int displayView) {
        this.displayView = displayView;
    }

    public int getDisplayView() {
        return this.displayView;
    }

    public PageOffsets getCurrentOffsets() {
        return this.currentOffset;
    }

    public void setCurrentOffsets(PageOffsets newOffset) {
        this.currentOffset = newOffset;
    }

    static {
        highlightComposite = 0.35f;
        try {
            String name = System.getProperty("os.name");
            if ("Mac OS X".equals(name)) {
                isRunningOnMac = true;
            } else if (name.startsWith("Windows")) {
                isRunningOnWindows = true;
            } else if (name.startsWith("AIX")) {
                isRunningOnAIX = true;
            } else if ("Linux".equals(name)) {
                isRunningOnLinux = true;
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        highlightColor = new Color(10, 100, 170);
    }
}

