/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw.xfa;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import org.jpedal.objects.raw.FormAppearanceObject;

final class RadioButtonAP {
    private static final float[] patternDashed = new float[]{20.0f, 4.0f};
    private static final float[] patternDotted = new float[]{10.0f, 4.0f};
    private static final float[] patternDashDot = new float[]{20.0f, 4.0f, 10.0f, 4.0f};
    private static final float[] patternDashDotDot = new float[]{20.0f, 4.0f, 10.0f, 4.0f, 10.0f, 4.0f};
    private static final float[] patternSolid = new float[]{1.0f, 0.0f};
    private static final Color acrobatColor = new Color(255, 255, 255);

    private RadioButtonAP() {
    }

    static void draw(BufferedImage image, FormAppearanceObject XObject2) {
        int stroke = XObject2.getBorderStroke();
        switch (stroke) {
            case 0: {
                break;
            }
            case 1: {
                RadioButtonAP.drawRadios(image, XObject2, patternDashed);
                break;
            }
            case 2: {
                RadioButtonAP.drawRadios(image, XObject2, patternDotted);
                break;
            }
            case 3: {
                RadioButtonAP.drawRadios(image, XObject2, patternDashDot);
                break;
            }
            case 4: {
                RadioButtonAP.drawRadios(image, XObject2, patternDashDotDot);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                RadioButtonAP.drawRadioLowered(image, XObject2);
                break;
            }
            default: {
                RadioButtonAP.drawRadios(image, XObject2, patternSolid);
            }
        }
    }

    private static void drawRadioLowered(BufferedImage image, FormAppearanceObject XObject2) {
        int height = image.getHeight();
        int width = image.getWidth();
        Graphics2D g2 = image.createGraphics();
        g2.setTransform(AffineTransform.getScaleInstance((float)width / 80.0f, (float)height / 80.0f));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(new Color(215, 215, 219));
        g2.setStroke(new BasicStroke(2.0f));
        g2.drawOval(2, 2, width + 24, height + 24);
        g2.setColor(acrobatColor);
        g2.fill(new Ellipse2D.Double(10.0, 10.0, 51.0, 51.0));
        g2.setColor(new Color(117, 117, 118));
        g2.draw(new Arc2D.Double(8.0, 8.0, 54.0, 54.0, 45.0, 180.0, 0));
        g2.setColor(new Color(119, 122, 131));
        g2.draw(new Arc2D.Double(8.0, 8.0, 54.0, 54.0, 50.0, 170.0, 0));
        g2.setColor(new Color(243, 246, 255));
        g2.draw(new Ellipse2D.Double(4.0, 4.0, 61.5, 61.5));
        g2.setColor(new Color(222, 223, 226));
        g2.draw(new Arc2D.Double(5.0, 5.0, 60.5, 60.5, 44.0, 181.0, 0));
        g2.setColor(new Color(161, 163, 172));
        g2.draw(new Arc2D.Double(5.0, 5.0, 60.5, 60.5, 49.0, 171.0, 0));
        g2.setColor(new Color(226, 226, 226));
        g2.draw(new Arc2D.Double(4.0, 4.0, 62.0, 62.0, 44.0, 182.0, 0));
        g2.setColor(new Color(172, 172, 172));
        g2.draw(new Arc2D.Double(4.0, 4.0, 62.0, 62.0, 49.0, 172.0, 0));
        if (XObject2.isSelected) {
            g2.setColor(Color.BLACK);
        } else {
            g2.setColor(acrobatColor);
        }
        g2.fill(new Ellipse2D.Double(22.0, 21.0, 28.0, 28.0));
    }

    private static void drawRadios(BufferedImage image, FormAppearanceObject XObject2, float[] dashPattern) {
        int height = image.getHeight();
        int width = image.getWidth();
        Graphics2D g2 = image.createGraphics();
        g2.setTransform(AffineTransform.getScaleInstance((float)width / 80.0f, (float)height / 80.0f));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(3.0f));
        g2.setColor(acrobatColor);
        g2.fill(new Ellipse2D.Double(5.0, 4.0, 62.0, 62.0));
        g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
        g2.setStroke(new BasicStroke(6.0f, 0, 0, 10.0f, dashPattern, 0.0f));
        g2.setColor(new Color(30, 30, 30));
        g2.draw(new Ellipse2D.Double(5.0, 4.0, 62.0, 62.0));
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        if (XObject2.isSelected) {
            g2.setColor(Color.BLACK);
        } else {
            g2.setColor(acrobatColor);
        }
        g2.fill(new Ellipse2D.Double(22.0, 21.0, 28.0, 28.0));
    }
}

