/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import java.awt.Shape;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFileReader;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.StringUtils;

public class PdfObject {
    private boolean isFullyResolved = true;
    private boolean isDataExternal;
    private boolean streamMayBeCorrupt;
    private Shape clip;
    private byte[] convertedData;
    public static final int DECODED = 0;
    public static final int UNDECODED_REF = 1;
    public static final int UNDECODED_DIRECT = 2;
    private int status;
    private byte[] unresolvedData;
    int pageNumber = -1;
    private int PDFkeyInt = -1;
    int objType = -1;
    private int id = -1;
    private int colorspace = -1;
    private int subtype = -1;
    private int type = -1;
    private int BitsPerComponent = -1;
    private int BitsPerCoordinate = -1;
    private int BitsPerFlag = -1;
    private int Count;
    private int FormType = -1;
    private int Length = -1;
    private int Length1 = -1;
    private int Length2 = -1;
    private int Length3 = -1;
    private int Rotate = -1;
    private int verticesPerRow = -1;
    private float[] ArtBox;
    private float[] BBox;
    private float[] BleedBox;
    private float[] CropBox;
    private float[] Decode;
    private float[] Domain;
    private float[] Matrix;
    private float[] Matte;
    private float[] MediaBox;
    private float[] Range;
    private float[] TrimBox;
    private PdfObject Collection;
    private PdfObject ColorSpace;
    private PdfObject DecodeParms;
    PdfObject Encoding;
    private PdfObject Function;
    private PdfObject Params;
    private PdfObject Resources;
    private PdfObject Shading;
    private PdfObject SMask;
    private boolean ignoreRecursion;
    private boolean ignoreStream;
    boolean isZapfDingbats;
    boolean isSymbol;
    private boolean isCompressedStream;
    int generalType = -1;
    private String generalTypeAsString;
    boolean includeParent;
    private String Creator;
    private String Parent;
    private String Name;
    private String S;
    private String Title;
    private byte[] rawCreator;
    private byte[] rawParent;
    private byte[] rawName;
    private byte[] rawS;
    private byte[] rawTitle;
    String ref;
    private int intRef;
    private int gen;
    boolean hasStream;
    public byte[] stream;
    private byte[] DecodedStream;
    private long startStreamOnDisk = -1L;
    private PdfFileReader objReader;
    private String cacheName;
    private byte[][] ColorSpaceArray;
    private byte[][] ExtGStateArray;
    private byte[][] Filter;
    private byte[][] FontArray;
    private byte[][] FunctionArray;
    private byte[][] Nums;
    private byte[][] PatternArray;
    private byte[][] ShadingArray;
    private byte[][] TR;
    private byte[][] XObjectArray;
    private byte[][] keys;
    private byte[][] values;
    private Object[] DecodeParmsAsArray;
    int parentType = -1;
    private boolean isInCompressedStream;
    private final Map<Integer, String> refs = new HashMap<Integer, String>();

    PdfObject() {
    }

    public PdfObject(int intRef, int gen) {
        this.setRef(intRef, gen);
    }

    private void setRef(int intRef, int gen) {
        this.intRef = intRef;
        this.gen = gen;
        this.ref = null;
    }

    public String getCacheName(PdfFileReader objReader) {
        if (this.isCached()) {
            this.cacheName = null;
            this.getCachedStreamFile(objReader);
        }
        return this.cacheName;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public PdfObject(String ref) {
        this.ref = ref;
    }

    PdfObject(int type) {
        this.generalType = type;
    }

    static boolean[] deepCopy(boolean[] input) {
        if (input == null) {
            return null;
        }
        int count = input.length;
        boolean[] deepCopy = new boolean[count];
        System.arraycopy(input, 0, deepCopy, 0, count);
        return deepCopy;
    }

    public int getStatus() {
        return this.status;
    }

    public byte[] getUnresolvedData() {
        return this.unresolvedData;
    }

    public int getPDFkeyInt() {
        return this.PDFkeyInt;
    }

    public void setUnresolvedData(byte[] unresolvedData, int PDFkeyInt) {
        this.unresolvedData = unresolvedData;
        this.PDFkeyInt = PDFkeyInt;
    }

    public void setStatus(int status) {
        this.status = status;
        this.unresolvedData = null;
    }

    static float[] deepCopy(float[] input) {
        if (input == null) {
            return null;
        }
        int count = input.length;
        float[] deepCopy = new float[count];
        System.arraycopy(input, 0, deepCopy, 0, count);
        return deepCopy;
    }

    static double[] deepCopy(double[] input) {
        if (input == null) {
            return null;
        }
        int count = input.length;
        double[] deepCopy = new double[count];
        System.arraycopy(input, 0, deepCopy, 0, count);
        return deepCopy;
    }

    static int[] deepCopy(int[] input) {
        if (input == null) {
            return null;
        }
        int count = input.length;
        int[] deepCopy = new int[count];
        System.arraycopy(input, 0, deepCopy, 0, count);
        return deepCopy;
    }

    static byte[][] deepCopy(byte[][] input) {
        if (input == null) {
            return null;
        }
        int count = input.length;
        byte[][] deepCopy = new byte[count][];
        System.arraycopy(input, 0, deepCopy, 0, count);
        return deepCopy;
    }

    public PdfObject getDictionary(int id) {
        switch (id) {
            case -2139781200: {
                return this.Collection;
            }
            case 2087749783: {
                return this.ColorSpace;
            }
            case 1888135062: {
                return this.DecodeParms;
            }
            case 1518239089: {
                return this.Function;
            }
            case 1110531444: {
                return this.Params;
            }
            case 2004251818: {
                return this.Resources;
            }
            case 878474856: {
                return this.Shading;
            }
            case 489767774: {
                return this.SMask;
            }
        }
        return null;
    }

    public int getGeneralType(int id) {
        if (id == 1232564598 && this.isZapfDingbats) {
            return 5;
        }
        if (id == 1232564598 && this.isSymbol) {
            return 4;
        }
        if (id == 608780341) {
            return this.objType;
        }
        return this.generalType;
    }

    public String getGeneralStringValue() {
        return this.generalTypeAsString;
    }

    public void setGeneralStringValue(String generalTypeAsString) {
        this.generalTypeAsString = generalTypeAsString;
    }

    public void setIntNumber(int id, int value) {
        switch (id) {
            case -1344207655: {
                this.BitsPerComponent = value;
                break;
            }
            case -335950113: {
                this.BitsPerCoordinate = value;
                break;
            }
            case 1500422077: {
                this.BitsPerFlag = value;
                break;
            }
            case 1061502502: {
                this.Count = value;
                break;
            }
            case 982024818: {
                this.FormType = value;
                break;
            }
            case 1043816557: {
                this.Length = value;
                break;
            }
            case 929066303: {
                this.Length1 = value;
                break;
            }
            case 929066304: {
                this.Length2 = value;
                break;
            }
            case 929066305: {
                this.Length3 = value;
                break;
            }
            case 1144088180: {
                this.Rotate = value;
                break;
            }
            case -1180057884: {
                this.verticesPerRow = value;
            }
        }
    }

    public void setFloatNumber(int id, float value) {
    }

    public int getInt(int id) {
        switch (id) {
            case -1344207655: {
                return this.BitsPerComponent;
            }
            case -335950113: {
                return this.BitsPerCoordinate;
            }
            case 1500422077: {
                return this.BitsPerFlag;
            }
            case 1061502502: {
                return this.Count;
            }
            case 982024818: {
                return this.FormType;
            }
            case 1043816557: {
                return this.Length;
            }
            case 929066303: {
                return this.Length1;
            }
            case 929066304: {
                return this.Length2;
            }
            case 929066305: {
                return this.Length3;
            }
            case 1144088180: {
                return this.Rotate;
            }
            case -1180057884: {
                return this.verticesPerRow;
            }
        }
        return -1;
    }

    public float getFloatNumber(int id) {
        return -1.0f;
    }

    public boolean getBoolean(int id) {
        return false;
    }

    public void setBoolean(int id, boolean value) {
    }

    public void setDictionary(int id, PdfObject value) {
        if (value != null) {
            value.id = id;
        }
        switch (id) {
            case -2139781200: {
                this.Collection = value;
                break;
            }
            case 2087749783: {
                this.ColorSpace = value;
                break;
            }
            case 1888135062: {
                this.DecodeParms = value;
                break;
            }
            case 1518239089: {
                this.Function = value;
                break;
            }
            case 1110531444: {
                this.Params = value;
                break;
            }
            case 2004251818: {
                this.Resources = value;
                break;
            }
            case 878474856: {
                this.Shading = value;
                break;
            }
            case 489767774: {
                this.SMask = value;
            }
        }
    }

    public void setID(int id) {
        this.id = id;
    }

    public int getID() {
        return this.id;
    }

    public int getParentID() {
        return this.parentType;
    }

    public boolean hasStream() {
        return this.hasStream;
    }

    public int getParameterConstant(int key) {
        int def = -1;
        switch (key) {
            case 2087749783: {
                return this.colorspace;
            }
            case 1147962727: {
                return this.subtype;
            }
            case 608780341: {
                return this.type;
            }
        }
        return -1;
    }

    public int setConstant(int pdfKeyType, int keyStart, int keyLength, byte[] raw) {
        int id = PdfObject.getId(keyStart, keyLength, raw);
        return this.setConstant(pdfKeyType, id);
    }

    static int getId(int keyStart, int keyLength, byte[] raw) {
        int id = 0;
        int x = 0;
        for (int i2 = keyLength - 1; i2 > -1; --i2) {
            int next = raw[keyStart + i2];
            id += (next -= 48) << x;
            x += 8;
        }
        return id;
    }

    public int setConstant(int pdfKeyType, int id) {
        int PDFvalue = id;
        if (id == -1044665361) {
            PDFvalue = 373243460;
        }
        switch (pdfKeyType) {
            case 2087749783: {
                this.colorspace = PDFvalue;
                break;
            }
            case 1147962727: {
                this.subtype = PDFvalue;
                break;
            }
            case 608780341: {
                this.type = PDFvalue;
            }
        }
        return PDFvalue;
    }

    public float[] getFloatArray(int id) {
        switch (id) {
            case 1142050954: {
                return PdfObject.deepCopy(this.ArtBox);
            }
            case 303185736: {
                return PdfObject.deepCopy(this.BBox);
            }
            case 1179546749: {
                return PdfObject.deepCopy(this.BleedBox);
            }
            case 1076199815: {
                return PdfObject.deepCopy(this.CropBox);
            }
            case 859785322: {
                return PdfObject.deepCopy(this.Decode);
            }
            case 1026641277: {
                return PdfObject.deepCopy(this.Domain);
            }
            case 1145198201: {
                return PdfObject.deepCopy(this.Matrix);
            }
            case 826557522: {
                return PdfObject.deepCopy(this.Matte);
            }
            case 1313305473: {
                return PdfObject.deepCopy(this.MediaBox);
            }
            case 826160983: {
                return PdfObject.deepCopy(this.Range);
            }
            case 1026982273: {
                return PdfObject.deepCopy(this.TrimBox);
            }
        }
        return null;
    }

    public byte[][] getKeyArray(int id) {
        return null;
    }

    public double[] getDoubleArray(int id) {
        return null;
    }

    public boolean[] getBooleanArray(int id) {
        return null;
    }

    public int[] getIntArray(int id) {
        return null;
    }

    public void setFloatArray(int id, float[] value) {
        switch (id) {
            case 1142050954: {
                this.ArtBox = value;
                break;
            }
            case 303185736: {
                this.BBox = value;
                break;
            }
            case 1179546749: {
                this.BleedBox = value;
                break;
            }
            case 1076199815: {
                this.CropBox = value;
                break;
            }
            case 859785322: {
                this.Decode = PdfObject.ignoreIdentity(value);
                break;
            }
            case 1026641277: {
                this.Domain = value;
                break;
            }
            case 1145198201: {
                this.Matrix = value;
                break;
            }
            case 826557522: {
                this.Matte = value;
                break;
            }
            case 1313305473: {
                this.MediaBox = value;
                break;
            }
            case 826160983: {
                this.Range = value;
                break;
            }
            case 1026982273: {
                this.TrimBox = value;
            }
        }
    }

    private static float[] ignoreIdentity(float[] value) {
        boolean isIdentity = true;
        if (value != null) {
            int count = value.length;
            for (int aa = 0; aa < count; aa += 2) {
                if (value[aa] == 0.0f && value[aa + 1] == 1.0f) continue;
                isIdentity = false;
                aa = count;
            }
        }
        if (isIdentity) {
            return null;
        }
        return value;
    }

    public void setIntArray(int id, int[] value) {
    }

    public void setBooleanArray(int id, boolean[] value) {
    }

    public void setDoubleArray(int id, double[] value) {
    }

    public void setMixedArray(int id, byte[][] value) {
        switch (id) {
            case 2087749783: {
                this.ColorSpaceArray = value;
                break;
            }
            case -1938465939: {
                this.ExtGStateArray = value;
                break;
            }
            case 1011108731: {
                this.Filter = value;
                break;
            }
            case 373243460: {
                this.FontArray = value;
                break;
            }
            case 1518239089: {
                this.FunctionArray = value;
                break;
            }
            case 507854147: {
                this.Nums = value;
                break;
            }
            case 1146450818: {
                this.PatternArray = value;
                break;
            }
            case 878474856: {
                this.ShadingArray = value;
                break;
            }
            case 979194486: {
                this.XObjectArray = value;
            }
        }
    }

    public String getStringValue(int id, int mode) {
        return null;
    }

    public int getNameAsConstant(int id) {
        if (id == 35) {
            if (this.rawS != null) {
                return PdfDictionary.generateChecksum(0, this.rawS.length, this.rawS);
            }
            return -1;
        }
        return -1;
    }

    public String getName(int id) {
        switch (id) {
            case 506543413: {
                if (this.Name == null && this.rawName != null) {
                    this.Name = new String(this.rawName);
                }
                return this.Name;
            }
            case 35: {
                if (this.S == null && this.rawS != null) {
                    this.S = new String(this.rawS);
                }
                return this.S;
            }
        }
        return null;
    }

    public String getStringKey(int id) {
        if (id == 1110793845) {
            if (this.Parent == null && this.rawParent != null) {
                this.Parent = new String(this.rawParent);
            }
            return this.Parent;
        }
        return null;
    }

    public String getTextStreamValue(int id) {
        switch (id) {
            case 827818359: {
                if (this.Creator == null && this.rawCreator != null) {
                    this.Creator = StringUtils.getTextString(this.rawCreator, false);
                }
                return this.Creator;
            }
            case 506543413: {
                if (this.Name == null && this.rawName != null) {
                    this.Name = StringUtils.getTextString(this.rawName, false);
                }
                return this.Name;
            }
            case 960773209: {
                if (this.Title == null && this.rawTitle != null) {
                    this.Title = StringUtils.getTextString(this.rawTitle, false);
                }
                return this.Title;
            }
        }
        return null;
    }

    public void setName(int id, byte[] value) {
        switch (id) {
            case 506543413: {
                this.rawName = value;
                this.Name = null;
                break;
            }
            case 35: {
                this.rawS = value;
                break;
            }
            case 1110793845: {
                if (!this.includeParent) break;
                this.rawParent = value;
            }
        }
    }

    public void setStringKey(int id, byte[] value) {
        if (id == 1110793845) {
            this.rawParent = value;
        }
    }

    public void setTextStreamValue(int id, byte[] value) {
        switch (id) {
            case 827818359: {
                this.rawCreator = value;
                break;
            }
            case 506543413: {
                this.rawName = value;
                this.Name = null;
                break;
            }
            case 960773209: {
                this.rawTitle = value;
            }
        }
    }

    public byte[] getPassword() {
        if (this.objReader == null) {
            return null;
        }
        return this.objReader.getEncHash();
    }

    public byte[] getDecodedStream() {
        if (this.isCached()) {
            byte[] cached = null;
            try {
                cached = ObjectStore.readFromFile(this.getCachedStreamFile(this.objReader), this.objReader.getEncHash());
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
            return cached;
        }
        return this.DecodedStream;
    }

    public void setStream(byte[] stream) {
        this.stream = stream;
        if (this.getObjectType() == 2087749783) {
            this.hasStream = true;
        }
    }

    public void setDecodedStream(byte[] stream) {
        this.DecodedStream = stream;
    }

    public String getObjectRefAsString() {
        if (this.ref == null) {
            this.ref = this.intRef + " " + this.gen + " R";
        }
        return this.ref;
    }

    public int getObjectRefID() {
        if (this.intRef == 0 && this.ref != null && !this.ref.contains("[")) {
            try {
                byte[] data = this.ref.getBytes();
                int j = 0;
                while (data[j] == 91 || data[j] == 32 || data[j] == 13 || data[j] == 10) {
                    ++j;
                }
                int keyStart = j;
                while (data[j] != 10 && data[j] != 13 && data[j] != 32 && data[j] != 47 && data[j] != 60 && data[j] != 62) {
                    ++j;
                }
                this.intRef = NumberUtils.parseInt(keyStart, j, data);
                while (data[j] == 10 || data[j] == 13 || data[j] == 32) {
                    ++j;
                }
                keyStart = j;
                while (data[j] != 10 && data[j] != 13 && data[j] != 32 && data[j] != 47 && data[j] != 60 && data[j] != 62) {
                    ++j;
                }
                this.gen = NumberUtils.parseInt(keyStart, j, data);
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return this.intRef;
    }

    public int getObjectRefGeneration() {
        return this.gen;
    }

    public PdfArrayIterator getMixedArray(int id) {
        switch (id) {
            case 2087749783: {
                return new PdfArrayIterator(this.ColorSpaceArray);
            }
            case -1938465939: {
                return new PdfArrayIterator(this.ExtGStateArray);
            }
            case 373243460: {
                return new PdfArrayIterator(this.FontArray);
            }
            case 1011108731: {
                return new PdfArrayIterator(this.Filter);
            }
            case 1518239089: {
                return new PdfArrayIterator(this.FunctionArray);
            }
            case 507854147: {
                return new PdfArrayIterator(this.Nums);
            }
            case 1146450818: {
                return new PdfArrayIterator(this.PatternArray);
            }
            case 878474856: {
                return new PdfArrayIterator(this.ShadingArray);
            }
            case 979194486: {
                return new PdfArrayIterator(this.XObjectArray);
            }
        }
        return null;
    }

    public void setDictionaryPairs(byte[][] keys, byte[][] values) {
        this.keys = keys;
        this.values = values;
    }

    public PdfKeyPairsIterator getKeyPairsIterator() {
        return new PdfKeyPairsIterator(this.keys, this.values);
    }

    public void setKeyArray(int id, byte[][] keyValues) {
    }

    public void setStringArray(int id, byte[][] keyValues) {
        if (id == 9250) {
            this.TR = keyValues;
        }
    }

    public byte[][] getStringArray(int id) {
        if (id == 9250) {
            return PdfObject.deepCopy(this.TR);
        }
        return null;
    }

    public Object[] getObjectArray(int id) {
        if (id == 1888135062) {
            return this.DecodeParmsAsArray;
        }
        return null;
    }

    public void setObjectArray(int id, Object[] objectValues) {
        if (id == 1888135062) {
            this.DecodeParmsAsArray = objectValues;
        }
    }

    PdfObject duplicate() {
        return new PdfObject();
    }

    public boolean decompressStreamWhenRead() {
        return false;
    }

    public int getObjectType() {
        return this.objType;
    }

    public int getRawObjectType() {
        return this.objType;
    }

    public boolean isCompressedStream() {
        return this.isCompressedStream;
    }

    public void setCompressedStream(boolean isCompressedStream) {
        this.isCompressedStream = isCompressedStream;
    }

    public boolean ignoreRecursion() {
        return this.ignoreRecursion;
    }

    public void ignoreRecursion(boolean ignoreRecursion) {
        this.ignoreRecursion = ignoreRecursion;
    }

    public byte[] getTextStreamValueAsByte(int id) {
        return null;
    }

    public byte[][] getByteArray(int id) {
        return null;
    }

    void setTextStreamValue(int id2, String value) {
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int number) {
        this.pageNumber = number;
    }

    public void setCache(PdfFileReader objReader) {
        this.startStreamOnDisk = objReader.getOffset(this.getObjectRefID());
        this.objReader = objReader;
    }

    public boolean isCached() {
        return this.startStreamOnDisk != -1L;
    }

    public String getCachedStreamFile(PdfFileReader objReader) {
        if (this.startStreamOnDisk != -1L) {
            try {
                File tmpFile = File.createTempFile("jpedal-", ".bin", new File(ObjectStore.temp_dir));
                int length = this.getInt(1043816557);
                if (length == -1) {
                    objReader.spoolStreamDataToDisk(tmpFile, this.startStreamOnDisk);
                } else {
                    objReader.spoolStreamDataToDisk(tmpFile, this.startStreamOnDisk, length);
                }
                this.cacheName = tmpFile.getAbsolutePath();
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        if (this.getObjectType() != 979194486) {
            objReader.readStream(this, true, true, false, this.getObjectType() == 1365674082, this.isCompressedStream, this.cacheName);
        }
        return this.cacheName;
    }

    public void setInCompressedStream(boolean isInCompressedStream) {
        this.isInCompressedStream = isInCompressedStream;
    }

    public boolean isInCompressedStream() {
        return this.isInCompressedStream;
    }

    public boolean isFullyResolved() {
        return this.isFullyResolved;
    }

    public void setFullyResolved(boolean isFullyResolved) {
        this.isFullyResolved = isFullyResolved;
    }

    public boolean isDataExternal() {
        return this.isDataExternal;
    }

    public void isDataExternal(boolean isDataExternal) {
        this.isDataExternal = isDataExternal;
    }

    public boolean ignoreStream() {
        return this.ignoreStream;
    }

    public void ignoreStream(boolean ignoreStream) {
        this.ignoreStream = ignoreStream;
    }

    public void setStreamMayBeCorrupt(boolean streamMayBeCorrupt) {
        this.streamMayBeCorrupt = streamMayBeCorrupt;
    }

    public boolean streamMayBeCorrupt() {
        return this.streamMayBeCorrupt;
    }

    public void moveCacheValues(PdfObject pdfObject, PdfFileReader objReader) {
        this.startStreamOnDisk = objReader.getOffset(this.getObjectRefID());
        this.objReader = objReader;
        this.cacheName = pdfObject.cacheName;
        pdfObject.cacheName = null;
        pdfObject.startStreamOnDisk = -1L;
    }

    public void setClip(Shape clip) {
        this.clip = clip;
    }

    public Shape getClip() {
        return this.clip;
    }

    public byte[] getConvertedData() {
        return this.convertedData;
    }

    public void setConvertedData(byte[] convertedData) {
        this.convertedData = convertedData;
    }

    public String getArrayRef(int key) {
        return this.refs.get(key);
    }

    public void setArrayRef(int key, String ref) {
        this.refs.put(key, ref);
    }
}

