/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.javascript.functions;

import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.objects.acroforms.utils.ConvertToString;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;

public class JSFunction {
    private final AcroRenderer acro;
    final FormObject formObject;
    public static final int AFDate = 1;
    public static final int AFNumber = 2;
    public static final int AFPercent = 3;
    public static final int AFRange = 4;
    public static final int AFSimple = 5;
    public static final int AFSpecial = 6;
    public static final int AFTime = 7;
    static final int AVG = 1;
    static final int SUM = 2;
    static final int PRD = 3;
    static final int MIN = 4;
    static final int MAX = 5;
    public static final int UNKNOWN = -1;
    public static final int KEYSTROKE = 1;
    public static final int VALIDATE = 2;
    public static final int FORMAT = 3;
    public static final int CALCULATE = 4;
    boolean DECIMAL_IS_COMMA;
    String value;
    private static int staticGapformat = -1;
    private static int staticDecimalcount = -1;

    public static void setValidDataFormat(int gapFormat, int decCount) {
        staticDecimalcount = decCount;
        staticGapformat = gapFormat;
    }

    static int getStaticGapFormat() {
        return staticGapformat;
    }

    static int getStaticDecimalCount() {
        return staticDecimalcount;
    }

    JSFunction(AcroRenderer acro, FormObject formObject) {
        this.acro = acro;
        this.formObject = formObject;
    }

    public static void debug(String str) {
        if (LogWriter.isRunningFromIDE) {
            System.out.println("[javascript] " + str);
            ConvertToString.printStackTrace(2);
            if (str.startsWith("Unknown")) {
                throw new RuntimeException("Exception");
            }
        }
    }

    static String applyRegexp(String text, String[] patterns) {
        String matchedString = "";
        int patternCount = patterns.length;
        for (int i = 0; i < patternCount; ++i) {
            Pattern pa = Pattern.compile(patterns[i]);
            Matcher m = pa.matcher(text);
            if (!m.matches()) continue;
            i = patternCount;
            int start = m.start();
            int end = m.end();
            matchedString = text.substring(start, end);
        }
        return matchedString;
    }

    String processArray(String nextValue, int operation) {
        float result = 0.0f;
        boolean resultNotSet = true;
        boolean hasDec = false;
        boolean hasData = false;
        String[] args2 = JSFunction.convertToArray(nextValue);
        float arrayCount = args2.length;
        int ii = 1;
        while ((float)ii < arrayCount) {
            String val = JSFunction.getValue(args2[ii], this.acro);
            hasData = true;
            boolean isNegative = val.startsWith("-");
            if (this.DECIMAL_IS_COMMA) {
                val = val.replaceAll("\\.", "");
                val = val.replaceAll(",", ".");
            } else {
                val = val.indexOf(44) != -1 && !val.contains(".") ? val.replace(',', '.') : val.replaceAll(",", "");
            }
            if (val.indexOf(46) != -1) {
                hasDec = true;
            }
            float nextVal = isNegative ? -Float.parseFloat(val.substring(1)) : Float.parseFloat(val);
            switch (operation) {
                case 1: 
                case 2: {
                    result += nextVal;
                    break;
                }
                case 3: {
                    if (resultNotSet) {
                        result = 1.0f;
                        resultNotSet = false;
                    }
                    result *= nextVal;
                    break;
                }
                case 4: {
                    if (ii == 1) {
                        result = nextVal;
                        break;
                    }
                    if (!(nextVal < result)) break;
                    result = nextVal;
                    break;
                }
                case 5: {
                    if (ii == 1) {
                        result = nextVal;
                        break;
                    }
                    if (!(nextVal > result)) break;
                    result = nextVal;
                    break;
                }
                default: {
                    JSFunction.debug("Unsupported op " + operation + " in processArray");
                }
            }
            ++ii;
        }
        if (operation == 1) {
            result /= arrayCount - 1.0f;
        }
        if (hasDec) {
            return String.valueOf(result);
        }
        if (!hasData) {
            return "";
        }
        return String.valueOf((int)result);
    }

    private static String getValue(String s, AcroRenderer acro) {
        String val = null;
        String strippedValue = s.replaceAll("\"", "");
        Object[] os = acro.getFormComponents(strippedValue, ReturnValues.FORMOBJECTS_FROM_NAME, -1);
        if (os.length > 0) {
            FormObject o = (FormObject)os[0];
            val = o.getValue();
        }
        if (val == null || val.isEmpty()) {
            val = "0";
        }
        return val;
    }

    public static String[] convertToArray(String js) {
        String rawCommand = js;
        int ptr = js.indexOf(40);
        int items = 0;
        int count = 0;
        StringBuilder finalValue = new StringBuilder();
        ArrayList<String> rawValues = new ArrayList<String>();
        if (ptr != -1) {
            String com = js.substring(0, ptr);
            rawValues.add(com);
            ++items;
            js = js.substring(ptr).trim();
            int charsAtEnd = 1;
            if (js.endsWith(";")) {
                ++charsAtEnd;
            }
            if (js.startsWith("(")) {
                js = js.substring(1, js.length() - charsAtEnd);
            } else {
                JSFunction.debug("Unknown args in " + rawCommand);
            }
        }
        StringTokenizer tokens = new StringTokenizer(js, "(,);", true);
        while (tokens.hasMoreTokens()) {
            StringBuilder nextValueStr = new StringBuilder(tokens.nextToken());
            while (tokens.hasMoreTokens() && nextValueStr.toString().startsWith("\"") && !nextValueStr.toString().endsWith("\"")) {
                nextValueStr.append(tokens.nextToken());
            }
            String nextValue = nextValueStr.toString();
            if (count == 0 && ",".equals(nextValue)) {
                rawValues.add(finalValue.toString());
                finalValue = new StringBuilder();
                ++items;
                continue;
            }
            if ("(".equals(nextValue)) {
                ++count;
            } else if (")".equals(nextValue)) {
                --count;
            }
            finalValue.append(nextValue);
        }
        rawValues.add(finalValue.toString());
        String[] values = new String[++items];
        for (int ii = 0; ii < items; ++ii) {
            values[ii] = ((String)rawValues.get(ii)).trim();
        }
        return values;
    }

    private static String padString(String rawVal, int maxLen) {
        int length = rawVal.length();
        if (maxLen == length) {
            return rawVal;
        }
        if (maxLen < length) {
            return rawVal;
        }
        StringBuilder paddedString = new StringBuilder();
        int extraChars = maxLen - length;
        for (int jj = 0; jj < extraChars; ++jj) {
            paddedString.append('0');
        }
        paddedString.append(rawVal);
        return paddedString.toString();
    }

    void maskAlert(int code, Object[] args) {
        String validValue = this.formObject.getLastValidValue();
        if (validValue == null) {
            validValue = "";
        }
        this.formObject.setLastValidValue(validValue);
        this.formObject.updateValue(validValue, false, true);
        if (((String)args[0]).contains(" R")) {
            args[0] = this.formObject.getTextStreamValue(36);
        }
        JSFunction.reportError(code, args);
    }

    String validateMask(String[] args, String separator, boolean useDefaultValues) {
        String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        int[] monthsCount = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int monthMod = 1;
        int monthValue = 0;
        int dayValue = 0;
        String validValue = null;
        int count = args.length;
        if (count != 2) {
            JSFunction.debug("Unexpected values items=" + count + '{' + JSFunction.asString(count, args) + '}');
        } else {
            int d;
            String mask;
            String endText;
            boolean isValid = true;
            String formData = (String)this.formObject.getFormValue();
            if (formData == null || formData.isEmpty()) {
                return "";
            }
            int space = formData.lastIndexOf(32);
            if (space != -1 && ("am".equals(endText = formData.substring(space + 1).toLowerCase().trim()) || "pm".equals(endText))) {
                formData = formData.substring(0, space);
            }
            if ((mask = JSFunction.stripQuotes(args[1])).charAt((d = mask.indexOf(100)) + 1) != 'd') {
                mask = mask.replaceFirst("d", "dd");
            }
            StringTokenizer maskValues = new StringTokenizer(mask, separator, true);
            StringTokenizer formValues = new StringTokenizer(formData, separator, true);
            StringBuilder finalValue = new StringBuilder();
            while (maskValues.hasMoreTokens()) {
                String nextMask;
                String paddedValue = "";
                while (separator.contains(nextMask = maskValues.nextToken()) && maskValues.hasMoreTokens()) {
                    finalValue.append(nextMask);
                }
                String nextVal = JSFunction.getNextValue(separator, formValues);
                String nextSep = maskValues.hasMoreTokens() ? maskValues.nextToken() : null;
                if (nextVal != null) {
                    paddedValue = JSFunction.padString(nextVal, nextMask.length());
                }
                switch (nextMask) {
                    case "h": {
                        if (useDefaultValues && nextVal == null) {
                            paddedValue = String.valueOf(LocalDateTime.now().get(ChronoField.HOUR_OF_AMPM));
                        } else if (nextVal != null) {
                            paddedValue = JSFunction.padString(nextVal, 2);
                        }
                        isValid = JSFunction.verifyNumberInRange(paddedValue, 11);
                        break;
                    }
                    case "HH": {
                        if (useDefaultValues && nextVal == null) {
                            paddedValue = JSFunction.padString(String.valueOf(LocalDateTime.now().getHour()), 2);
                        }
                        isValid = JSFunction.verifyNumberInRange(paddedValue, 23);
                        break;
                    }
                    case "MM": {
                        if (useDefaultValues && nextVal == null) {
                            paddedValue = JSFunction.padString(String.valueOf(LocalDateTime.now().getMinute()), 2);
                        }
                        isValid = JSFunction.verifyNumberInRange(paddedValue, 59);
                        break;
                    }
                    case "mm": 
                    case "m": {
                        int idx;
                        isValid = JSFunction.verifyNumberInRange(paddedValue, 12);
                        if (!isValid) break;
                        int numVal = Integer.parseInt(paddedValue);
                        if (paddedValue.length() != nextMask.length() && nextMask.length() == 1) {
                            paddedValue = String.valueOf(numVal);
                        }
                        if ((idx = numVal - 1) != 1 || monthMod <= 0) break;
                        --monthMod;
                        break;
                    }
                    case "tt": {
                        if (useDefaultValues && nextVal == null) {
                            paddedValue = "am";
                        }
                        isValid = "am".equalsIgnoreCase(paddedValue) || "pm".equalsIgnoreCase(paddedValue);
                        break;
                    }
                    case "ss": {
                        if (useDefaultValues && nextVal == null) {
                            paddedValue = JSFunction.padString(String.valueOf(LocalDateTime.now().getSecond()), 2);
                        }
                        isValid = JSFunction.verifyNumberInRange(paddedValue, 59);
                        break;
                    }
                    case "dd": 
                    case "d": {
                        isValid = JSFunction.verifyNumberInRange(paddedValue, 31);
                        if (!isValid) break;
                        dayValue = Integer.parseInt(paddedValue);
                        break;
                    }
                    case "yyyy": 
                    case "yy": {
                        if (useDefaultValues && nextVal == null) {
                            nextVal = String.valueOf(LocalDateTime.now().getYear());
                            isValid = JSFunction.verifyNumberInRange(nextVal, 9999);
                        } else if (nextVal != null) {
                            if (nextMask.length() != nextVal.length()) {
                                if (nextMask.length() > nextVal.length()) {
                                    isValid = false;
                                } else if (nextVal.length() == 4) {
                                    isValid = JSFunction.verifyNumberInRange(nextVal, 9999);
                                    nextVal = nextVal.substring(2);
                                }
                            } else {
                                isValid = JSFunction.verifyNumberInRange(nextVal, 9999);
                            }
                        }
                        if (nextVal != null && isValid && Integer.parseInt(nextVal) % 4 != 0 && monthMod > 0) {
                            --monthMod;
                        }
                        paddedValue = nextVal;
                        break;
                    }
                    case "mmm": 
                    case "mmmm": {
                        int idx = -1;
                        if (nextVal != null && nextVal.length() >= 3) {
                            for (int i = 0; i != months.length; ++i) {
                                String month;
                                nextVal = nextVal.toLowerCase();
                                int length = 3;
                                if (!(nextVal = nextVal.substring(0, 3).toLowerCase()).equals(month = months[i].substring(0, 3).toLowerCase())) continue;
                                idx = i;
                            }
                        }
                        if (idx == -1 && nextVal != null) {
                            idx = Integer.parseInt(nextVal) - 1;
                            if (idx < 12) {
                                paddedValue = months[idx];
                            }
                        } else {
                            paddedValue = months[idx];
                        }
                        if (idx != 1 && monthMod > 0) {
                            --monthMod;
                        }
                        if (idx > 11) {
                            isValid = false;
                            break;
                        }
                        monthValue = idx;
                        break;
                    }
                    default: {
                        JSFunction.debug("Mask value >" + nextMask + "< not implemented");
                        isValid = false;
                    }
                }
                if (!isValid) break;
                finalValue.append(paddedValue);
                if (nextSep == null) continue;
                finalValue.append(nextSep);
            }
            if (dayValue > monthsCount[monthValue] + monthMod) {
                isValid = false;
            }
            if (isValid) {
                validValue = finalValue.toString();
            }
        }
        return validValue;
    }

    private static String asString(int count, String[] args) {
        StringBuilder list = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if (i == 0) {
                list = new StringBuilder(args[0]);
                continue;
            }
            list.append(',').append(args[i]);
        }
        return list.toString();
    }

    private static String getNextValue(String separator, StringTokenizer formValues) {
        String nextVal;
        while ((nextVal = !formValues.hasMoreTokens() ? null : formValues.nextToken()) != null && separator.contains(nextVal) && formValues.hasMoreTokens()) {
        }
        return nextVal;
    }

    private static boolean verifyNumberInRange(String nextVal, int max) {
        boolean valid = true;
        if (nextVal == null || JSFunction.isNotNumber(nextVal)) {
            valid = false;
        } else {
            int number = Integer.parseInt(nextVal);
            if (number < 0 || number > max) {
                valid = false;
            }
        }
        return valid;
    }

    static String stripQuotes(String arg) {
        if (arg.startsWith("\"")) {
            arg = arg.substring(1, arg.length() - 1);
        }
        if (arg.startsWith("\\u")) {
            String unicodeVal = arg.substring(2);
            if (unicodeVal.endsWith(" ")) {
                unicodeVal = unicodeVal.substring(0, unicodeVal.length() - 1);
            }
            arg = String.valueOf((char)Integer.parseInt(unicodeVal, 16)).intern();
        } else if (arg.startsWith("\\")) {
            String unicodeVal = arg.substring(1);
            arg = String.valueOf((char)Integer.parseInt(unicodeVal, 8)).intern();
        }
        return arg;
    }

    static boolean isNotNumber(String nextVal) {
        if (nextVal.isEmpty()) {
            return true;
        }
        boolean notNumber = false;
        char[] chars = nextVal.toCharArray();
        int count = chars.length;
        for (int ii = 0; ii < count; ++ii) {
            if (chars[ii] == '.' || chars[ii] == '-' || chars[ii] == ',' || chars[ii] >= '0' && chars[ii] <= '9') continue;
            ii = count;
            notNumber = true;
        }
        return notNumber;
    }

    public String getValue() {
        return this.value;
    }

    public int execute(String js, String[] args, int type, int eventType, char keyPressed) {
        return 0;
    }

    String parseJSvariables(String arg) {
        String methodToFind = "this.getField(";
        int start = arg.indexOf("this.getField(");
        if (start != -1) {
            int finish;
            int nameSt = start + "this.getField(".length();
            String name = arg.substring(nameSt, finish = arg.indexOf(41, nameSt));
            if (name.startsWith("\"")) {
                name = name.substring(1, name.length() - 1);
            }
            String valStr = ".value";
            if (arg.indexOf(".value", finish + 1) != -1) {
                finish = arg.indexOf(".value", finish + 1) + ".value".length();
                FormObject field = this.acro.getFormObject(name);
                arg = arg.substring(0, start) + field.getValue() + arg.substring(finish);
            }
        }
        if (!StringUtils.isNumber(arg)) {
            block9: for (int i = 0; i < arg.length(); ++i) {
                switch (arg.charAt(i)) {
                    case '%': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '/': {
                        double newValue;
                        double firstNum = Double.parseDouble(arg.substring(0, i));
                        String nextNum = JSFunction.getNextNum(arg, i + 1);
                        double secondNum = Double.parseDouble(nextNum);
                        switch (arg.charAt(i)) {
                            case '*': {
                                newValue = firstNum * secondNum;
                                break;
                            }
                            case '/': {
                                newValue = firstNum / secondNum;
                                break;
                            }
                            case '-': {
                                newValue = firstNum - secondNum;
                                break;
                            }
                            case '%': {
                                newValue = firstNum % secondNum;
                                break;
                            }
                            default: {
                                newValue = firstNum + secondNum;
                            }
                        }
                        arg = newValue + arg.substring(i + 1 + nextNum.length());
                        if (StringUtils.isNumber(arg)) break block9;
                    }
                    default: {
                        continue block9;
                    }
                }
            }
        }
        return arg;
    }

    private static String getNextNum(String arg, int s) {
        int f = -1;
        block3: for (int i = s; i < arg.length(); ++i) {
            switch (arg.charAt(i)) {
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block3;
                }
                default: {
                    f = i;
                    break block3;
                }
            }
        }
        if (f == -1) {
            f = arg.length();
        }
        return arg.substring(s, f);
    }

    private static void reportError(int code, Object[] args) {
        if (!DecoderOptions.showErrorMessages) {
            return;
        }
        switch (code) {
            case 1: {
                JOptionPane.showMessageDialog(null, "The values entered does not match the format of the field [" + args[0] + " ]", "Warning: Javascript Window", 1);
                break;
            }
            case 2: {
                JOptionPane.showMessageDialog(null, "Invalid date/time: please ensure that the date/time exists. Field [" + args[0] + " ] should match format " + args[1], "Warning: Javascript Window", 1);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                JOptionPane.showMessageDialog(null, args[1], "Warning: Javascript Window", 1);
                break;
            }
            default: {
                JOptionPane.showMessageDialog(null, "The values entered does not match the format of the field", "Warning: Javascript Window", 1);
            }
        }
    }
}

