/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.actions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public final class SoundHandler {
    private static final int EXTERNAL_BUFFER_SIZE = 128000;
    private final int frameSize;
    private final float sampleRate;
    private final int sampleSizeInBits;
    private final int channels;
    private final AudioFormat.Encoding encoding;
    private final byte[] data;

    private SoundHandler(PdfObject soundObj) throws Exception {
        int B2;
        int C = soundObj.getInt(19);
        if (C == -1) {
            C = 1;
        }
        if ((B2 = soundObj.getInt(18)) == -1) {
            B2 = 8;
        }
        float R = soundObj.getInt(34);
        int E = soundObj.getNameAsConstant(21);
        if (E == -1) {
            E = 1551661165;
        }
        switch (E) {
            case 926832749: {
                this.encoding = AudioFormat.Encoding.PCM_SIGNED;
                break;
            }
            case 1551661165: {
                this.encoding = AudioFormat.Encoding.PCM_UNSIGNED;
                break;
            }
            default: {
                throw new Exception("AudioFormat currently unsupported! - ");
            }
        }
        this.sampleSizeInBits = B2;
        this.sampleRate = R;
        this.channels = C;
        this.frameSize = this.sampleSizeInBits / 8 * this.channels;
        this.data = soundObj.getDecodedStream();
    }

    private int getLength() {
        return this.data.length / this.frameSize;
    }

    private byte[] getData() {
        return this.data;
    }

    private AudioFormat getAudioFormat() {
        int frameRate = (int)this.sampleRate;
        return new AudioFormat(this.encoding, this.sampleRate, this.sampleSizeInBits, this.channels, this.frameSize, frameRate, true);
    }

    public static AudioInputStream getAudioInputStream(PdfObject soundObj) throws Exception {
        SoundHandler soundHandler = new SoundHandler(soundObj);
        AudioFormat audioFormat = soundHandler.getAudioFormat();
        long length = soundHandler.getLength();
        byte[] data = soundHandler.getData();
        return new AudioInputStream(new ByteArrayInputStream(data), audioFormat, length);
    }

    public static void play(PdfObject soundObj) throws Exception {
        SoundHandler.playSoundFromStream(SoundHandler.getAudioInputStream(soundObj));
    }

    private static void playSoundFromStream(AudioInputStream ais) {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, ais.getFormat());
        try (SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);){
            line.open(ais.getFormat());
            line.start();
            int nBytesRead = 0;
            byte[] abData = new byte[128000];
            while (nBytesRead != -1) {
                try {
                    nBytesRead = ais.read(abData, 0, abData.length);
                }
                catch (IOException e) {
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
                if (nBytesRead < 0) continue;
                line.write(abData, 0, nBytesRead);
            }
            line.drain();
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
    }
}

