/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.IOException;
import org.jpedal.io.RandomAccessBuffer;

public class RandomAccessDataBuffer
implements RandomAccessBuffer {
    private byte[] data;
    private long pointer;
    private int paddingAtStartOfFile;

    public RandomAccessDataBuffer(byte[] data) {
        this.data = data;
        this.pointer = -1L;
    }

    @Override
    public void setPaddingAtStartOfFile(int paddingAtStartOfFile) {
        this.paddingAtStartOfFile = paddingAtStartOfFile;
    }

    @Override
    public long getFilePointer() {
        return this.pointer;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (!this.checkPos(pos += (long)this.paddingAtStartOfFile)) {
            throw new IOException("Position out of bounds");
        }
        this.pointer = pos;
    }

    @Override
    public void close() {
        this.data = null;
        this.pointer = -1L;
    }

    @Override
    public long length() throws IOException {
        if (this.data != null) {
            return this.data.length;
        }
        throw new IOException("Data buffer not initialized.");
    }

    @Override
    public int read() throws IOException {
        if (this.checkPos(this.pointer)) {
            return RandomAccessDataBuffer.b2i(this.data[(int)this.pointer++]);
        }
        return -1;
    }

    private int peek() throws IOException {
        if (this.checkPos(this.pointer)) {
            return RandomAccessDataBuffer.b2i(this.data[(int)this.pointer]);
        }
        return -1;
    }

    @Override
    public String readLine() throws IOException {
        int c;
        if (this.pointer >= (long)(this.data.length - 1)) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        while ((c = this.read()) >= 0) {
            if (c == 10 || c == 13) {
                if (this.peek() != 10 && this.peek() != 13 || this.peek() == c) break;
                this.read();
                break;
            }
            buf.append((char)c);
        }
        return buf.toString();
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.data == null) {
            throw new IOException("Data buffer not initialized.");
        }
        if (this.pointer < 0L || this.pointer >= (long)this.data.length) {
            return -1;
        }
        int length = Math.min(b.length, this.data.length - (int)this.pointer);
        for (int i = 0; i < length; ++i) {
            b[i] = this.data[(int)this.pointer++];
        }
        return length;
    }

    private static int b2i(byte b) {
        if (b >= 0) {
            return b;
        }
        return 256 + b;
    }

    private boolean checkPos(long pos) throws IOException {
        return pos >= 0L && pos < this.length();
    }

    @Override
    public byte[] getPdfBuffer() {
        return this.data;
    }

    @Override
    public String getTempFileName() {
        return "";
    }
}

