/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.color.ColorspaceFactory;
import org.jpedal.function.PDFCalculator;
import org.jpedal.function.PDFExponential;
import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;
import org.jpedal.function.PDFSampled;
import org.jpedal.function.PDFStitching;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;

public final class FunctionFactory {
    private FunctionFactory() {
    }

    public static PDFFunction getFunction(PdfObject functionObj, PdfObjectReader currentPdfFile) {
        PDFGenericFunction newFunction = null;
        byte[] stream = functionObj.getDecodedStream();
        float[] domain = functionObj.getFloatArray(1026641277);
        float[] range = functionObj.getFloatArray(826160983);
        int type = functionObj.getInt(2127019430);
        int bits = functionObj.getInt(-1413045608);
        float[] decode = functionObj.getFloatArray(859785322);
        float[] C0 = functionObj.getFloatArray(4864);
        float[] C1 = functionObj.getFloatArray(4865);
        int[] size = functionObj.getIntArray(590957109);
        float[] encode = functionObj.getFloatArray(859785587);
        float[] bounds = functionObj.getFloatArray(1161709186);
        float N2 = 0.0f;
        float newN = functionObj.getFloatNumber(30);
        if (newN != -1.0f) {
            N2 = newN;
        }
        PdfArrayIterator keys = functionObj.getMixedArray(2122150301);
        int functionCount = 0;
        if (keys != null) {
            functionCount = keys.getTokenCount();
        }
        PDFFunction[] functions = null;
        if (keys != null) {
            PdfObject[] subFunction = new PdfObject[functionCount];
            for (int i = 0; i < functionCount; ++i) {
                subFunction[i] = ColorspaceFactory.getFunctionObjectFromRefOrDirect(currentPdfFile, keys.getNextValueAsByte(true));
            }
            functions = new PDFFunction[subFunction.length];
            int imax = subFunction.length;
            for (int i1 = 0; i1 < imax; ++i1) {
                functions[i1] = FunctionFactory.getFunction(subFunction[i1], currentPdfFile);
            }
        }
        switch (type) {
            case 0: {
                newFunction = new PDFSampled(stream, bits, domain, range, encode, decode, size);
                break;
            }
            case 2: {
                newFunction = new PDFExponential(N2, C0, C1, domain, range);
                break;
            }
            case 3: {
                newFunction = new PDFStitching(functions, encode, bounds, domain, range);
                break;
            }
            case 4: {
                newFunction = new PDFCalculator(stream, domain, range);
            }
        }
        return newFunction;
    }
}

