/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import org.jpedal.fonts.Type1C;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.T1Glyphs;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

class CFF
extends Table {
    private final PdfJavaGlyphs glyphs;
    private boolean hasCFFdata;
    private double[] FontMatrix;

    CFF(FontFile2 currentFontFile, boolean isCID) {
        int startPointer;
        this.glyphs = new T1Glyphs(isCID);
        if (isCID) {
            this.glyphs.init(65536, true);
        }
        if ((startPointer = currentFontFile.selectTable(16)) != 0) {
            try {
                int length = currentFontFile.getTableSize(16);
                byte[] data = currentFontFile.readBytes(startPointer, length);
                Type1C cff = new Type1C(data, null, this.glyphs);
                this.FontMatrix = cff.FontMatrix;
                this.hasCFFdata = true;
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }

    public boolean hasCFFData() {
        return this.hasCFFdata;
    }

    public double[] getFontMatrix() {
        return this.FontMatrix;
    }

    public PdfGlyph getCFFGlyph(String glyph, float[][] Trm, int rawInt, String displayValue, float currentWidth, String key) {
        return this.glyphs.getEmbeddedGlyph(glyph, Trm, rawInt, displayValue, currentWidth, key);
    }
}

